/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.taglib;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.apache.logging.log4j.spi.LoggerRegistry;
import org.apache.logging.log4j.taglib.Log4jTaglibLogger;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class Log4jTaglibLoggerContext
implements LoggerContext {
    private static final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    private static final Lock READ_LOCK = LOCK.readLock();
    private static final Lock WRITE_LOCK = LOCK.writeLock();
    private static final Map<ServletContext, Log4jTaglibLoggerContext> LOGGER_CONTEXT_BY_SERVLET_CONTEXT = new WeakHashMap<ServletContext, Log4jTaglibLoggerContext>();
    private static final MessageFactory DEFAULT_MESSAGE_FACTORY = ParameterizedMessageFactory.INSTANCE;
    private final LoggerRegistry<Log4jTaglibLogger> loggerRegistry = new LoggerRegistry();
    private final ServletContext servletContext;

    private Log4jTaglibLoggerContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Object getExternalContext() {
        return this.servletContext;
    }

    public Log4jTaglibLogger getLogger(String name) {
        return this.getLogger(name, DEFAULT_MESSAGE_FACTORY);
    }

    public Log4jTaglibLogger getLogger(String name, @Nullable MessageFactory messageFactory) {
        MessageFactory effectiveMessageFactory = messageFactory != null ? messageFactory : DEFAULT_MESSAGE_FACTORY;
        Log4jTaglibLogger oldLogger = (Log4jTaglibLogger)this.loggerRegistry.getLogger(name, effectiveMessageFactory);
        if (oldLogger != null) {
            return oldLogger;
        }
        Log4jTaglibLogger newLogger = this.createLogger(name, effectiveMessageFactory);
        this.loggerRegistry.putIfAbsent(name, effectiveMessageFactory, (ExtendedLogger)newLogger);
        return (Log4jTaglibLogger)this.loggerRegistry.getLogger(name, effectiveMessageFactory);
    }

    private Log4jTaglibLogger createLogger(String name, MessageFactory messageFactory) {
        LoggerContext loggerContext = LogManager.getContext((boolean)false);
        ExtendedLogger delegateLogger = loggerContext.getLogger(name, messageFactory);
        return new Log4jTaglibLogger(delegateLogger, name, delegateLogger.getMessageFactory());
    }

    public boolean hasLogger(String name) {
        return this.loggerRegistry.hasLogger(name, DEFAULT_MESSAGE_FACTORY);
    }

    public boolean hasLogger(String name, @Nullable MessageFactory messageFactory) {
        MessageFactory effectiveMessageFactory = messageFactory != null ? messageFactory : DEFAULT_MESSAGE_FACTORY;
        return this.loggerRegistry.hasLogger(name, effectiveMessageFactory);
    }

    public boolean hasLogger(String name, Class<? extends MessageFactory> messageFactoryClass) {
        return this.loggerRegistry.hasLogger(name, messageFactoryClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Log4jTaglibLoggerContext getInstance(ServletContext servletContext) {
        READ_LOCK.lock();
        try {
            Log4jTaglibLoggerContext loggerContext = LOGGER_CONTEXT_BY_SERVLET_CONTEXT.get(servletContext);
            if (loggerContext != null) {
                Log4jTaglibLoggerContext log4jTaglibLoggerContext = loggerContext;
                return log4jTaglibLoggerContext;
            }
        }
        finally {
            READ_LOCK.unlock();
        }
        WRITE_LOCK.lock();
        try {
            Log4jTaglibLoggerContext log4jTaglibLoggerContext = LOGGER_CONTEXT_BY_SERVLET_CONTEXT.computeIfAbsent(servletContext, Log4jTaglibLoggerContext::new);
            return log4jTaglibLoggerContext;
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }
}

