/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.email;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.SearchTerm;

public class EmailSession {
    protected final String server;
    protected final int port;
    protected final String username;
    protected final String password;
    protected final String protocol;
    protected final Properties properties;
    private Session session = null;
    private Store store = null;

    public EmailSession(String server, int port, String username, String password, String protocol, Properties properties) throws MessagingException {
        this.server = server;
        this.port = port;
        this.username = username;
        this.password = password;
        this.protocol = protocol;
        this.properties = properties;
        Session thisSession = Session.getDefaultInstance((Properties)properties, null);
        Store thisStore = thisSession.getStore(protocol);
        thisStore.connect(server, port, username, password);
        this.session = thisSession;
        this.store = thisStore;
    }

    public String[] listFolders() throws MessagingException {
        if (this.store != null) {
            Folder[] folders;
            ArrayList<String> folderList = new ArrayList<String>();
            for (Folder folder : folders = this.store.getDefaultFolder().list("*")) {
                if ((folder.getType() & 1) == 0) continue;
                folderList.add(folder.getFullName());
            }
            Object[] rval = folderList.toArray(new String[0]);
            Arrays.sort(rval);
            return rval;
        }
        return null;
    }

    public void checkConnection() throws MessagingException {
        if (this.store != null && this.store.getDefaultFolder() == null) {
            throw new MessagingException("Error checking the connection: No default folder.");
        }
    }

    public Folder openFolder(String folderName) throws MessagingException {
        if (this.store != null) {
            Folder thisFolder = this.store.getFolder(folderName);
            thisFolder.open(1);
            return thisFolder;
        }
        return null;
    }

    public void closeFolder(Folder folder) throws MessagingException {
        folder.close(false);
    }

    public Message[] getMessages(Folder folder) throws MessagingException {
        return folder.getMessages();
    }

    public Message[] search(Folder folder, SearchTerm searchTerm) throws MessagingException {
        return folder.search(searchTerm);
    }

    public void close() throws MessagingException {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        this.session = null;
    }
}

