/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.mapping.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.Property;
import org.exolab.castor.mapping.xml.types.BindXmlAutoNamingType;
import org.exolab.castor.mapping.xml.types.BindXmlNodeType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class BindXml
implements Serializable {
    private String _name;
    private String _type;
    private BindXmlAutoNamingType _autoNaming;
    private String _location;
    private String _matches;
    private boolean _reference;
    private boolean _has_reference;
    private BindXmlNodeType _node;
    private String _QNamePrefix;
    private boolean _transient;
    private boolean _has_transient;
    private ClassMapping _classMapping;
    private ArrayList _propertyList = new ArrayList();

    public void addProperty(Property vProperty) throws IndexOutOfBoundsException {
        this._propertyList.add(vProperty);
    }

    public void addProperty(int index, Property vProperty) throws IndexOutOfBoundsException {
        this._propertyList.add(index, vProperty);
    }

    public void clearProperty() {
        this._propertyList.clear();
    }

    public void deleteReference() {
        this._has_reference = false;
    }

    public void deleteTransient() {
        this._has_transient = false;
    }

    public Enumeration enumerateProperty() {
        return Collections.enumeration(this._propertyList);
    }

    public BindXmlAutoNamingType getAutoNaming() {
        return this._autoNaming;
    }

    public ClassMapping getClassMapping() {
        return this._classMapping;
    }

    public String getLocation() {
        return this._location;
    }

    public String getMatches() {
        return this._matches;
    }

    public String getName() {
        return this._name;
    }

    public BindXmlNodeType getNode() {
        return this._node;
    }

    public Property getProperty(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._propertyList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Property)this._propertyList.get(index);
    }

    public Property[] getProperty() {
        int size = this._propertyList.size();
        Property[] mArray = new Property[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Property)this._propertyList.get(index);
        }
        return mArray;
    }

    public int getPropertyCount() {
        return this._propertyList.size();
    }

    public String getQNamePrefix() {
        return this._QNamePrefix;
    }

    public boolean getReference() {
        return this._reference;
    }

    public boolean getTransient() {
        return this._transient;
    }

    public String getType() {
        return this._type;
    }

    public boolean hasReference() {
        return this._has_reference;
    }

    public boolean hasTransient() {
        return this._has_transient;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, handler);
    }

    public boolean removeProperty(Property vProperty) {
        boolean removed = this._propertyList.remove(vProperty);
        return removed;
    }

    public void setAutoNaming(BindXmlAutoNamingType autoNaming) {
        this._autoNaming = autoNaming;
    }

    public void setClassMapping(ClassMapping classMapping) {
        this._classMapping = classMapping;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public void setMatches(String matches) {
        this._matches = matches;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setNode(BindXmlNodeType node) {
        this._node = node;
    }

    public void setProperty(int index, Property vProperty) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._propertyList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._propertyList.set(index, vProperty);
    }

    public void setProperty(Property[] propertyArray) {
        this._propertyList.clear();
        for (int i = 0; i < propertyArray.length; ++i) {
            this._propertyList.add(propertyArray[i]);
        }
    }

    public void setQNamePrefix(String QNamePrefix) {
        this._QNamePrefix = QNamePrefix;
    }

    public void setReference(boolean reference) {
        this._reference = reference;
        this._has_reference = true;
    }

    public void setTransient(boolean _transient) {
        this._transient = _transient;
        this._has_transient = true;
    }

    public void setType(String type) {
        this._type = type;
    }

    public static BindXml unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (BindXml)Unmarshaller.unmarshal(BindXml.class, reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate(this);
    }
}

