/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.manifoldcf.scriptengine.BasicTokenStream;
import org.apache.manifoldcf.scriptengine.BreakCommand;
import org.apache.manifoldcf.scriptengine.Command;
import org.apache.manifoldcf.scriptengine.ContextVariableReference;
import org.apache.manifoldcf.scriptengine.DELETECommand;
import org.apache.manifoldcf.scriptengine.ErrorCommand;
import org.apache.manifoldcf.scriptengine.GETCommand;
import org.apache.manifoldcf.scriptengine.IfCommand;
import org.apache.manifoldcf.scriptengine.InsertCommand;
import org.apache.manifoldcf.scriptengine.NewArray;
import org.apache.manifoldcf.scriptengine.NewConfiguration;
import org.apache.manifoldcf.scriptengine.NewConfigurationNode;
import org.apache.manifoldcf.scriptengine.NewConnectionName;
import org.apache.manifoldcf.scriptengine.NewDictionary;
import org.apache.manifoldcf.scriptengine.NewOperation;
import org.apache.manifoldcf.scriptengine.NewQueryArgument;
import org.apache.manifoldcf.scriptengine.NewURL;
import org.apache.manifoldcf.scriptengine.NullVariableReference;
import org.apache.manifoldcf.scriptengine.POSTCommand;
import org.apache.manifoldcf.scriptengine.PUTCommand;
import org.apache.manifoldcf.scriptengine.PrintCommand;
import org.apache.manifoldcf.scriptengine.RemoveCommand;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.SetCommand;
import org.apache.manifoldcf.scriptengine.Token;
import org.apache.manifoldcf.scriptengine.TokenStream;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableArray;
import org.apache.manifoldcf.scriptengine.VariableBoolean;
import org.apache.manifoldcf.scriptengine.VariableConfiguration;
import org.apache.manifoldcf.scriptengine.VariableConfigurationNode;
import org.apache.manifoldcf.scriptengine.VariableFloat;
import org.apache.manifoldcf.scriptengine.VariableInt;
import org.apache.manifoldcf.scriptengine.VariableReference;
import org.apache.manifoldcf.scriptengine.VariableString;
import org.apache.manifoldcf.scriptengine.WaitCommand;
import org.apache.manifoldcf.scriptengine.WhileCommand;

public class ScriptParser {
    protected HttpClientConnectionManager connectionManager = null;
    protected HttpClient httpClient = null;
    protected Integer httpClientLock = new Integer(0);
    protected Map<String, ContextVariableReference> context = new HashMap<String, ContextVariableReference>();
    protected Map<String, Command> commands = new HashMap<String, Command>();
    protected Map<String, NewOperation> newOperations = new HashMap<String, NewOperation>();
    protected static final int STATEMENT_NOTME = 0;
    protected static final int STATEMENT_ISME = 1;
    protected static final int STATEMENT_BREAK = 2;

    public void addCommand(String commandName, Command command) {
        this.commands.put(commandName, command);
    }

    public void addNewOperation(String operationName, NewOperation operation) {
        this.newOperations.put(operationName, operation);
    }

    public void addVariable(String variableName, Variable v) throws ScriptException {
        ContextVariableReference cvr = new ContextVariableReference();
        cvr.setReference(v);
        this.context.put(variableName, cvr);
    }

    public void execute(TokenStream currentStream) throws ScriptException {
        Token t;
        if (this.parseStatements(currentStream)) {
            ScriptParser.localError(currentStream, "Break command must be inside a loop");
        }
        if ((t = currentStream.peek()) != null) {
            ScriptParser.localError(currentStream, "Characters after end of script");
        }
    }

    public boolean parseStatements(TokenStream currentStream) throws ScriptException {
        boolean breakSignal = false;
        while (true) {
            if (breakSignal) {
                if (this.skipStatement(currentStream)) continue;
                break;
            }
            int result = this.parseStatement(currentStream);
            if (result == 0) break;
            if (result != 2) continue;
            breakSignal = true;
        }
        return breakSignal;
    }

    public void skipStatements(TokenStream currentStream) throws ScriptException {
        while (this.skipStatement(currentStream)) {
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int parseStatement(TokenStream currentStream) throws ScriptException {
        int rval = 1;
        Token command = currentStream.peek();
        if (command == null) {
            return 0;
        }
        String commandString = command.getToken();
        if (commandString == null) {
            return 0;
        }
        Token t = currentStream.peek();
        if (t == null || t.getToken() == null) return 0;
        Command c = this.commands.get(t.getToken());
        if (c == null) return 0;
        currentStream.skip();
        rval = c.parseAndExecute(this, currentStream) ? 2 : 1;
        Token semi = currentStream.peek();
        if (semi == null || semi.getPunctuation() == null || !semi.getPunctuation().equals(";")) {
            ScriptParser.syntaxError(currentStream, "Missing semicolon");
        }
        currentStream.skip();
        return rval;
    }

    protected boolean skipStatement(TokenStream currentStream) throws ScriptException {
        Command c;
        Token command = currentStream.peek();
        if (command == null) {
            return false;
        }
        String commandString = command.getToken();
        if (commandString == null) {
            return false;
        }
        Token t = currentStream.peek();
        if (t != null && t.getToken() != null) {
            c = this.commands.get(t.getToken());
            if (c == null) {
                return false;
            }
        } else {
            return false;
        }
        currentStream.skip();
        c.parseAndSkip(this, currentStream);
        Token semi = currentStream.peek();
        if (semi == null || semi.getPunctuation() == null || !semi.getPunctuation().equals(";")) {
            ScriptParser.syntaxError(currentStream, "Missing semicolon");
        }
        currentStream.skip();
        return true;
    }

    public VariableReference evaluateExpression(TokenStream currentStream) throws ScriptException {
        VariableReference vr = this.evaluateExpression_1(currentStream);
        if (vr == null) {
            return null;
        }
        while (true) {
            VariableReference v;
            Token t;
            if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("||")) {
                currentStream.skip();
                v = this.evaluateExpression_1(currentStream);
                if (v == null) {
                    ScriptParser.syntaxError(currentStream, "Missing expression after '||'");
                }
                vr = ScriptParser.resolveMustExist(currentStream, vr).doublePipe(v.resolve());
                continue;
            }
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("|")) break;
            currentStream.skip();
            v = this.evaluateExpression_1(currentStream);
            if (v == null) {
                ScriptParser.syntaxError(currentStream, "Missing expression after '|'");
            }
            vr = ScriptParser.resolveMustExist(currentStream, vr).pipe(v.resolve());
        }
        return vr;
    }

    public boolean skipExpression(TokenStream currentStream) throws ScriptException {
        if (!this.skipExpression_1(currentStream)) {
            return false;
        }
        while (true) {
            Token t;
            if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("||")) {
                currentStream.skip();
                if (this.skipExpression_1(currentStream)) continue;
                ScriptParser.syntaxError(currentStream, "Missing expression after '||'");
                continue;
            }
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("|")) break;
            currentStream.skip();
            if (this.skipExpression_1(currentStream)) continue;
            ScriptParser.syntaxError(currentStream, "Missing expression after '|'");
        }
        return true;
    }

    protected VariableReference evaluateExpression_1(TokenStream currentStream) throws ScriptException {
        VariableReference vr = this.evaluateExpression_2(currentStream);
        if (vr == null) {
            return null;
        }
        while (true) {
            VariableReference v;
            Token t;
            if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("&&")) {
                currentStream.skip();
                v = this.evaluateExpression_2(currentStream);
                if (v == null) {
                    ScriptParser.syntaxError(currentStream, "Missing expression after '&&'");
                }
                vr = ScriptParser.resolveMustExist(currentStream, vr).doubleAmpersand(v.resolve());
                continue;
            }
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("&")) break;
            currentStream.skip();
            v = this.evaluateExpression_2(currentStream);
            if (v == null) {
                ScriptParser.syntaxError(currentStream, "Missing expression after '&'");
            }
            vr = ScriptParser.resolveMustExist(currentStream, vr).ampersand(v.resolve());
        }
        return vr;
    }

    protected boolean skipExpression_1(TokenStream currentStream) throws ScriptException {
        if (!this.skipExpression_2(currentStream)) {
            return false;
        }
        while (true) {
            Token t;
            if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("&&")) {
                currentStream.skip();
                if (this.skipExpression_2(currentStream)) continue;
                ScriptParser.syntaxError(currentStream, "Missing expression after '&&'");
                continue;
            }
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("&")) break;
            currentStream.skip();
            if (this.skipExpression_2(currentStream)) continue;
            ScriptParser.syntaxError(currentStream, "Missing expression after '&'");
        }
        return true;
    }

    protected VariableReference evaluateExpression_2(TokenStream currentStream) throws ScriptException {
        Token t = currentStream.peek();
        if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("!")) {
            currentStream.skip();
            VariableReference v = this.evaluateExpression_2(currentStream);
            if (v == null) {
                ScriptParser.syntaxError(currentStream, "Missing expression after '!'");
            }
            return ScriptParser.resolveMustExist(currentStream, v).unaryExclamation();
        }
        return this.evaluateExpression_3(currentStream);
    }

    protected boolean skipExpression_2(TokenStream currentStream) throws ScriptException {
        Token t = currentStream.peek();
        if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("!")) {
            currentStream.skip();
            if (!this.skipExpression_2(currentStream)) {
                ScriptParser.syntaxError(currentStream, "Missing expression after '!'");
            }
            return true;
        }
        return this.skipExpression_3(currentStream);
    }

    protected VariableReference evaluateExpression_3(TokenStream currentStream) throws ScriptException {
        VariableReference vr = this.evaluateExpression_4(currentStream);
        if (vr == null) {
            return null;
        }
        while (true) {
            VariableReference v;
            Token t;
            if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("==")) {
                currentStream.skip();
                v = this.evaluateExpression_4(currentStream);
                if (v == null) {
                    ScriptParser.syntaxError(currentStream, "Missing expression after '=='");
                }
                vr = ScriptParser.resolveMustExist(currentStream, vr).doubleEquals(v.resolve());
                continue;
            }
            if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("!=")) {
                currentStream.skip();
                v = this.evaluateExpression_4(currentStream);
                if (v == null) {
                    ScriptParser.syntaxError(currentStream, "Missing expression after '!='");
                }
                vr = ScriptParser.resolveMustExist(currentStream, vr).exclamationEquals(v.resolve());
                continue;
            }
            if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("<")) {
                currentStream.skip();
                v = this.evaluateExpression_4(currentStream);
                if (v == null) {
                    ScriptParser.syntaxError(currentStream, "Missing expression after '<'");
                }
                vr = ScriptParser.resolveMustExist(currentStream, vr).lesserAngle(v.resolve());
                continue;
            }
            if (t != null && t.getPunctuation() != null && t.getPunctuation().equals(">")) {
                currentStream.skip();
                v = this.evaluateExpression_4(currentStream);
                if (v == null) {
                    ScriptParser.syntaxError(currentStream, "Missing expression after '>'");
                }
                vr = ScriptParser.resolveMustExist(currentStream, vr).greaterAngle(v.resolve());
                continue;
            }
            if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("<=")) {
                currentStream.skip();
                v = this.evaluateExpression_4(currentStream);
                if (v == null) {
                    ScriptParser.syntaxError(currentStream, "Missing expression after '<='");
                }
                vr = ScriptParser.resolveMustExist(currentStream, vr).lesserAngleEquals(v.resolve());
                continue;
            }
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(">=")) break;
            currentStream.skip();
            v = this.evaluateExpression_4(currentStream);
            if (v == null) {
                ScriptParser.syntaxError(currentStream, "Missing expression after '>='");
            }
            vr = ScriptParser.resolveMustExist(currentStream, vr).greaterAngleEquals(v.resolve());
        }
        return vr;
    }

    protected boolean skipExpression_3(TokenStream currentStream) throws ScriptException {
        if (!this.skipExpression_4(currentStream)) {
            return false;
        }
        while (true) {
            Token t;
            if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("==")) {
                currentStream.skip();
                if (this.skipExpression_4(currentStream)) continue;
                ScriptParser.syntaxError(currentStream, "Missing expression after '=='");
                continue;
            }
            if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("!=")) {
                currentStream.skip();
                if (this.skipExpression_4(currentStream)) continue;
                ScriptParser.syntaxError(currentStream, "Missing expression after '!='");
                continue;
            }
            if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("<")) {
                currentStream.skip();
                if (this.skipExpression_4(currentStream)) continue;
                ScriptParser.syntaxError(currentStream, "Missing expression after '<'");
                continue;
            }
            if (t != null && t.getPunctuation() != null && t.getPunctuation().equals(">")) {
                currentStream.skip();
                if (this.skipExpression_4(currentStream)) continue;
                ScriptParser.syntaxError(currentStream, "Missing expression after '>'");
                continue;
            }
            if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("<=")) {
                currentStream.skip();
                if (this.skipExpression_4(currentStream)) continue;
                ScriptParser.syntaxError(currentStream, "Missing expression after '<='");
                continue;
            }
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(">=")) break;
            currentStream.skip();
            if (this.skipExpression_4(currentStream)) continue;
            ScriptParser.syntaxError(currentStream, "Missing expression after '>='");
        }
        return true;
    }

    protected VariableReference evaluateExpression_4(TokenStream currentStream) throws ScriptException {
        VariableReference vr = this.evaluateExpression_5(currentStream);
        if (vr == null) {
            return null;
        }
        while (true) {
            VariableReference v;
            Token t;
            if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("+")) {
                currentStream.skip();
                v = this.evaluateExpression_5(currentStream);
                if (v == null) {
                    ScriptParser.syntaxError(currentStream, "Missing expression after '+'");
                }
                vr = ScriptParser.resolveMustExist(currentStream, vr).plus(v.resolve());
                continue;
            }
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("-")) break;
            currentStream.skip();
            v = this.evaluateExpression_5(currentStream);
            if (v == null) {
                ScriptParser.syntaxError(currentStream, "Missing expression after '-'");
            }
            vr = ScriptParser.resolveMustExist(currentStream, vr).minus(v.resolve());
        }
        return vr;
    }

    protected boolean skipExpression_4(TokenStream currentStream) throws ScriptException {
        if (!this.skipExpression_5(currentStream)) {
            return false;
        }
        while (true) {
            Token t;
            if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("+")) {
                currentStream.skip();
                if (this.skipExpression_5(currentStream)) continue;
                ScriptParser.syntaxError(currentStream, "Missing expression after '+'");
                continue;
            }
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("-")) break;
            currentStream.skip();
            if (this.skipExpression_5(currentStream)) continue;
            ScriptParser.syntaxError(currentStream, "Missing expression after '-'");
        }
        return true;
    }

    protected VariableReference evaluateExpression_5(TokenStream currentStream) throws ScriptException {
        VariableReference vr = this.evaluateExpression_6(currentStream);
        if (vr == null) {
            return null;
        }
        while (true) {
            VariableReference v;
            Token t;
            if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("*")) {
                currentStream.skip();
                v = this.evaluateExpression_6(currentStream);
                if (v == null) {
                    ScriptParser.syntaxError(currentStream, "Missing expression after '*'");
                }
                vr = ScriptParser.resolveMustExist(currentStream, vr).asterisk(v.resolve());
                continue;
            }
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("/")) break;
            currentStream.skip();
            v = this.evaluateExpression_6(currentStream);
            if (v == null) {
                ScriptParser.syntaxError(currentStream, "Missing expression after '/'");
            }
            vr = ScriptParser.resolveMustExist(currentStream, vr).slash(v.resolve());
        }
        return vr;
    }

    protected boolean skipExpression_5(TokenStream currentStream) throws ScriptException {
        if (!this.skipExpression_6(currentStream)) {
            return false;
        }
        while (true) {
            Token t;
            if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("*")) {
                currentStream.skip();
                if (this.skipExpression_6(currentStream)) continue;
                ScriptParser.syntaxError(currentStream, "Missing expression after '*'");
                continue;
            }
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("/")) break;
            currentStream.skip();
            if (this.skipExpression_6(currentStream)) continue;
            ScriptParser.syntaxError(currentStream, "Missing expression after '/'");
        }
        return true;
    }

    protected VariableReference evaluateExpression_6(TokenStream currentStream) throws ScriptException {
        Token t = currentStream.peek();
        if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("-")) {
            currentStream.skip();
            VariableReference v = this.evaluateExpression_6(currentStream);
            if (v == null) {
                ScriptParser.syntaxError(currentStream, "Missing expression after '-'");
            }
            return ScriptParser.resolveMustExist(currentStream, v).unaryMinus();
        }
        return this.parseVariableReference(currentStream);
    }

    protected boolean skipExpression_6(TokenStream currentStream) throws ScriptException {
        Token t = currentStream.peek();
        if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("-")) {
            currentStream.skip();
            if (!this.skipExpression_6(currentStream)) {
                ScriptParser.syntaxError(currentStream, "Missing expression after '-'");
            }
            return true;
        }
        return this.skipVariableReference(currentStream);
    }

    protected VariableReference parseVariableReference(TokenStream currentStream) throws ScriptException {
        Token t = currentStream.peek();
        if (t != null && t.getToken() != null && t.getToken().equals("isnull")) {
            currentStream.skip();
            VariableReference reference = this.parseVariableReference(currentStream);
            if (reference == null) {
                ScriptParser.syntaxError(currentStream, "Missing variable reference");
            }
            return new VariableBoolean(reference.isNull());
        }
        return this.parseVariableReference_0(currentStream);
    }

    protected boolean skipVariableReference(TokenStream currentStream) throws ScriptException {
        Token t = currentStream.peek();
        if (t != null && t.getToken() != null && t.getToken().equals("isnull")) {
            currentStream.skip();
            if (!this.skipVariableReference(currentStream)) {
                ScriptParser.syntaxError(currentStream, "Missing variable reference");
            }
            return true;
        }
        return this.skipVariableReference_0(currentStream);
    }

    protected VariableReference parseVariableReference_0(TokenStream currentStream) throws ScriptException {
        VariableReference vr = this.parseVariableReference_1(currentStream);
        if (vr == null) {
            return vr;
        }
        while (true) {
            Token t;
            if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("[")) {
                currentStream.skip();
                VariableReference expression = this.evaluateExpression(currentStream);
                if (expression == null) {
                    ScriptParser.syntaxError(currentStream, "Missing expression after '['");
                }
                Variable v = ScriptParser.resolveMustExist(currentStream, vr);
                t = currentStream.peek();
                if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("]")) {
                    ScriptParser.syntaxError(currentStream, "Missing ']'");
                }
                currentStream.skip();
                vr = v.getIndexed(expression.resolve());
                continue;
            }
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(".")) break;
            currentStream.skip();
            t = currentStream.peek();
            if (t == null || t.getToken() == null) {
                ScriptParser.syntaxError(currentStream, "Need attribute name");
            }
            Variable v = ScriptParser.resolveMustExist(currentStream, vr);
            currentStream.skip();
            vr = v.getAttribute(t.getToken());
        }
        return vr;
    }

    protected VariableReference parseVariableReference_1(TokenStream currentStream) throws ScriptException {
        Token t = currentStream.peek();
        if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("(")) {
            currentStream.skip();
            VariableReference rval = this.evaluateExpression(currentStream);
            if (rval == null) {
                ScriptParser.syntaxError(currentStream, "Missing expression after '('");
            }
            if ((t = currentStream.peek()) == null || t.getPunctuation() == null || !t.getPunctuation().equals(")")) {
                ScriptParser.syntaxError(currentStream, "Missing ')'");
            }
            currentStream.skip();
            return rval;
        }
        if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("[")) {
            currentStream.skip();
            VariableArray va = new VariableArray();
            t = currentStream.peek();
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("]")) {
                while (true) {
                    VariableReference vr;
                    if ((vr = this.evaluateExpression(currentStream)) == null) {
                        ScriptParser.syntaxError(currentStream, "Missing expression in array initializer");
                    }
                    va.insertAt(vr.resolve(), null);
                    t = currentStream.peek();
                    if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("]")) break;
                    if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(",")) {
                        ScriptParser.syntaxError(currentStream, "Missing ','");
                    }
                    currentStream.skip();
                }
            }
            currentStream.skip();
            return va;
        }
        if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("{")) {
            currentStream.skip();
            VariableConfiguration va = new VariableConfiguration();
            t = currentStream.peek();
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("}")) {
                while (true) {
                    VariableReference vr;
                    if ((vr = this.evaluateExpression(currentStream)) == null) {
                        ScriptParser.syntaxError(currentStream, "Missing expression in configuration object initializer");
                    }
                    va.insertAt(vr.resolve(), null);
                    t = currentStream.peek();
                    if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("}")) break;
                    if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(",")) {
                        ScriptParser.syntaxError(currentStream, "Missing ','");
                    }
                    currentStream.skip();
                }
            }
            currentStream.skip();
            return va;
        }
        if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("<<")) {
            VariableReference vr;
            currentStream.skip();
            VariableReference nodeTypeRef = this.evaluateExpression(currentStream);
            if (nodeTypeRef == null) {
                ScriptParser.syntaxError(currentStream, "Missing node type");
            }
            Variable nodeType = ScriptParser.resolveMustExist(currentStream, nodeTypeRef);
            t = currentStream.peek();
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(":")) {
                ScriptParser.syntaxError(currentStream, "Missing ':'");
            }
            currentStream.skip();
            VariableConfigurationNode va = new VariableConfigurationNode(nodeType.getStringValue());
            VariableReference nodeValueRef = this.evaluateExpression(currentStream);
            if (nodeValueRef == null) {
                ScriptParser.syntaxError(currentStream, "Missing node value");
            }
            Variable nodeValue = ScriptParser.resolveMustExist(currentStream, nodeValueRef);
            t = currentStream.peek();
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(":")) {
                ScriptParser.syntaxError(currentStream, "Missing ':'");
            }
            currentStream.skip();
            va.getAttribute("__value__").setReference(nodeValue);
            t = currentStream.peek();
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(":")) {
                while (true) {
                    if ((vr = this.evaluateExpression(currentStream)) == null) {
                        ScriptParser.syntaxError(currentStream, "Missing name expression in configurationnode attribute initializer");
                    }
                    Variable attrName = ScriptParser.resolveMustExist(currentStream, vr);
                    t = currentStream.peek();
                    if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("=")) {
                        ScriptParser.syntaxError(currentStream, "Missing '='");
                    }
                    currentStream.skip();
                    vr = this.evaluateExpression(currentStream);
                    if (vr == null) {
                        ScriptParser.syntaxError(currentStream, "Missing value expression in configurationnode attribute initializer");
                    }
                    va.getAttribute(attrName.getStringValue()).setReference(vr.resolve());
                    t = currentStream.peek();
                    if (t != null && t.getPunctuation() != null && t.getPunctuation().equals(":")) break;
                    if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(",")) {
                        ScriptParser.syntaxError(currentStream, "Missing ','");
                    }
                    currentStream.skip();
                }
            }
            currentStream.skip();
            t = currentStream.peek();
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(">>")) {
                while (true) {
                    if ((vr = this.evaluateExpression(currentStream)) == null) {
                        ScriptParser.syntaxError(currentStream, "Missing expression in configurationnode object initializer");
                    }
                    va.insertAt(vr.resolve(), null);
                    t = currentStream.peek();
                    if (t != null && t.getPunctuation() != null && t.getPunctuation().equals(">>")) break;
                    if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(",")) {
                        ScriptParser.syntaxError(currentStream, "Missing ','");
                    }
                    currentStream.skip();
                }
            }
            currentStream.skip();
            return va;
        }
        return this.parseVariableReference_2(currentStream);
    }

    protected VariableReference parseVariableReference_2(TokenStream currentStream) throws ScriptException {
        Token t = currentStream.peek();
        if (t != null && t.getToken() != null) {
            currentStream.skip();
            String variableName = t.getToken();
            if (variableName.equals("true")) {
                return new VariableBoolean(true);
            }
            if (variableName.equals("false")) {
                return new VariableBoolean(false);
            }
            if (variableName.equals("null")) {
                return new NullVariableReference();
            }
            if (variableName.equals("new")) {
                String operationName;
                NewOperation newOperation;
                t = currentStream.peek();
                if (t == null || t.getToken() == null) {
                    ScriptParser.syntaxError(currentStream, "Missing 'new' operation name");
                }
                if ((newOperation = this.newOperations.get(operationName = t.getToken())) == null) {
                    ScriptParser.syntaxError(currentStream, "New operation type is unknown");
                }
                currentStream.skip();
                return newOperation.parseAndCreate(this, currentStream);
            }
            ContextVariableReference x = this.context.get(variableName);
            if (x == null) {
                x = new ContextVariableReference();
                this.context.put(variableName, x);
            }
            return x;
        }
        if (t != null && t.getString() != null) {
            currentStream.skip();
            return new VariableString(t.getString());
        }
        if (t != null && t.getFloat() != null) {
            currentStream.skip();
            return new VariableFloat(new Double(t.getFloat()));
        }
        if (t != null && t.getInteger() != null) {
            currentStream.skip();
            return new VariableInt(Integer.parseInt(t.getInteger()));
        }
        return null;
    }

    protected boolean skipVariableReference_0(TokenStream currentStream) throws ScriptException {
        if (!this.skipVariableReference_1(currentStream)) {
            return false;
        }
        while (true) {
            Token t;
            if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("[")) {
                currentStream.skip();
                if (!this.skipExpression(currentStream)) {
                    ScriptParser.syntaxError(currentStream, "Missing expression after '['");
                }
                if ((t = currentStream.peek()) == null || t.getPunctuation() == null || !t.getPunctuation().equals("]")) {
                    ScriptParser.syntaxError(currentStream, "Missing ']'");
                }
                currentStream.skip();
                continue;
            }
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(".")) break;
            currentStream.skip();
            t = currentStream.peek();
            if (t == null || t.getToken() == null) {
                ScriptParser.syntaxError(currentStream, "Need property name");
            }
            currentStream.skip();
        }
        return true;
    }

    protected boolean skipVariableReference_1(TokenStream currentStream) throws ScriptException {
        Token t = currentStream.peek();
        if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("(")) {
            currentStream.skip();
            if (!this.skipExpression(currentStream)) {
                ScriptParser.syntaxError(currentStream, "Missing expression after '('");
            }
            if ((t = currentStream.peek()) == null || t.getPunctuation() == null || !t.getPunctuation().equals(")")) {
                ScriptParser.syntaxError(currentStream, "Missing ')'");
            }
            currentStream.skip();
            return true;
        }
        if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("[")) {
            currentStream.skip();
            t = currentStream.peek();
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("]")) {
                while (true) {
                    if (!this.skipExpression(currentStream)) {
                        ScriptParser.syntaxError(currentStream, "Missing expression in array initializer");
                    }
                    if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("]")) break;
                    if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(",")) {
                        ScriptParser.syntaxError(currentStream, "Missing ','");
                    }
                    currentStream.skip();
                }
            }
            currentStream.skip();
            return true;
        }
        if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("{")) {
            currentStream.skip();
            t = currentStream.peek();
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals("}")) {
                while (true) {
                    if (!this.skipExpression(currentStream)) {
                        ScriptParser.syntaxError(currentStream, "Missing expression in configuration object initializer");
                    }
                    if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals("}")) break;
                    if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(",")) {
                        ScriptParser.syntaxError(currentStream, "Missing ','");
                    }
                    currentStream.skip();
                }
            }
            currentStream.skip();
            return true;
        }
        if (t != null && t.getPunctuation() != null && t.getPunctuation().equals("<<")) {
            currentStream.skip();
            if (!this.skipExpression(currentStream)) {
                ScriptParser.syntaxError(currentStream, "Missing node type");
            }
            if ((t = currentStream.peek()) == null || t.getPunctuation() == null || !t.getPunctuation().equals(":")) {
                ScriptParser.syntaxError(currentStream, "Missing ':'");
            }
            currentStream.skip();
            if (!this.skipExpression(currentStream)) {
                ScriptParser.syntaxError(currentStream, "Missing node value");
            }
            if ((t = currentStream.peek()) == null || t.getPunctuation() == null || !t.getPunctuation().equals(":")) {
                ScriptParser.syntaxError(currentStream, "Missing ':'");
            }
            currentStream.skip();
            t = currentStream.peek();
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(":")) {
                while (true) {
                    if (!this.skipExpression(currentStream)) {
                        ScriptParser.syntaxError(currentStream, "Missing name expression in configurationnode attribute initializer");
                    }
                    if ((t = currentStream.peek()) == null || t.getPunctuation() == null || !t.getPunctuation().equals("=")) {
                        ScriptParser.syntaxError(currentStream, "Missing '='");
                    }
                    currentStream.skip();
                    if (!this.skipExpression(currentStream)) {
                        ScriptParser.syntaxError(currentStream, "Missing value expression in configurationnode attribute initializer");
                    }
                    if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals(":")) break;
                    if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(",")) {
                        ScriptParser.syntaxError(currentStream, "Missing ','");
                    }
                    currentStream.skip();
                }
            }
            currentStream.skip();
            t = currentStream.peek();
            if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(">>")) {
                while (true) {
                    if (!this.skipExpression(currentStream)) {
                        ScriptParser.syntaxError(currentStream, "Missing expression in configurationnode object initializer");
                    }
                    if ((t = currentStream.peek()) != null && t.getPunctuation() != null && t.getPunctuation().equals(">>")) break;
                    if (t == null || t.getPunctuation() == null || !t.getPunctuation().equals(",")) {
                        ScriptParser.syntaxError(currentStream, "Missing ','");
                    }
                    currentStream.skip();
                }
            }
            currentStream.skip();
            return true;
        }
        return this.skipVariableReference_2(currentStream);
    }

    protected boolean skipVariableReference_2(TokenStream currentStream) throws ScriptException {
        Token t = currentStream.peek();
        if (t != null && t.getToken() != null) {
            currentStream.skip();
            if (t.getToken().equals("new")) {
                String operationName;
                NewOperation newOperation;
                t = currentStream.peek();
                if (t == null || t.getToken() == null) {
                    ScriptParser.syntaxError(currentStream, "Missing 'new' operation name");
                }
                if ((newOperation = this.newOperations.get(operationName = t.getToken())) == null) {
                    ScriptParser.syntaxError(currentStream, "New operation type is unknown");
                }
                currentStream.skip();
                newOperation.parseAndSkip(this, currentStream);
            }
            return true;
        }
        if (t != null && t.getString() != null) {
            currentStream.skip();
            return true;
        }
        if (t != null && t.getFloat() != null) {
            currentStream.skip();
            return true;
        }
        if (t != null && t.getInteger() != null) {
            currentStream.skip();
            return true;
        }
        return false;
    }

    public static void syntaxError(TokenStream currentStream, String message) throws ScriptException {
        ScriptParser.localError(currentStream, "Syntax error: " + message);
    }

    public static Variable resolveMustExist(TokenStream currentStream, VariableReference vr) throws ScriptException {
        Variable v = vr.resolve();
        if (v == null) {
            ScriptParser.localError(currentStream, "Expression cannot be null");
        }
        return v;
    }

    public static void localError(TokenStream currentStream, String message) throws ScriptException {
        Token t = currentStream.peek();
        if (t == null) {
            throw new ScriptException(message + ", at end of file");
        }
        t.throwException(message + ": " + t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertToString(HttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try (InputStream is = entity.getContent();){
                Charset charSet;
                try {
                    ContentType ct = ContentType.get((HttpEntity)entity);
                    charSet = ct == null ? StandardCharsets.UTF_8 : ct.getCharset();
                }
                catch (ParseException e) {
                    charSet = StandardCharsets.UTF_8;
                }
                char[] buffer = new char[65536];
                InputStreamReader r = new InputStreamReader(is, charSet);
                StringWriter w = new StringWriter();
                try {
                    int amt;
                    while ((amt = r.read(buffer)) != -1) {
                        ((Writer)w).write(buffer, 0, amt);
                    }
                }
                finally {
                    ((Writer)w).flush();
                }
                String string = ((Object)w).toString();
                return string;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getHttpClient() {
        Integer n = this.httpClientLock;
        synchronized (n) {
            if (this.httpClient == null) {
                int socketTimeout = 900000;
                int connectionTimeout = 300000;
                PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager();
                poolingConnectionManager.setDefaultMaxPerRoute(1);
                poolingConnectionManager.setValidateAfterInactivity(60000);
                poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
                this.connectionManager = poolingConnectionManager;
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(socketTimeout).setExpectContinueEnabled(true).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout);
                this.httpClient = HttpClients.custom().setConnectionManager(this.connectionManager).setMaxConnTotal(1).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setRequestExecutor(new HttpRequestExecutor(socketTimeout)).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).build();
            }
        }
        return this.httpClient;
    }

    public static void main(String[] argv) {
        block7: {
            ScriptParser sp = new ScriptParser();
            sp.addCommand("break", new BreakCommand());
            sp.addCommand("print", new PrintCommand());
            sp.addCommand("if", new IfCommand());
            sp.addCommand("while", new WhileCommand());
            sp.addCommand("set", new SetCommand());
            sp.addCommand("insert", new InsertCommand());
            sp.addCommand("remove", new RemoveCommand());
            sp.addCommand("error", new ErrorCommand());
            sp.addCommand("wait", new WaitCommand());
            sp.addCommand("GET", new GETCommand());
            sp.addCommand("PUT", new PUTCommand());
            sp.addCommand("DELETE", new DELETECommand());
            sp.addCommand("POST", new POSTCommand());
            sp.addNewOperation("configuration", new NewConfiguration());
            sp.addNewOperation("configurationnode", new NewConfigurationNode());
            sp.addNewOperation("url", new NewURL());
            sp.addNewOperation("connectionname", new NewConnectionName());
            sp.addNewOperation("array", new NewArray());
            sp.addNewOperation("dictionary", new NewDictionary());
            sp.addNewOperation("queryarg", new NewQueryArgument());
            try {
                if (argv.length >= 1) {
                    File inputFile = new File(argv[0]);
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(inputFile), StandardCharsets.UTF_8);
                    VariableArray va = new VariableArray();
                    for (int i = 0; i < argv.length - 1; ++i) {
                        String arg = argv[i + 1];
                        va.insertAt(new VariableString(arg), null);
                    }
                    sp.addVariable("__args__", va);
                    BasicTokenStream ts = new BasicTokenStream(reader);
                    sp.execute(ts);
                    break block7;
                }
                InputStreamReader reader = new InputStreamReader(System.in);
                while (true) {
                    BasicTokenStream ts = new BasicTokenStream(reader);
                    try {
                        sp.execute(ts);
                    }
                    catch (ScriptException e) {
                        System.out.println("Error: " + e.getMessage());
                        if (ts.peek() != null) continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.exit(2);
            }
        }
    }
}

