/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.scriptengine.Command;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.ScriptParser;
import org.apache.manifoldcf.scriptengine.Token;
import org.apache.manifoldcf.scriptengine.TokenStream;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class SetCommand
implements Command {
    @Override
    public boolean parseAndExecute(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        Token t;
        VariableReference lhs = sp.evaluateExpression(currentStream);
        if (lhs == null) {
            ScriptParser.syntaxError(currentStream, "Missing lhs expression in set command");
        }
        if ((t = currentStream.peek()) == null || t.getPunctuation() == null || !t.getPunctuation().equals("=")) {
            ScriptParser.syntaxError(currentStream, "Missing '=' in set command");
        }
        currentStream.skip();
        VariableReference rhs = sp.evaluateExpression(currentStream);
        if (rhs == null) {
            ScriptParser.syntaxError(currentStream, "Missing rhs expression in set command");
        }
        lhs.setReference(rhs.resolve());
        return false;
    }

    @Override
    public void parseAndSkip(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        Token t;
        if (!sp.skipExpression(currentStream)) {
            ScriptParser.syntaxError(currentStream, "Missing lhs expression in set command");
        }
        if ((t = currentStream.peek()) == null || t.getPunctuation() == null || !t.getPunctuation().equals("=")) {
            ScriptParser.syntaxError(currentStream, "Missing '=' in set command");
        }
        currentStream.skip();
        if (!sp.skipExpression(currentStream)) {
            ScriptParser.syntaxError(currentStream, "Missing rhs expression in set command");
        }
    }
}

