/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableBase;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class VariableBoolean
extends VariableBase {
    protected boolean value;

    public VariableBoolean(boolean value) {
        this.value = value;
    }

    public int hashCode() {
        return new Boolean(this.value).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableBoolean)) {
            return false;
        }
        return ((VariableBoolean)o).value == this.value;
    }

    @Override
    public boolean hasScriptValue() throws ScriptException {
        return true;
    }

    @Override
    public String getScriptValue() throws ScriptException {
        if (this.value) {
            return "true";
        }
        return "false";
    }

    @Override
    public boolean hasBooleanValue() throws ScriptException {
        return true;
    }

    @Override
    public boolean getBooleanValue() throws ScriptException {
        return this.value;
    }

    @Override
    public VariableReference doubleEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '==' operand cannot be null"));
        }
        return new VariableBoolean(this.value == v.getBooleanValue());
    }

    @Override
    public VariableReference exclamationEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '!=' operand cannot be null"));
        }
        return new VariableBoolean(this.value != v.getBooleanValue());
    }

    @Override
    public VariableReference doubleAmpersand(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '&&' operand cannot be null"));
        }
        return new VariableBoolean(this.value && v.getBooleanValue());
    }

    @Override
    public VariableReference doublePipe(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '||' operand cannot be null"));
        }
        return new VariableBoolean(this.value || v.getBooleanValue());
    }

    @Override
    public VariableReference ampersand(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '&' operand cannot be null"));
        }
        return new VariableBoolean(this.value && v.getBooleanValue());
    }

    @Override
    public VariableReference pipe(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '|' operand cannot be null"));
        }
        return new VariableBoolean(this.value || v.getBooleanValue());
    }

    @Override
    public VariableReference unaryExclamation() throws ScriptException {
        return new VariableBoolean(!this.value);
    }
}

