/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.solr;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.manifoldcf.agents.output.solr.ModifiedMultipartEntity;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;

public class ModifiedHttpSolrClient
extends HttpSolrClient {
    private static final String DEFAULT_PATH = "/select";
    private static Charset UTF8_CHARSET;
    private final HttpClient httpClient;
    private boolean useMultiPartPost = true;

    public ModifiedHttpSolrClient(String baseURL, HttpClient client, ResponseParser parser) {
        super(baseURL, client, parser);
        this.httpClient = client;
    }

    protected HttpRequestBase createMethod(SolrRequest request, String collection) throws IOException, SolrServerException {
        ResponseParser parser;
        SolrParams params = request.getParams();
        Collection streams = this.requestWriter.getContentStreams(request);
        String path = this.requestWriter.getPath(request);
        if (path == null || !path.startsWith("/")) {
            path = DEFAULT_PATH;
        }
        if ((parser = request.getResponseParser()) == null) {
            parser = this.parser;
        }
        ModifiableSolrParams wparams = new ModifiableSolrParams(params);
        if (parser != null) {
            wparams.set("wt", new String[]{parser.getWriterType()});
            wparams.set("version", new String[]{parser.getVersion()});
        }
        if (this.invariantParams != null) {
            wparams.add((SolrParams)this.invariantParams);
        }
        String basePath = this.baseUrl;
        if (collection != null) {
            basePath = basePath + "/" + collection;
        }
        if (SolrRequest.METHOD.GET == request.getMethod()) {
            if (streams != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GET can't send streams!");
            }
            return new HttpGet(basePath + path + ModifiedHttpSolrClient.toQueryString((SolrParams)wparams, false));
        }
        if (SolrRequest.METHOD.POST == request.getMethod() || SolrRequest.METHOD.PUT == request.getMethod()) {
            String url = basePath + path;
            boolean hasNullStreamName = false;
            if (streams != null) {
                for (ContentStream cs : streams) {
                    if (cs.getName() != null) continue;
                    hasNullStreamName = true;
                    break;
                }
            }
            boolean isMultipart = (this.useMultiPartPost && SolrRequest.METHOD.POST == request.getMethod() || streams != null && streams.size() > 1) && !hasNullStreamName;
            LinkedList<BasicNameValuePair> postOrPutParams = new LinkedList<BasicNameValuePair>();
            if (streams == null || isMultipart) {
                HttpPost postOrPut;
                ModifiableSolrParams queryParams = this.calculateQueryParams(this.getQueryParams(), wparams);
                queryParams.add((SolrParams)this.calculateQueryParams(request.getQueryParams(), wparams));
                String fullQueryUrl = url + ModifiedHttpSolrClient.toQueryString((SolrParams)queryParams, false);
                Object object = postOrPut = SolrRequest.METHOD.POST == request.getMethod() ? new HttpPost(fullQueryUrl) : new HttpPut(fullQueryUrl);
                if (!isMultipart) {
                    postOrPut.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                }
                LinkedList<FormBodyPart> parts = new LinkedList<FormBodyPart>();
                Iterator iter = wparams.getParameterNamesIterator();
                while (iter.hasNext()) {
                    String p = (String)iter.next();
                    String[] vals = wparams.getParams(p);
                    if (vals == null) continue;
                    for (String v : vals) {
                        if (isMultipart) {
                            parts.add(new FormBodyPart(p, (ContentBody)new StringBody(v, StandardCharsets.UTF_8)));
                            continue;
                        }
                        postOrPutParams.add(new BasicNameValuePair(p, v));
                    }
                }
                if (isMultipart && streams != null) {
                    for (ContentStream content : streams) {
                        String name;
                        String contentType = content.getContentType();
                        if (contentType == null) {
                            contentType = "application/octet-stream";
                        }
                        if ((name = content.getName()) == null) {
                            name = "";
                        }
                        parts.add(new FormBodyPart(name, (ContentBody)new InputStreamBody(content.getStream(), contentType, content.getName())));
                    }
                }
                if (parts.size() > 0) {
                    ModifiedMultipartEntity entity = new ModifiedMultipartEntity(HttpMultipartMode.STRICT, null, StandardCharsets.UTF_8);
                    for (FormBodyPart p : parts) {
                        entity.addPart(p);
                    }
                    postOrPut.setEntity((HttpEntity)entity);
                } else {
                    postOrPut.setEntity((HttpEntity)new UrlEncodedFormEntity(postOrPutParams, StandardCharsets.UTF_8));
                }
                return postOrPut;
            }
            String pstr = ModifiedHttpSolrClient.toQueryString((SolrParams)wparams, false);
            HttpPost postOrPut = SolrRequest.METHOD.POST == request.getMethod() ? new HttpPost(url + pstr) : new HttpPut(url + pstr);
            final ContentStream[] contentStream = new ContentStream[1];
            Iterator i$ = streams.iterator();
            if (i$.hasNext()) {
                ContentStream content;
                contentStream[0] = content = (ContentStream)i$.next();
            }
            if (contentStream[0] instanceof RequestWriter.LazyContentStream) {
                postOrPut.setEntity((HttpEntity)new InputStreamEntity(contentStream[0].getStream(), -1L){

                    public Header getContentType() {
                        return new BasicHeader("Content-Type", contentStream[0].getContentType());
                    }

                    public boolean isRepeatable() {
                        return false;
                    }
                });
            } else {
                postOrPut.setEntity((HttpEntity)new InputStreamEntity(contentStream[0].getStream(), -1L){

                    public Header getContentType() {
                        return new BasicHeader("Content-Type", contentStream[0].getContentType());
                    }

                    public boolean isRepeatable() {
                        return false;
                    }
                });
            }
            return postOrPut;
        }
        throw new SolrServerException("Unsupported method: " + request.getMethod());
    }

    public static String toQueryString(SolrParams params, boolean xml) {
        StringBuilder sb = new StringBuilder(128);
        try {
            String amp = xml ? "&amp;" : "&";
            boolean first = true;
            Iterator names = params.getParameterNamesIterator();
            while (names.hasNext()) {
                String key = (String)names.next();
                String[] valarr = params.getParams(key);
                if (valarr == null) {
                    sb.append(first ? "?" : amp);
                    sb.append(URLEncoder.encode(key, "UTF-8"));
                    first = false;
                    continue;
                }
                for (String val : valarr) {
                    sb.append(first ? "?" : amp);
                    sb.append(key);
                    if (val != null) {
                        sb.append('=');
                        sb.append(URLEncoder.encode(val, "UTF-8"));
                    }
                    first = false;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }
}

