/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.database;

import java.io.File;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.manifoldcf.core.database.ConnectionFactory;
import org.apache.manifoldcf.core.database.Database;
import org.apache.manifoldcf.core.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ResultSpecification;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.interfaces.StringSetBuffer;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.manifoldcf.core.system.ManifoldCF;

public class DBInterfaceDerby
extends Database
implements IDBInterface {
    public static final String _rcsid = "@(#)$Id: DBInterfaceDerby.java 1001023 2010-09-24 18:41:28Z kwright $";
    protected static final String _url = "jdbc:derby:";
    protected static final String _driver = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String databasePathProperty = "org.apache.manifoldcf.derbydatabasepath";
    protected ILockManager lockManager;
    protected String userName;
    protected String password;
    protected String cacheKey;
    protected int serializableDepth = 0;
    int depthCount = 0;
    boolean inTransaction = false;
    protected List<String> tablesToAnalyze = new ArrayList<String>();
    protected List<String> tablesToReindex = new ArrayList<String>();
    protected static Map<String, TableStatistics> currentReindexStatistics = new HashMap<String, TableStatistics>();
    protected static Map<String, Integer> reindexThresholds = new HashMap<String, Integer>();
    protected static Map<String, TableStatistics> currentAnalyzeStatistics = new HashMap<String, TableStatistics>();
    protected static Map<String, Integer> analyzeThresholds = new HashMap<String, Integer>();
    protected static final int commitThreshold = 100;
    protected static final String statslockReindexPrefix = "statslock-reindex-";
    protected static final String statsReindexPrefix = "stats-reindex-";
    protected static final String statslockAnalyzePrefix = "statslock-analyze-";
    protected static final String statsAnalyzePrefix = "stats-analyze-";

    protected static String getFullDatabasePath(String databaseName) throws ManifoldCFException {
        File path = ManifoldCF.getFileProperty(databasePathProperty);
        if (path == null) {
            throw new ManifoldCFException("Derby database requires 'org.apache.manifoldcf.derbydatabasepath' property, containing a relative path");
        }
        String pathString = path.toString().replace("\\\\", "/");
        if (!pathString.endsWith("/")) {
            pathString = pathString + "/";
        }
        return pathString + databaseName;
    }

    public DBInterfaceDerby(IThreadContext tc, String databaseName, String userName, String password) throws ManifoldCFException {
        super(tc, _url + DBInterfaceDerby.getFullDatabasePath(databaseName) + ";user=" + userName + ";password=" + password, _driver, DBInterfaceDerby.getFullDatabasePath(databaseName), userName, password);
        this.cacheKey = CacheKeyFactory.makeDatabaseKey(this.databaseName);
        this.lockManager = LockManagerFactory.make(tc);
        this.userName = userName;
        this.password = password;
    }

    public DBInterfaceDerby(IThreadContext tc, String databaseName) throws ManifoldCFException {
        super(tc, _url + databaseName, _driver, databaseName, "", "");
        this.cacheKey = CacheKeyFactory.makeDatabaseKey(this.databaseName);
        this.lockManager = LockManagerFactory.make(tc);
        this.userName = "";
        this.password = "";
    }

    @Override
    public void openDatabase() throws ManifoldCFException {
    }

    @Override
    public void closeDatabase() throws ManifoldCFException {
        try {
            Class.forName(_driver).newInstance();
        }
        catch (Exception e) {
            throw new ManifoldCFException(e.getMessage(), e);
        }
        try {
            DriverManager.getConnection(_url + this.databaseName + ";shutdown=true;user=" + this.userName + ";password=" + this.password, this.userName, this.password).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getDatabaseCacheKey() {
        return this.cacheKey;
    }

    @Override
    public void performInsert(String tableName, Map<String, Object> parameterMap, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList<Object> paramArray = new ArrayList<Object>();
        StringBuilder bf = new StringBuilder();
        bf.append("INSERT INTO ");
        bf.append(tableName);
        bf.append(" (");
        StringBuilder values = new StringBuilder(" VALUES (");
        Iterator<Map.Entry<String, Object>> it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            String key = e.getKey();
            Object o = e.getValue();
            if (o == null) continue;
            paramArray.add(o);
            if (!first) {
                bf.append(',');
                values.append(',');
            }
            bf.append(key);
            values.append('?');
            first = false;
        }
        bf.append(')');
        values.append(')');
        bf.append((CharSequence)values);
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    @Override
    public void performUpdate(String tableName, Map<String, Object> parameterMap, String whereClause, List whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        ArrayList<Object> paramArray = new ArrayList<Object>();
        StringBuilder bf = new StringBuilder();
        bf.append("UPDATE ");
        bf.append(tableName);
        bf.append(" SET ");
        Iterator<Map.Entry<String, Object>> it = parameterMap.entrySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            String key = e.getKey();
            Object o = e.getValue();
            if (!first) {
                bf.append(',');
            }
            bf.append(key);
            bf.append('=');
            if (o == null) {
                bf.append("NULL");
            } else {
                bf.append('?');
                paramArray.add(o);
            }
            first = false;
        }
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
            if (whereParameters != null) {
                for (int i = 0; i < whereParameters.size(); ++i) {
                    Object value = whereParameters.get(i);
                    paramArray.add(value);
                }
            }
        }
        this.performModification(bf.toString(), paramArray, invalidateKeys);
    }

    @Override
    public void performDelete(String tableName, String whereClause, List whereParameters, StringSet invalidateKeys) throws ManifoldCFException {
        StringBuilder bf = new StringBuilder();
        bf.append("DELETE FROM ");
        bf.append(tableName);
        if (whereClause != null) {
            bf.append(' ');
            bf.append(whereClause);
        } else {
            whereParameters = null;
        }
        this.performModification(bf.toString(), whereParameters, invalidateKeys);
    }

    @Override
    public void performCreate(String tableName, Map<String, ColumnDescription> columnMap, StringSet invalidateKeys) throws ManifoldCFException {
        boolean constraintNumber = false;
        StringBuilder queryBuffer = new StringBuilder("CREATE TABLE ");
        queryBuffer.append(tableName);
        queryBuffer.append('(');
        Iterator<String> iter = columnMap.keySet().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String columnName = iter.next();
            ColumnDescription cd = columnMap.get(columnName);
            if (!first) {
                queryBuffer.append(',');
            } else {
                first = false;
            }
            this.appendDescription(queryBuffer, columnName, cd, false);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, invalidateKeys);
    }

    protected void appendDescription(StringBuilder queryBuffer, String columnName, ColumnDescription cd, boolean forceNull) throws ManifoldCFException {
        queryBuffer.append(columnName);
        queryBuffer.append(' ');
        queryBuffer.append(DBInterfaceDerby.mapType(cd.getTypeString()));
        if (!forceNull && !cd.getIsNull()) {
            queryBuffer.append(" NOT NULL");
        }
        if (cd.getIsPrimaryKey()) {
            queryBuffer.append(" CONSTRAINT c" + IDFactory.make(this.context) + " PRIMARY KEY");
        }
        if (cd.getReferenceTable() != null) {
            queryBuffer.append(" CONSTRAINT c" + IDFactory.make(this.context) + " REFERENCES ");
            queryBuffer.append(cd.getReferenceTable());
            queryBuffer.append('(');
            queryBuffer.append(cd.getReferenceColumn());
            queryBuffer.append(") ON DELETE");
            if (cd.getReferenceCascade()) {
                queryBuffer.append(" CASCADE");
            } else {
                queryBuffer.append(" RESTRICT");
            }
        }
    }

    @Override
    public void performAlter(String tableName, Map<String, ColumnDescription> columnMap, Map<String, ColumnDescription> columnModifyMap, List<String> columnDeleteList, StringSet invalidateKeys) throws ManifoldCFException {
        this.beginTransaction(0);
        try {
            ColumnDescription cd;
            if (columnDeleteList != null) {
                int i = 0;
                while (i < columnDeleteList.size()) {
                    String columnName = columnDeleteList.get(i++);
                    this.performModification("ALTER TABLE ONLY " + tableName + " DROP " + columnName, null, invalidateKeys);
                }
            }
            if (columnModifyMap != null) {
                for (String columnName : columnModifyMap.keySet()) {
                    cd = columnModifyMap.get(columnName);
                    String renameColumn = "__temp__";
                    this.performModification("RENAME COLUMN " + tableName + "." + columnName + " TO " + renameColumn, null, invalidateKeys);
                    StringBuilder sb = new StringBuilder();
                    this.appendDescription(sb, columnName, cd, true);
                    this.performModification("ALTER TABLE " + tableName + " ADD " + sb.toString(), null, invalidateKeys);
                    this.performModification("UPDATE " + tableName + " SET " + columnName + "=" + renameColumn, null, invalidateKeys);
                    if (!cd.getIsNull()) {
                        this.performModification("ALTER TABLE " + tableName + " ALTER " + columnName + " SET NOT NULL", null, invalidateKeys);
                    }
                    this.performModification("ALTER TABLE " + tableName + " DROP " + renameColumn, null, invalidateKeys);
                }
            }
            if (columnMap != null) {
                for (String columnName : columnMap.keySet()) {
                    cd = columnMap.get(columnName);
                    StringBuilder sb = new StringBuilder();
                    this.appendDescription(sb, columnName, cd, false);
                    this.performModification("ALTER TABLE " + tableName + " ADD " + sb.toString(), null, invalidateKeys);
                }
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    protected static String mapType(String inputType) {
        if (inputType.equalsIgnoreCase("longtext")) {
            return "CLOB";
        }
        return inputType;
    }

    @Override
    public void addTableIndex(String tableName, boolean unique, List<String> columnList) throws ManifoldCFException {
        String[] columns = new String[columnList.size()];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = columnList.get(i);
        }
        this.performAddIndex(null, tableName, new IndexDescription(unique, columns));
    }

    @Override
    public void performAddIndex(String indexName, String tableName, IndexDescription description) throws ManifoldCFException {
        String[] columnNames = description.getColumnNames();
        if (columnNames.length == 0) {
            return;
        }
        if (indexName == null) {
            indexName = "I" + IDFactory.make(this.context);
        }
        StringBuilder queryBuffer = new StringBuilder("CREATE ");
        if (description.getIsUnique()) {
            queryBuffer.append("UNIQUE ");
        }
        queryBuffer.append("INDEX ");
        queryBuffer.append(indexName);
        queryBuffer.append(" ON ");
        queryBuffer.append(tableName);
        queryBuffer.append(" (");
        for (int i = 0; i < columnNames.length; ++i) {
            String colName = columnNames[i];
            if (i > 0) {
                queryBuffer.append(',');
            }
            queryBuffer.append(colName);
        }
        queryBuffer.append(')');
        this.performModification(queryBuffer.toString(), null, null);
    }

    @Override
    public void performRemoveIndex(String indexName, String tableName) throws ManifoldCFException {
        this.performModification("DROP INDEX " + indexName, null, null);
    }

    protected int readDatum(String datumName) throws ManifoldCFException {
        byte[] bytes = this.lockManager.readData(datumName);
        if (bytes == null) {
            return 0;
        }
        return (bytes[0] & 0xFF) + ((bytes[1] & 0xFF) << 8) + ((bytes[2] & 0xFF) << 16) + ((bytes[3] & 0xFF) << 24);
    }

    protected void writeDatum(String datumName, int value) throws ManifoldCFException {
        byte[] bytes = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        this.lockManager.writeData(datumName, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzeTable(String tableName) throws ManifoldCFException {
        String tableStatisticsLock = statslockAnalyzePrefix + tableName;
        this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
        try {
            TableStatistics ts = currentAnalyzeStatistics.get(tableName);
            this.lockManager.enterWriteLock(tableStatisticsLock);
            try {
                String eventDatum = statsAnalyzePrefix + tableName;
                this.analyzeTableInternal(tableName);
                this.writeDatum(eventDatum, 0);
                if (ts != null) {
                    ts.reset();
                }
            }
            finally {
                this.lockManager.leaveWriteLock(tableStatisticsLock);
            }
        }
        finally {
            this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reindexTable(String tableName) throws ManifoldCFException {
        String tableStatisticsLock = statslockReindexPrefix + tableName;
        this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
        try {
            TableStatistics ts = currentReindexStatistics.get(tableName);
            this.lockManager.enterWriteLock(tableStatisticsLock);
            try {
                String eventDatum = statsReindexPrefix + tableName;
                this.reindexTableInternal(tableName);
                this.writeDatum(eventDatum, 0);
                if (ts != null) {
                    ts.reset();
                }
            }
            finally {
                this.lockManager.leaveWriteLock(tableStatisticsLock);
            }
        }
        finally {
            this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
        }
    }

    protected void analyzeTableInternal(String tableName) throws ManifoldCFException {
        if (this.getTransactionID() == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("APP");
            list.add(tableName.toUpperCase(Locale.ROOT));
            this.performModification("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS(?,?,null)", list, null);
        } else {
            this.tablesToAnalyze.add(tableName);
        }
    }

    protected void reindexTableInternal(String tableName) throws ManifoldCFException {
        block10: {
            if (this.getTransactionID() == null) {
                long sleepAmt = 0L;
                while (true) {
                    try {
                        Map<String, IndexDescription> x = this.getTableIndexes(tableName, null, null);
                        for (String indexName : x.keySet()) {
                            IndexDescription id = x.get(indexName);
                            this.performRemoveIndex(indexName, tableName);
                            this.performAddIndex(indexName, tableName, id);
                        }
                        break block10;
                    }
                    catch (ManifoldCFException e) {
                        if (e.getErrorCode() == 6) {
                            sleepAmt = this.getSleepAmt();
                            continue;
                        }
                        throw e;
                    }
                    finally {
                        this.sleepFor(sleepAmt);
                        continue;
                    }
                    break;
                }
            }
            this.tablesToReindex.add(tableName);
        }
    }

    @Override
    public void performDrop(String tableName, StringSet invalidateKeys) throws ManifoldCFException {
        this.performModification("DROP TABLE " + tableName, null, invalidateKeys);
    }

    @Override
    public void createUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        DBInterfaceDerby rootDatabase;
        block5: {
            try {
                Class.forName(_driver).newInstance();
                DriverManager.getConnection(_url + this.databaseName + ";create=true;user=" + this.userName + ";password=" + this.password, this.userName, this.password).close();
            }
            catch (Exception e) {
                throw new ManifoldCFException(e.getMessage(), e, 3);
            }
            rootDatabase = new DBInterfaceDerby(this.context, this.databaseName);
            IResultSet set = rootDatabase.executeQuery("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.user." + this.userName + "')", null, null, null, null, true, -1, null, null);
            if (set.getRowCount() == 0) {
                rootDatabase.executeQuery("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.user." + this.userName + "', '" + this.password + "')", null, invalidateKeys, null, null, false, 0, null, null);
                rootDatabase.executeQuery("CREATE SCHEMA " + this.userName + " AUTHORIZATION " + this.userName, null, invalidateKeys, null, null, false, 0, null, null);
            }
            try {
                rootDatabase.executeQuery("DROP FUNCTION CASEINSENSITIVEREGULAREXPRESSIONCOMPARE", null, invalidateKeys, null, null, false, 0, null, null);
                rootDatabase.executeQuery("DROP FUNCTION CASESENSITIVEREGULAREXPRESSIONCOMPARE", null, invalidateKeys, null, null, false, 0, null, null);
                rootDatabase.executeQuery("DROP FUNCTION CASEINSENSITIVESUBSTRING", null, invalidateKeys, null, null, false, 0, null, null);
                rootDatabase.executeQuery("DROP FUNCTION CASESENSITIVESUBSTRING", null, invalidateKeys, null, null, false, 0, null, null);
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() != 2) break block5;
                throw e;
            }
        }
        rootDatabase.executeQuery("CREATE FUNCTION CASEINSENSITIVEREGULAREXPRESSIONCOMPARE (value varchar(255), regexp varchar(255)) returns varchar(255) language java parameter style java no sql external name 'org.apache.manifoldcf.core.database.DBInterfaceDerby.caseInsensitiveRegularExpressionCompare'", null, invalidateKeys, null, null, false, 0, null, null);
        rootDatabase.executeQuery("CREATE FUNCTION CASESENSITIVEREGULAREXPRESSIONCOMPARE (value varchar(255), regexp varchar(255)) returns varchar(255) language java parameter style java no sql external name 'org.apache.manifoldcf.core.database.DBInterfaceDerby.caseSensitiveRegularExpressionCompare'", null, invalidateKeys, null, null, false, 0, null, null);
        rootDatabase.executeQuery("CREATE FUNCTION CASEINSENSITIVESUBSTRING (value varchar(255), regexp varchar(255)) returns varchar(255) language java parameter style java no sql external name 'org.apache.manifoldcf.core.database.DBInterfaceDerby.caseInsensitiveSubstring'", null, invalidateKeys, null, null, false, 0, null, null);
        rootDatabase.executeQuery("CREATE FUNCTION CASESENSITIVESUBSTRING (value varchar(255), regexp varchar(255)) returns varchar(255) language java parameter style java no sql external name 'org.apache.manifoldcf.core.database.DBInterfaceDerby.caseSensitiveSubstring'", null, invalidateKeys, null, null, false, 0, null, null);
    }

    @Override
    public void dropUserAndDatabase(String adminUserName, String adminPassword, StringSet invalidateKeys) throws ManifoldCFException {
        File f = new File(this.databaseName);
        if (f.exists()) {
            ConnectionFactory.releaseAll();
            this.closeDatabase();
            DBInterfaceDerby.recursiveDelete(f);
        }
    }

    protected static void recursiveDelete(File f) {
        File[] files = f.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File newf;
                if ((newf = files[i++]).isDirectory()) {
                    DBInterfaceDerby.recursiveDelete(newf);
                    continue;
                }
                DBInterfaceDerby.singleDelete(newf);
            }
        }
        if (!f.delete()) {
            System.out.println("Failed to delete directory " + f.toString());
        }
    }

    protected static void singleDelete(File f) {
        if (!f.delete()) {
            System.out.println("Failed to delete file " + f.toString());
        }
    }

    protected ManifoldCFException reinterpretException(ManifoldCFException theException) {
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Reinterpreting exception '" + theException.getMessage() + "'.  The exception type is " + Integer.toString(theException.getErrorCode())));
        }
        if (theException.getErrorCode() != 4) {
            return theException;
        }
        Throwable e = theException.getCause();
        if (!(e instanceof SQLException)) {
            return theException;
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is possibly a transaction abort signal"));
        }
        SQLException sqlException = (SQLException)e;
        String message = sqlException.getMessage();
        String sqlState = sqlException.getSQLState();
        if (sqlState != null && sqlState.equals("23505")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (sqlState != null && sqlState.equals("40001")) {
            return new ManifoldCFException(message, e, 6);
        }
        if (Logging.db.isDebugEnabled()) {
            Logging.db.debug((Object)("Exception " + theException.getMessage() + " is NOT a transaction abort signal"));
        }
        return theException;
    }

    @Override
    public void performModification(String query, List params, StringSet invalidateKeys) throws ManifoldCFException {
        while (true) {
            try {
                this.executeQuery(query, params, null, invalidateKeys, null, false, 0, null, null);
                return;
            }
            catch (ManifoldCFException e) {
                try {
                    throw this.reinterpretException(e);
                }
                catch (ManifoldCFException e2) {
                    if (e2.getErrorCode() != 6) {
                        throw e2;
                    }
                    if (this.inTransaction) {
                        throw e2;
                    }
                    try {
                        ManifoldCF.sleep(1000L);
                    }
                    catch (InterruptedException e22) {
                        throw new ManifoldCFException(e2.getMessage(), e2, 2);
                    }
                }
            }
        }
    }

    @Override
    public Map<String, ColumnDescription> getTableSchema(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        String query = "SELECT CAST(t0.columnname AS VARCHAR(128)) AS columnname,CAST(t0.columndatatype AS VARCHAR(128)) AS columndatatype FROM sys.syscolumns t0, sys.systables t1 WHERE t0.referenceid=t1.tableid AND CAST(t1.tablename AS VARCHAR(128))=? ORDER BY t0.columnnumber ASC";
        ArrayList<String> list = new ArrayList<String>();
        list.add(tableName.toUpperCase(Locale.ROOT));
        IResultSet set = this.performQuery(query, list, cacheKeys, queryClass);
        if (set.getRowCount() == 0) {
            return null;
        }
        HashMap<String, ColumnDescription> rval = new HashMap<String, ColumnDescription>();
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String fieldName = ((String)row.getValue("columnname")).toLowerCase(Locale.ROOT);
            String type = (String)row.getValue("columndatatype");
            boolean isNull = false;
            boolean isPrimaryKey = false;
            rval.put(fieldName, new ColumnDescription(type, isPrimaryKey, isNull, null, null, false));
        }
        return rval;
    }

    @Override
    public Map<String, IndexDescription> getTableIndexes(String tableName, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        HashMap<String, IndexDescription> rval = new HashMap<String, IndexDescription>();
        String query = "SELECT t0.conglomeratename FROM sys.sysconglomerates t0,sys.systables t1 WHERE t0.tableid=t1.tableid AND t0.isindex IS NOT NULL AND CAST(t1.tablename AS VARCHAR(128))=?";
        ArrayList<String> list = new ArrayList<String>();
        list.add(tableName);
        IResultSet result = this.performQuery(query, list, cacheKeys, queryClass);
        int i = 0;
        while (i < result.getRowCount()) {
            IResultRow row = result.getRow(i++);
            String indexName = (String)row.getValue("conglomeratename");
            rval.put(indexName, new IndexDescription(false, new String[0]));
        }
        return rval;
    }

    @Override
    public StringSet getAllTables(StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        IResultSet set = this.performQuery("SELECT CAST(tablename AS VARCHAR(128)) FROM sys.systables WHERE table_type='T'", null, cacheKeys, queryClass);
        StringSetBuffer ssb = new StringSetBuffer();
        String columnName = "tablename";
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String value = row.getValue(columnName).toString();
            ssb.add(value);
        }
        return new StringSet(ssb);
    }

    @Override
    public IResultSet performQuery(String query, List params, StringSet cacheKeys, String queryClass) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, -1, null, null);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public IResultSet performQuery(String query, List params, StringSet cacheKeys, String queryClass, int maxResults, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, null, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public IResultSet performQuery(String query, List params, StringSet cacheKeys, String queryClass, int maxResults, ResultSpecification resultSpec, ILimitChecker returnLimit) throws ManifoldCFException {
        try {
            return this.executeQuery(query, params, cacheKeys, null, queryClass, true, maxResults, resultSpec, returnLimit);
        }
        catch (ManifoldCFException e) {
            throw this.reinterpretException(e);
        }
    }

    @Override
    public String constructDoubleCastClause(String value) {
        return "CAST(" + value + " AS DOUBLE PRECISION)";
    }

    @Override
    public String constructCountClause(String column) {
        return "CAST(COUNT(" + column + ") AS bigint)";
    }

    @Override
    public String constructRegexpClause(String column, String regularExpression, boolean caseInsensitive) {
        if (caseInsensitive) {
            return "CASEINSENSITIVEREGULAREXPRESSIONCOMPARE(CAST(" + column + " AS VARCHAR(255))," + regularExpression + ")='true'";
        }
        return "CASESENSITIVEREGULAREXPRESSIONCOMPARE(CAST(" + column + " AS VARCHAR(255))," + regularExpression + ")='true'";
    }

    @Override
    public String constructSubstringClause(String column, String regularExpression, boolean caseInsensitive) {
        if (caseInsensitive) {
            return "CASEINSENSITIVESUBSTRING(CAST(" + column + " AS VARCHAR(255))," + regularExpression + ")";
        }
        return "CASESENSITIVESUBSTRING(CAST(" + column + " AS VARCHAR(255))," + regularExpression + ")";
    }

    @Override
    public String constructOffsetLimitClause(int offset, int limit, boolean afterOrderBy) {
        StringBuilder sb = new StringBuilder();
        if (offset != 0) {
            sb.append("OFFSET ").append(Integer.toString(offset)).append(" ROWS");
        }
        if (limit != -1) {
            if (offset != 0) {
                sb.append(" ");
            }
            sb.append("FETCH NEXT ").append(Integer.toString(limit)).append(" ROWS ONLY");
        }
        return sb.toString();
    }

    @Override
    public String constructDistinctOnClause(List outputParameters, String baseQuery, List baseParameters, String[] distinctFields, String[] orderFields, boolean[] orderFieldsAscending, Map<String, String> otherFields) {
        if (baseParameters != null) {
            outputParameters.addAll(baseParameters);
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        boolean needComma = false;
        for (String fieldName : otherFields.keySet()) {
            String columnValue = otherFields.get(fieldName);
            if (needComma) {
                sb.append(",");
            }
            needComma = true;
            sb.append("txxx1.").append(columnValue).append(" AS ").append(fieldName);
        }
        sb.append(" FROM (").append(baseQuery).append(") txxx1");
        if (distinctFields.length > 0 || orderFields.length > 0) {
            int i;
            sb.append(" ORDER BY ");
            int k = 0;
            for (i = 0; i < distinctFields.length; ++i) {
                if (k > 0) {
                    sb.append(",");
                }
                sb.append(distinctFields[i]).append(" ASC");
                ++k;
            }
            i = 0;
            while (i < orderFields.length) {
                if (k > 0) {
                    sb.append(",");
                }
                sb.append(orderFields[i]).append(" ");
                if (orderFieldsAscending[i]) {
                    sb.append("ASC");
                } else {
                    sb.append("DESC");
                }
                ++i;
                ++k;
            }
        }
        return sb.toString();
    }

    @Override
    public int getMaxInClause() {
        return 100;
    }

    @Override
    public int getMaxOrClause() {
        return 1;
    }

    @Override
    public int getWindowedReportMaxRows() {
        return 5000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void noteModificationsNoTransactions(String tableName, int insertCount, int modifyCount, int deleteCount) throws ManifoldCFException {
        block23: {
            int oldEventCount;
            String eventDatum;
            TableStatistics ts;
            Integer threshold;
            String tableStatisticsLock;
            int eventCount;
            block22: {
                eventCount = modifyCount + deleteCount;
                tableStatisticsLock = statslockReindexPrefix + tableName;
                this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
                try {
                    int reindexThreshold;
                    threshold = reindexThresholds.get(tableName);
                    if (threshold == null) {
                        reindexThreshold = this.lockManager.getSharedConfiguration().getIntProperty("org.apache.manifoldcf.db.derby.reindex." + tableName, 250000);
                        reindexThresholds.put(tableName, new Integer(reindexThreshold));
                    } else {
                        reindexThreshold = threshold;
                    }
                    ts = currentReindexStatistics.get(tableName);
                    if (ts == null) {
                        ts = new TableStatistics();
                        currentReindexStatistics.put(tableName, ts);
                    }
                    ts.add(eventCount);
                    if (ts.getEventCount() < 100) break block22;
                    this.lockManager.enterWriteLock(tableStatisticsLock);
                    try {
                        eventDatum = statsReindexPrefix + tableName;
                        oldEventCount = this.readDatum(eventDatum);
                        if ((oldEventCount += ts.getEventCount()) >= reindexThreshold) {
                            this.reindexTableInternal(tableName);
                            this.writeDatum(eventDatum, 0);
                        } else {
                            this.writeDatum(eventDatum, oldEventCount);
                        }
                        ts.reset();
                    }
                    finally {
                        this.lockManager.leaveWriteLock(tableStatisticsLock);
                    }
                }
                finally {
                    this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
                }
            }
            eventCount = modifyCount + insertCount;
            tableStatisticsLock = statslockAnalyzePrefix + tableName;
            this.lockManager.enterWriteCriticalSection(tableStatisticsLock);
            try {
                int analyzeThreshold;
                threshold = analyzeThresholds.get(tableName);
                if (threshold == null) {
                    analyzeThreshold = this.lockManager.getSharedConfiguration().getIntProperty("org.apache.manifoldcf.db.derby.analyze." + tableName, 5000);
                    analyzeThresholds.put(tableName, new Integer(analyzeThreshold));
                } else {
                    analyzeThreshold = threshold;
                }
                ts = currentAnalyzeStatistics.get(tableName);
                if (ts == null) {
                    ts = new TableStatistics();
                    currentAnalyzeStatistics.put(tableName, ts);
                }
                ts.add(eventCount);
                if (ts.getEventCount() < 100) break block23;
                this.lockManager.enterWriteLock(tableStatisticsLock);
                try {
                    eventDatum = statsAnalyzePrefix + tableName;
                    oldEventCount = this.readDatum(eventDatum);
                    if ((oldEventCount += ts.getEventCount()) >= analyzeThreshold) {
                        this.analyzeTableInternal(tableName);
                        this.writeDatum(eventDatum, 0);
                    } else {
                        this.writeDatum(eventDatum, oldEventCount);
                    }
                    ts.reset();
                }
                finally {
                    this.lockManager.leaveWriteLock(tableStatisticsLock);
                }
            }
            finally {
                this.lockManager.leaveWriteCriticalSection(tableStatisticsLock);
            }
        }
    }

    @Override
    public void beginTransaction() throws ManifoldCFException {
        this.beginTransaction(0);
    }

    @Override
    public void beginTransaction(int transactionType) throws ManifoldCFException {
        if (this.getCurrentTransactionType() == 2) {
            ++this.serializableDepth;
            return;
        }
        if (transactionType == 0) {
            transactionType = super.getCurrentTransactionType();
        }
        switch (transactionType) {
            case 1: {
                try {
                    this.executeViaThread(this.connection == null ? null : this.connection.getConnection(), "SET ISOLATION READ COMMITTED", null, false, 0, null, null);
                }
                catch (Error e) {
                    super.signalRollback();
                    super.endTransaction();
                    throw e;
                }
                catch (ManifoldCFException e) {
                    super.signalRollback();
                    super.endTransaction();
                    throw e;
                }
                super.beginTransaction(1);
                break;
            }
            case 2: {
                try {
                    this.executeViaThread(this.connection == null ? null : this.connection.getConnection(), "SET ISOLATION SERIALIZABLE", null, false, 0, null, null);
                }
                catch (Error e) {
                    super.signalRollback();
                    super.endTransaction();
                    throw e;
                }
                catch (ManifoldCFException e) {
                    super.signalRollback();
                    super.endTransaction();
                    throw e;
                }
                super.beginTransaction(2);
                break;
            }
            default: {
                throw new ManifoldCFException("Bad transaction type");
            }
        }
    }

    @Override
    public void signalRollback() {
        if (this.serializableDepth == 0) {
            super.signalRollback();
        }
    }

    @Override
    public void endTransaction() throws ManifoldCFException {
        if (this.serializableDepth > 0) {
            --this.serializableDepth;
            return;
        }
        super.endTransaction();
        if (this.getTransactionID() == null) {
            int i = 0;
            while (i < this.tablesToAnalyze.size()) {
                this.analyzeTableInternal(this.tablesToAnalyze.get(i++));
            }
            this.tablesToAnalyze.clear();
            i = 0;
            while (i < this.tablesToReindex.size()) {
                this.reindexTableInternal(this.tablesToReindex.get(i++));
            }
            this.tablesToReindex.clear();
        }
    }

    @Override
    protected void startATransaction() throws ManifoldCFException {
        if (!this.inTransaction) {
            try {
                this.connection.getConnection().setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new ManifoldCFException(e.getMessage(), e, 4);
            }
            this.inTransaction = true;
        }
        ++this.depthCount;
    }

    @Override
    protected void commitCurrentTransaction() throws ManifoldCFException {
        if (this.inTransaction) {
            if (this.depthCount == 1) {
                try {
                    if (this.connection != null) {
                        this.connection.getConnection().commit();
                        this.connection.getConnection().setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    throw new ManifoldCFException(e.getMessage(), e, 4);
                }
                this.inTransaction = false;
            }
            --this.depthCount;
        } else {
            throw new ManifoldCFException("Transaction nesting error!");
        }
    }

    @Override
    protected void rollbackCurrentTransaction() throws ManifoldCFException {
        if (this.inTransaction) {
            if (this.depthCount == 1) {
                try {
                    if (this.connection != null) {
                        this.connection.getConnection().rollback();
                        this.connection.getConnection().setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    throw new ManifoldCFException(e.getMessage(), e, 4);
                }
                this.inTransaction = false;
            }
            --this.depthCount;
        } else {
            throw new ManifoldCFException("Transaction nesting error!");
        }
    }

    @Override
    protected String mapLabelName(String rawLabelName) {
        return rawLabelName.toLowerCase(Locale.ROOT);
    }

    public static String caseInsensitiveRegularExpressionCompare(String value, String regularExpression) throws SQLException {
        try {
            Pattern p = Pattern.compile(regularExpression, 2);
            Matcher m = p.matcher(value == null ? "" : value);
            if (m.find()) {
                return "true";
            }
            return "false";
        }
        catch (PatternSyntaxException e) {
            throw new SQLException("Pattern syntax exception: " + e.getMessage());
        }
    }

    public static String caseSensitiveRegularExpressionCompare(String value, String regularExpression) throws SQLException {
        try {
            Pattern p = Pattern.compile(regularExpression, 0);
            Matcher m = p.matcher(value == null ? "" : value);
            if (m.find()) {
                return "true";
            }
            return "false";
        }
        catch (PatternSyntaxException e) {
            throw new SQLException("Pattern syntax exception: " + e.getMessage());
        }
    }

    public static String caseInsensitiveSubstring(String value, String regularExpression) throws SQLException {
        try {
            Pattern p = Pattern.compile(regularExpression, 2);
            Matcher m = p.matcher(value == null ? "" : value);
            if (m.find()) {
                return m.group(1);
            }
            return "";
        }
        catch (IndexOutOfBoundsException e) {
            return value;
        }
        catch (PatternSyntaxException e) {
            throw new SQLException("Pattern syntax exception: " + e.getMessage());
        }
    }

    public static String caseSensitiveSubstring(String value, String regularExpression) throws SQLException {
        try {
            Pattern p = Pattern.compile(regularExpression, 0);
            Matcher m = p.matcher(value == null ? "" : value);
            if (m.find()) {
                return m.group(1);
            }
            return "";
        }
        catch (IndexOutOfBoundsException e) {
            return value;
        }
        catch (PatternSyntaxException e) {
            throw new SQLException("Pattern syntax exception: " + e.getMessage());
        }
    }

    static {
        System.setProperty("derby.locks.waitTimeout", "-1");
        System.setProperty("derby.locks.deadlockTimeout", "0");
    }

    protected static class TableStatistics {
        protected int eventCount = 0;

        public void reset() {
            this.eventCount = 0;
        }

        public void add(int eventCount) {
            this.eventCount += eventCount;
        }

        public int getEventCount() {
            return this.eventCount;
        }
    }
}

