/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.TransactionalCrawlerInitializationCommand;
import org.apache.manifoldcf.crawler.interfaces.ConnectorManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.IConnectorManager;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.system.Logging;

public class Register
extends TransactionalCrawlerInitializationCommand {
    public static final String _rcsid = "@(#)$Id: Register.java 988245 2010-08-23 18:39:35Z kwright $";
    private final String className;
    private final String description;

    private Register(String className, String description) {
        this.className = className;
        this.description = description;
    }

    @Override
    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        IConnectorManager mgr = ConnectorManagerFactory.make(tc);
        IJobManager jobManager = JobManagerFactory.make(tc);
        IRepositoryConnectionManager connManager = RepositoryConnectionManagerFactory.make(tc);
        mgr.registerConnector(this.description, this.className);
        String[] connectionNames = connManager.findConnectionsForConnector(this.className);
        jobManager.noteConnectorRegistration(connectionNames);
        Logging.root.info((Object)("Successfully registered connector '" + this.className + "'"));
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: Register <classname> <description>");
            System.exit(1);
        }
        String className = args[0];
        String description = args[1];
        try {
            Register register = new Register(className, description);
            register.execute();
            System.err.println("Successfully registered connector '" + className + "'");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

