/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.opensearchserver;

import org.apache.manifoldcf.agents.output.opensearchserver.OpenSearchServerParam;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IPostParameters;

public class OpenSearchServerConfig
extends OpenSearchServerParam {
    private static final long serialVersionUID = -2071296573398352538L;
    private static final OpenSearchServerParam.ParameterEnum[] CONFIGURATIONLIST = new OpenSearchServerParam.ParameterEnum[]{OpenSearchServerParam.ParameterEnum.SERVERLOCATION, OpenSearchServerParam.ParameterEnum.INDEXNAME, OpenSearchServerParam.ParameterEnum.USERNAME, OpenSearchServerParam.ParameterEnum.APIKEY, OpenSearchServerParam.ParameterEnum.SCHEDULERJOB};

    public OpenSearchServerConfig(ConfigParams params) {
        super(CONFIGURATIONLIST);
        for (OpenSearchServerParam.ParameterEnum param : CONFIGURATIONLIST) {
            String value = params.getParameter(param.name());
            if (value == null) {
                value = param.defaultValue;
            }
            this.put(param, value);
        }
    }

    public String getUniqueIndexIdentifier() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getServerLocation());
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append(this.getIndexName());
        return sb.toString();
    }

    public static final void contextToConfig(IPostParameters variableContext, ConfigParams parameters) {
        for (OpenSearchServerParam.ParameterEnum param : CONFIGURATIONLIST) {
            String p = variableContext.getParameter(param.name().toLowerCase());
            if (p == null) continue;
            parameters.setParameter(param.name(), p);
        }
    }

    public final String getServerLocation() {
        return (String)this.get((Object)OpenSearchServerParam.ParameterEnum.SERVERLOCATION);
    }

    public final String getIndexName() {
        return (String)this.get((Object)OpenSearchServerParam.ParameterEnum.INDEXNAME);
    }

    public final String getUserName() {
        return (String)this.get((Object)OpenSearchServerParam.ParameterEnum.USERNAME);
    }

    public final String getApiKey() {
        return (String)this.get((Object)OpenSearchServerParam.ParameterEnum.APIKEY);
    }

    public final String getSchedulerJob() {
        return (String)this.get((Object)OpenSearchServerParam.ParameterEnum.SCHEDULERJOB);
    }
}

