/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.tests;

import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class SchedulingRepositoryConnector
extends BaseRepositoryConnector {
    protected static final Map<String, Long> nextFetchTime = new HashMap<String, Long>();

    public String[] getBinNames(String documentIdentifier) {
        int index = documentIdentifier.indexOf("/");
        return new String[]{documentIdentifier.substring(0, index)};
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        String numberDomainsString = this.params.getParameter("numberDomains");
        if (numberDomainsString == null) {
            numberDomainsString = "10";
        }
        int numberDomains = Integer.parseInt(numberDomainsString);
        for (int i = 0; i < numberDomains; ++i) {
            activities.addSeedDocument(Integer.toString(i) + "/", null);
        }
        System.out.println("Seeding completed at " + System.currentTimeMillis());
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        String documentsPerSeedString = this.params.getParameter("documentsperseed");
        if (documentsPerSeedString == null) {
            documentsPerSeedString = "200";
        }
        int documentsPerSeed = Integer.parseInt(documentsPerSeedString);
        String timePerDocumentString = this.params.getParameter("timeperdocument");
        if (timePerDocumentString == null) {
            timePerDocumentString = "500";
        }
        int timePerDocument = Integer.parseInt(timePerDocumentString);
        for (int i = 0; i < documentIdentifiers.length; ++i) {
            long whenFetch;
            String documentIdentifier = documentIdentifiers[i];
            if (documentIdentifier.endsWith("/")) {
                System.out.println("Evaluating seed for " + documentIdentifier + " at " + System.currentTimeMillis());
                for (int j = 0; j < documentsPerSeed; ++j) {
                    activities.addDocumentReference(documentIdentifier + Integer.toString(j), documentIdentifier, null, null, (Object[][])null, null);
                }
                System.out.println("Done evaluating seed for " + documentIdentifier + " at " + System.currentTimeMillis());
                continue;
            }
            System.out.println("Fetching " + documentIdentifier);
            String bin = documentIdentifier.substring(0, documentIdentifier.indexOf("/"));
            long binTimePerDocument = timePerDocument;
            long now = System.currentTimeMillis();
            Map<String, Long> map = nextFetchTime;
            synchronized (map) {
                Long time = nextFetchTime.get(bin);
                whenFetch = time == null ? now : time;
                nextFetchTime.put(bin, new Long(whenFetch + binTimePerDocument));
            }
            if (whenFetch <= now) continue;
            System.out.println("Waiting " + (whenFetch - now) + " to fetch " + documentIdentifier);
            try {
                ManifoldCF.sleep((long)(whenFetch - now));
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException(e.getMessage(), 2);
            }
            System.out.println("Wait complete for " + documentIdentifier);
        }
    }
}

