/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.io.MatFileFilter;
import com.jmatio.io.MatFileHeader;
import com.jmatio.io.MatTag;
import com.jmatio.io.MatlabIOException;
import com.jmatio.io.stream.BufferedOutputStream;
import com.jmatio.io.stream.ByteBufferInputStream;
import com.jmatio.io.stream.ByteBufferedOutputStream;
import com.jmatio.io.stream.MatFileInputStream;
import com.jmatio.types.ByteStorageSupport;
import com.jmatio.types.MLArray;
import com.jmatio.types.MLCell;
import com.jmatio.types.MLChar;
import com.jmatio.types.MLDouble;
import com.jmatio.types.MLEmptyArray;
import com.jmatio.types.MLInt16;
import com.jmatio.types.MLInt32;
import com.jmatio.types.MLInt64;
import com.jmatio.types.MLInt8;
import com.jmatio.types.MLJavaObject;
import com.jmatio.types.MLNumericArray;
import com.jmatio.types.MLObject;
import com.jmatio.types.MLSingle;
import com.jmatio.types.MLSparse;
import com.jmatio.types.MLStructure;
import com.jmatio.types.MLUInt32;
import com.jmatio.types.MLUInt64;
import com.jmatio.types.MLUInt8;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatFileReader {
    private static final Logger LOG = LoggerFactory.getLogger(MatFileReader.class);
    public static final boolean UNMAP_SUPPORTED;
    public static final String UNMAP_NOT_SUPPORTED_REASON;
    private static final BufferCleaner CLEANER;
    public static final int MEMORY_MAPPED_FILE = 1;
    public static final int DIRECT_BYTE_BUFFER = 2;
    public static final int HEAP_BYTE_BUFFER = 4;
    private static boolean ALLOW_OBJECT_DESERIALIZATION;
    private MatFileHeader matFileHeader;
    private Map<String, MLArray> data;
    private ByteOrder byteOrder;
    private MatFileFilter filter = new MatFileFilter();
    private static final int DIRECT_BUFFER_LIMIT = 0x2000000;

    public static void setAllowObjectDeserialization(boolean allowDeserialization) {
        ALLOW_OBJECT_DESERIALIZATION = allowDeserialization;
    }

    public MatFileReader(String fileName) throws IOException {
        this(new File(fileName), new MatFileFilter());
    }

    public MatFileReader(String fileName, MatFileFilter filter) throws IOException {
        this(new File(fileName), filter);
    }

    public MatFileReader(File file) throws IOException {
        this(file, new MatFileFilter());
    }

    public MatFileReader(File file, MatFileFilter filter) throws IOException {
        this();
        this.read(file, filter, 1);
    }

    public MatFileReader() {
        this.data = new LinkedHashMap<String, MLArray>();
    }

    public synchronized Map<String, MLArray> read(File file) throws IOException {
        return this.read(file, new MatFileFilter(), 1);
    }

    public synchronized Map<String, MLArray> read(File file, int policy) throws IOException {
        return this.read(file, new MatFileFilter(), policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, MLArray> read(File file, MatFileFilter filter, int policy) throws IOException {
        this.filter = filter;
        for (String key : this.data.keySet()) {
            this.data.remove(key);
        }
        AbstractInterruptibleChannel roChannel = null;
        RandomAccessFile raFile = null;
        ByteBuffer buf = null;
        WeakReference<MappedByteBuffer> bufferWeakRef = null;
        try {
            raFile = new RandomAccessFile(file, "r");
            roChannel = raFile.getChannel();
            switch (policy) {
                case 2: {
                    buf = ByteBuffer.allocateDirect((int)((FileChannel)roChannel).size());
                    ((FileChannel)roChannel).read(buf, 0L);
                    buf.rewind();
                    break;
                }
                case 4: {
                    int filesize = (int)((FileChannel)roChannel).size();
                    System.gc();
                    buf = ByteBuffer.allocate(filesize);
                    int numberOfBlocks = filesize / 0x2000000 + (filesize % 0x2000000 > 0 ? 1 : 0);
                    if (numberOfBlocks > 1) {
                        ByteBuffer tempByteBuffer = ByteBuffer.allocateDirect(0x2000000);
                        for (int block = 0; block < numberOfBlocks; ++block) {
                            tempByteBuffer.clear();
                            ((FileChannel)roChannel).read(tempByteBuffer, block * 0x2000000);
                            tempByteBuffer.flip();
                            buf.put(tempByteBuffer);
                        }
                        tempByteBuffer = null;
                    } else {
                        ((FileChannel)roChannel).read(buf, 0L);
                    }
                    buf.rewind();
                    break;
                }
                case 1: {
                    buf = ((FileChannel)roChannel).map(FileChannel.MapMode.READ_ONLY, 0L, (int)((FileChannel)roChannel).size());
                    bufferWeakRef = new WeakReference<MappedByteBuffer>((MappedByteBuffer)buf);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown file allocation policy");
                }
            }
            this.readHeader(buf);
            while (buf.remaining() > 0) {
                this.readData(buf);
            }
            Map<String, MLArray> map = this.getContent();
            return map;
        }
        finally {
            if (roChannel != null) {
                try {
                    roChannel.close();
                }
                catch (IOException e) {
                    LOG.warn("problem closing file", (Throwable)e);
                }
            }
            if (raFile != null) {
                try {
                    raFile.close();
                }
                catch (IOException e) {
                    LOG.warn("problem closing file", (Throwable)e);
                }
            }
            if (buf != null && bufferWeakRef != null && policy == 1 && CLEANER != null) {
                try {
                    CLEANER.freeBuffer("buff", buf);
                }
                catch (Exception e) {
                    LOG.warn("problem freeing buffer", (Throwable)e);
                    int GC_TIMEOUT_MS = 1000;
                    buf = null;
                    long start = System.currentTimeMillis();
                    while (bufferWeakRef.get() != null) {
                        if (System.currentTimeMillis() - start > (long)GC_TIMEOUT_MS) {
                            LOG.warn("couldn't unmap buffer");
                            break;
                        }
                        System.gc();
                        Thread.yield();
                    }
                }
            }
        }
    }

    public MatFileHeader getMatFileHeader() {
        return this.matFileHeader;
    }

    public ArrayList<MLArray> getData() {
        return new ArrayList<MLArray>(this.data.values());
    }

    public MLArray getMLArray(String name) {
        return this.data.get(name);
    }

    public Map<String, MLArray> getContent() {
        return this.data;
    }

    private void readData(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        switch (tag.type) {
            case 15: {
                long numOfBytes = tag.size;
                if ((long)buf.remaining() < numOfBytes) {
                    throw new MatlabIOException("Compressed buffer length miscalculated!");
                }
                InflaterInputStream iis = new InflaterInputStream(new ByteBufferInputStream(buf, numOfBytes));
                byte[] result = new byte[1024];
                ByteBufferedOutputStream dos = new ByteBufferedOutputStream(tag.size, false);
                try {
                    int i;
                    do {
                        i = iis.read(result, 0, result.length);
                        int len = Math.max(0, i);
                        ((OutputStream)dos).write(result, 0, len);
                    } while (i > 0);
                }
                catch (IOException e) {
                    throw new MatlabIOException("Could not decompress data: " + e);
                }
                finally {
                    iis.close();
                    dos.flush();
                }
                ByteBuffer out = ((BufferedOutputStream)dos).buffer();
                out.rewind();
                out.order(this.byteOrder);
                try {
                    this.readData(out);
                    break;
                }
                catch (IOException e) {
                    throw e;
                }
                finally {
                    dos.close();
                }
            }
            case 14: {
                int toread;
                int red;
                int pos = buf.position();
                MLArray element = this.readMatrix(buf, true);
                if (element != null && !this.data.containsKey(element.getName())) {
                    this.data.put(element.getName(), element);
                } else {
                    red = buf.position() - pos;
                    toread = tag.size - red;
                    buf.position(buf.position() + toread);
                }
                red = buf.position() - pos;
                toread = tag.size - red;
                if (toread == 0) break;
                throw new MatlabIOException("Matrix was not red fully! " + toread + " remaining in the buffer.");
            }
            default: {
                throw new MatlabIOException("Incorrect data tag: " + tag);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private MLArray readMatrix(ByteBuffer buf, boolean isRoot) throws IOException {
        mlArray = null;
        flags = this.readFlags(buf);
        attributes = flags.length != 0 ? flags[0] : 0;
        nzmax = flags.length != 0 ? flags[1] : 0;
        type = attributes & 255;
        dims = this.readDimension(buf);
        name = this.readName(buf);
        if (isRoot && !this.filter.matches(name)) {
            return null;
        }
        switch (type) {
            case 2: {
                struct = new MLStructure(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                maxlen = buf.getInt();
                tag = new ISMatTag(buf);
                numOfFields = tag.size / maxlen;
                fieldNames = new String[numOfFields];
                for (i = 0; i < numOfFields; ++i) {
                    names = new byte[maxlen];
                    buf.get(names);
                    fieldNames[i] = this.zeroEndByteArrayToString(names);
                }
                buf.position(buf.position() + ISMatTag.access$000(tag));
                for (index = 0; index < struct.getM() * struct.getN(); ++index) {
                    for (i = 0; i < numOfFields; ++i) {
                        tag = new ISMatTag(buf);
                        if (tag.size > 0) {
                            fieldValue = this.readMatrix(buf, false);
                            struct.setField(fieldNames[i], fieldValue, index);
                            continue;
                        }
                        struct.setField(fieldNames[i], new MLEmptyArray(), index);
                    }
                }
                mlArray = struct;
                break;
            }
            case 1: {
                cell = new MLCell(name, dims, type, attributes);
                for (i = 0; i < cell.getM() * cell.getN(); ++i) {
                    tag = new ISMatTag(buf);
                    if (tag.size > 0) {
                        cellmatrix = this.readMatrix(buf, false);
                        cell.set(cellmatrix, i);
                        continue;
                    }
                    cell.set(new MLEmptyArray(), i);
                }
                mlArray = cell;
                break;
            }
            case 6: {
                mlArray = new MLDouble(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 7: {
                mlArray = new MLSingle(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 9: {
                mlArray = new MLUInt8(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 8: {
                mlArray = new MLInt8(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 10: {
                mlArray = new MLInt16(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 12: {
                mlArray = new MLInt32(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 13: {
                mlArray = new MLUInt32(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 14: {
                mlArray = new MLInt64(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 15: {
                mlArray = new MLUInt64(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getRealByteBuffer(), (MLNumericArray)mlArray);
                if (!mlArray.isComplex()) break;
                tag = new ISMatTag(buf);
                tag.readToByteBuffer(((MLNumericArray)mlArray).getImaginaryByteBuffer(), (MLNumericArray)mlArray);
                break;
            }
            case 4: {
                mlchar = new MLChar(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                str = tag.readToString();
                for (i = 0; i < str.length(); ++i) {
                    mlchar.setChar(str.charAt(i), i);
                }
                mlArray = mlchar;
                break;
            }
            case 5: {
                sparse = new MLSparse(name, dims, attributes, nzmax);
                tag = new ISMatTag(buf);
                ir = tag.readToIntArray();
                tag = new ISMatTag(buf);
                jc = tag.readToIntArray();
                tag = new ISMatTag(buf);
                ad1 = tag.readToDoubleArray();
                count = 0;
                for (column = 0; column < sparse.getN(); ++column) {
                    while (count < jc[column + 1]) {
                        sparse.setReal(ad1[count], ir[count], column);
                        ++count;
                    }
                }
                if (sparse.isComplex()) {
                    tag = new ISMatTag(buf);
                    ad2 = tag.readToDoubleArray();
                    count = 0;
                    for (column = 0; column < sparse.getN(); ++column) {
                        while (count < jc[column + 1]) {
                            sparse.setImaginary(ad2[count], ir[count], column);
                            ++count;
                        }
                    }
                }
                mlArray = sparse;
                break;
            }
            case 17: {
                if (!MatFileReader.ALLOW_OBJECT_DESERIALIZATION) break;
                tag = new ISMatTag(buf);
                className = tag.readToString();
                nn = new byte[dims.length];
                for (i = 0; i < dims.length; ++i) {
                    nn[i] = (byte)dims[i];
                }
                arrName = new String(nn, StandardCharsets.US_ASCII);
                contentTag = new ISMatTag(buf);
                if (contentTag.type != 14) ** GOTO lbl205
                content = (MLUInt8)this.readMatrix(buf, false);
                if (content.getRealByteBuffer() == null) break;
                try {
                    ois = new ObjectInputStream(new ByteBufferInputStream(content.getRealByteBuffer(), content.getRealByteBuffer().limit()));
                    var29_64 = null;
                    o = ois.readObject();
                    mlArray = new MLJavaObject(arrName, className, o);
                    if (ois == null) break;
                    if (var29_64 == null) ** GOTO lbl185
                    try {
                        ois.close();
                    }
                    catch (Throwable var30_66) {
                        var29_64.addSuppressed(var30_66);
                    }
                    break;
lbl185:
                    // 1 sources

                    ois.close();
                    ** break;
                    catch (Throwable var30_67) {
                        try {
                            var29_64 = var30_67;
                            throw var30_67;
                        }
                        catch (Throwable var31_68) {
                            if (ois != null) {
                                if (var29_64 != null) {
                                    try {
                                        ois.close();
                                    }
                                    catch (Throwable var32_69) {
                                        var29_64.addSuppressed(var32_69);
                                    }
                                } else {
                                    ois.close();
                                }
                            }
                            throw var31_68;
lbl202:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
lbl205:
                // 1 sources

                throw new IOException("Unexpected java object content");
            }
            case 3: {
                tag = new ISMatTag(buf);
                className = tag.readToString();
                struct = new MLStructure(name, dims, type, attributes);
                tag = new ISMatTag(buf);
                maxlen = buf.getInt();
                tag = new ISMatTag(buf);
                numOfFields = tag.size / maxlen;
                fieldNames = new String[numOfFields];
                for (i = 0; i < numOfFields; ++i) {
                    names = new byte[maxlen];
                    buf.get(names);
                    fieldNames[i] = this.zeroEndByteArrayToString(names);
                }
                buf.position(buf.position() + ISMatTag.access$000(tag));
                for (index = 0; index < 1; ++index) {
                    for (i = 0; i < numOfFields; ++i) {
                        tag = new ISMatTag(buf);
                        if (tag.size > 0) {
                            fieldValue = this.readMatrix(buf, false);
                            struct.setField(fieldNames[i], fieldValue, index);
                            continue;
                        }
                        struct.setField(fieldNames[i], new MLEmptyArray(), index);
                    }
                }
                mlArray = new MLObject(name, className, struct);
                break;
            }
            default: {
                throw new MatlabIOException("Incorrect matlab array class: " + MLArray.typeToString(type));
            }
        }
        return mlArray;
    }

    private String zeroEndByteArrayToString(byte[] bytes) throws IOException {
        int i = 0;
        for (i = 0; i < bytes.length && bytes[i] != 0; ++i) {
        }
        return new String(bytes, 0, i, StandardCharsets.ISO_8859_1);
    }

    private int[] readFlags(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        int[] flags = tag.readToIntArray();
        return flags;
    }

    private int[] readDimension(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        int[] dims = tag.readToIntArray();
        return dims;
    }

    private String readName(ByteBuffer buf) throws IOException {
        ISMatTag tag = new ISMatTag(buf);
        return tag.readToString();
    }

    private void readHeader(ByteBuffer buf) throws IOException {
        int version;
        byte[] endianIndicator = new byte[2];
        byte[] descriptionBuffer = new byte[116];
        buf.get(descriptionBuffer);
        String description = this.zeroEndByteArrayToString(descriptionBuffer);
        if (!description.startsWith("MATLAB 5.0 MAT-file")) {
            throw new MatlabIOException("This is not a valid MATLAB 5.0 MAT-file.");
        }
        buf.position(buf.position() + 8);
        byte[] bversion = new byte[2];
        buf.get(bversion);
        buf.get(endianIndicator);
        if ((char)endianIndicator[0] == 'I' && (char)endianIndicator[1] == 'M') {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
            version = bversion[1] & 0xFF | bversion[0] << 8;
        } else {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            version = bversion[0] & 0xFF | bversion[1] << 8;
        }
        buf.order(this.byteOrder);
        this.matFileHeader = new MatFileHeader(description, version, endianIndicator);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object unmapHackImpl() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            MethodHandle unmapper = lookup.findVirtual(unsafeClass, "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Object theUnsafe = f.get(null);
            return MatFileReader.newBufferCleaner(ByteBuffer.class, unmapper.bindTo(theUnsafe));
        }
        catch (SecurityException se) {
            try {
                throw se;
                catch (ReflectiveOperationException | RuntimeException e) {
                    Class<?> directBufferClass = Class.forName("java.nio.DirectByteBuffer");
                    Method m = directBufferClass.getMethod("cleaner", new Class[0]);
                    m.setAccessible(true);
                    MethodHandle directBufferCleanerMethod = lookup.unreflect(m);
                    TypeDescriptor.OfField cleanerClass = directBufferCleanerMethod.type().returnType();
                    MethodHandle cleanMethod = lookup.findVirtual((Class<?>)cleanerClass, "clean", MethodType.methodType(Void.TYPE));
                    MethodHandle nonNullTest = lookup.findStatic(Objects.class, "nonNull", MethodType.methodType(Boolean.TYPE, Object.class)).asType(MethodType.methodType(Boolean.TYPE, cleanerClass));
                    MethodHandle noop = MethodHandles.dropArguments(MethodHandles.constant(Void.class, null).asType(MethodType.methodType(Void.TYPE)), 0, new Class[]{cleanerClass});
                    MethodHandle unmapper = MethodHandles.filterReturnValue(directBufferCleanerMethod, MethodHandles.guardWithTest(nonNullTest, cleanMethod, noop)).asType(MethodType.methodType(Void.TYPE, ByteBuffer.class));
                    return MatFileReader.newBufferCleaner(directBufferClass, unmapper);
                }
            }
            catch (SecurityException se2) {
                return "Unmapping is not supported, because not all required permissions are given to the Lucene JAR file: " + se2 + " [Please grant at least the following permissions: RuntimePermission(\"accessClassInPackage.sun.misc\")  and ReflectPermission(\"suppressAccessChecks\")]";
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                return "Unmapping is not supported on this platform, because internal Java APIs are not compatible with this Lucene version: " + e;
            }
        }
    }

    private static BufferCleaner newBufferCleaner(Class<?> unmappableBufferClass, MethodHandle unmapper) {
        assert (Objects.equals(MethodType.methodType(Void.TYPE, ByteBuffer.class), unmapper.type()));
        return (resourceDescription, buffer) -> {
            if (!buffer.isDirect()) {
                throw new IllegalArgumentException("unmapping only works with direct buffers");
            }
            if (!unmappableBufferClass.isInstance(buffer)) {
                throw new IllegalArgumentException("buffer is not an instance of " + unmappableBufferClass.getName());
            }
            Throwable error = AccessController.doPrivileged(() -> {
                try {
                    unmapper.invokeExact(buffer);
                    return null;
                }
                catch (Throwable t) {
                    return t;
                }
            });
            if (error != null) {
                throw new IOException("Unable to unmap the mapped buffer: " + resourceDescription, error);
            }
        };
    }

    static {
        Object hack = AccessController.doPrivileged(MatFileReader::unmapHackImpl);
        if (hack instanceof BufferCleaner) {
            CLEANER = (BufferCleaner)hack;
            UNMAP_SUPPORTED = true;
            UNMAP_NOT_SUPPORTED_REASON = null;
        } else {
            CLEANER = null;
            UNMAP_SUPPORTED = false;
            UNMAP_NOT_SUPPORTED_REASON = hack.toString();
            LOG.warn(UNMAP_NOT_SUPPORTED_REASON);
        }
        ALLOW_OBJECT_DESERIALIZATION = false;
    }

    private static interface BufferCleaner {
        public void freeBuffer(String var1, ByteBuffer var2) throws IOException;
    }

    private static class ISMatTag
    extends MatTag {
        private final MatFileInputStream mfis;
        private final int padding;
        private final boolean compressed;

        public ISMatTag(ByteBuffer buf) throws IOException {
            super(0, 0);
            int tmp = buf.getInt();
            if (tmp >> 16 == 0) {
                this.type = tmp;
                this.size = buf.getInt();
                this.compressed = false;
            } else {
                this.size = tmp >> 16;
                this.type = tmp & 0xFFFF;
                this.compressed = true;
            }
            this.padding = this.getPadding(this.size, this.compressed);
            this.mfis = new MatFileInputStream(buf, this.type);
        }

        public void readToByteBuffer(ByteBuffer buff, ByteStorageSupport<?> storage) throws IOException {
            int elements = this.size / this.sizeOf();
            this.mfis.readToByteBuffer(buff, elements, storage);
            this.mfis.skip(this.padding);
        }

        public byte[] readToByteArray() throws IOException {
            int elements = this.size / this.sizeOf();
            byte[] ab = new byte[elements];
            for (int i = 0; i < elements; ++i) {
                ab[i] = this.mfis.readByte();
            }
            this.mfis.skip(this.padding);
            return ab;
        }

        public double[] readToDoubleArray() throws IOException {
            int elements = this.size / this.sizeOf();
            double[] ad = new double[elements];
            for (int i = 0; i < elements; ++i) {
                ad[i] = this.mfis.readDouble();
            }
            this.mfis.skip(this.padding);
            return ad;
        }

        public int[] readToIntArray() throws IOException {
            int elements = this.size / this.sizeOf();
            int[] ai = new int[elements];
            for (int i = 0; i < elements; ++i) {
                ai[i] = this.mfis.readInt();
            }
            this.mfis.skip(this.padding);
            return ai;
        }

        public String readToString() throws IOException {
            byte[] bytes = this.readToByteArray();
            return new String(bytes, StandardCharsets.UTF_8);
        }

        public char[] readToCharArray() throws IOException {
            int elements = this.size / this.sizeOf();
            char[] ac = new char[elements];
            for (int i = 0; i < elements; ++i) {
                ac[i] = this.mfis.readChar();
            }
            this.mfis.skip(this.padding);
            return ac;
        }

        static /* synthetic */ int access$000(ISMatTag x0) {
            return x0.padding;
        }
    }
}

