/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.decode;

import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.PigWarning;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class Bin
extends EvalFunc<String> {
    int numParams = -1;

    public Schema outputSchema(Schema input) {
        try {
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 55));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String exec(Tuple tuple) throws IOException {
        if (this.numParams == -1) {
            this.numParams = tuple.size();
            if (this.numParams <= 2) {
                String msg = "Bin : An expression & atleast a default string are required.";
                throw new IOException(msg);
            }
            if (tuple.size() % 2 != 0) {
                String msg = "Bin : Some parameters are unmatched.";
                throw new IOException(msg);
            }
        }
        if (tuple.get(0) == null) {
            return null;
        }
        try {
            for (int count = 1; count < this.numParams; count += 2) {
                if (count != this.numParams - 1 && !(((Number)tuple.get(0)).doubleValue() <= ((Number)tuple.get(count + 1)).doubleValue())) continue;
                return (String)tuple.get(count);
            }
        }
        catch (ClassCastException e) {
            this.warn("Bin : Data type error", (Enum)PigWarning.UDF_WARNING_1);
            return null;
        }
        catch (NullPointerException e) {
            String msg = "Bin : Encounter null in the input";
            throw new IOException(msg);
        }
        String msg = "Bin : Internal Failure";
        throw new IOException(msg);
    }
}

