/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data;

import javax.annotation.concurrent.Immutable;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.Data;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.DoublePointData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.GaugeData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.HistogramData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.LongPointData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.MetricDataType;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.SumData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.SummaryData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableSummaryData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.resources.Resource;

@Immutable
public interface MetricData {
    public Resource getResource();

    public InstrumentationScopeInfo getInstrumentationScopeInfo();

    public String getName();

    public String getDescription();

    public String getUnit();

    public MetricDataType getType();

    public Data<?> getData();

    default public boolean isEmpty() {
        return this.getData().getPoints().isEmpty();
    }

    default public GaugeData<DoublePointData> getDoubleGaugeData() {
        if (this.getType() == MetricDataType.DOUBLE_GAUGE) {
            return (GaugeData)this.getData();
        }
        return ImmutableGaugeData.empty();
    }

    default public GaugeData<LongPointData> getLongGaugeData() {
        if (this.getType() == MetricDataType.LONG_GAUGE) {
            return (GaugeData)this.getData();
        }
        return ImmutableGaugeData.empty();
    }

    default public SumData<DoublePointData> getDoubleSumData() {
        if (this.getType() == MetricDataType.DOUBLE_SUM) {
            return (ImmutableSumData)this.getData();
        }
        return ImmutableSumData.empty();
    }

    default public SumData<LongPointData> getLongSumData() {
        if (this.getType() == MetricDataType.LONG_SUM) {
            return (SumData)this.getData();
        }
        return ImmutableSumData.empty();
    }

    default public SummaryData getSummaryData() {
        if (this.getType() == MetricDataType.SUMMARY) {
            return (SummaryData)this.getData();
        }
        return ImmutableSummaryData.empty();
    }

    default public HistogramData getHistogramData() {
        if (this.getType() == MetricDataType.HISTOGRAM) {
            return (HistogramData)this.getData();
        }
        return ImmutableHistogramData.empty();
    }
}

