/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client.ws;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.DynamicPropertyFactory;
import org.apache.servicecomb.foundation.vertx.client.ws.WebSocketClientOptionsSPI;
import org.apache.servicecomb.transport.common.TransportConfigUtils;

public class WebSocketTransportClientOptionsSPI
extends WebSocketClientOptionsSPI {
    public static final String CLIENT_NAME = "ws-transport-client";
    public static final String CLIENT_TAG = "websocket.consumer";
    public static final boolean DEFAULT_CLIENT_COMPRESSION_SUPPORT = false;
    private static final int DEFAULT_IDLE_TIME_OUT = 150;

    public String clientName() {
        return CLIENT_NAME;
    }

    public int getOrder() {
        return 100;
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.websocket.client.enabled", true).get();
    }

    public String getConfigTag() {
        return CLIENT_TAG;
    }

    public ConcurrentCompositeConfiguration getConfigReader() {
        return null;
    }

    public int getEventLoopPoolSize() {
        return -1;
    }

    public boolean useSharedVertx() {
        return true;
    }

    public int getInstanceCount() {
        return TransportConfigUtils.readVerticleCount((String)"servicecomb.websocket.client.verticle-count", (String)"servicecomb.websocket.client.thread-count");
    }

    public boolean isWorker() {
        return false;
    }

    public String getWorkerPoolName() {
        return "pool-worker-transport-client-websocket";
    }

    public int getWorkerPoolSize() {
        return 20;
    }

    public int getConnectTimeoutInMillis() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.websocket.client.connection.timeoutInMillis", 60000).get();
    }

    public int getIdleTimeoutInSeconds() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.websocket.client.connection.idleTimeoutInSeconds", 150).get();
    }

    public boolean enableLogActivity() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.websocket.client.enableLogActivity", false).get();
    }

    public boolean isUseAlpn() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.websocket.client.useAlpnEnabled", false).get();
    }

    public boolean isProxyEnable() {
        return false;
    }

    public String getProxyHost() {
        return null;
    }

    public int getProxyPort() {
        return 0;
    }

    public String getProxyUsername() {
        return null;
    }

    public String getProxyPassword() {
        return null;
    }

    public boolean isSsl() {
        return true;
    }

    public int getMaxFrameSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.websocket.client.maxFrameSize", 65536).get();
    }

    public int getMaxMessageSize() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.websocket.client.maxMessageSize", 262144).get();
    }

    public int getMaxConnections() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.websocket.client.connection.maxPoolSize", 50).get();
    }

    public boolean getTryUsePerFrameCompression() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.websocket.client.tryUsePerFrameCompression", false).get();
    }

    public boolean getTryUsePerMessageCompression() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.websocket.client.tryUsePerMessageCompression", false).get();
    }

    public int getCompressionLevel() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.websocket.client.compressionLevel", 6).get();
    }

    public int getClosingTimeoutInSeconds() {
        return DynamicPropertyFactory.getInstance().getIntProperty("servicecomb.websocket.client.connection.closingTimeoutInSeconds", 10).get();
    }
}

