/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jedis.v3;

import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jedis.v3.JedisPluginConfig;
import org.apache.skywalking.apm.util.StringUtil;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Transaction;

public class JedisMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String peer = String.valueOf(objInst.getSkyWalkingDynamicField());
        AbstractSpan span = ContextManager.createExitSpan((String)("Jedis/" + method.getName()), (String)peer);
        span.setComponent((Component)ComponentsDefine.JEDIS);
        SpanLayer.asCache((AbstractSpan)span);
        String methodName = method.getName();
        Tags.CACHE_TYPE.set(span, "Redis");
        if (objInst instanceof Pipeline || objInst instanceof Transaction) {
            Tags.CACHE_CMD.set(span, "BATCH_EXECUTE");
        } else {
            Tags.CACHE_CMD.set(span, methodName);
            this.getKey(allArguments).ifPresent(key -> Tags.CACHE_KEY.set(span, key));
            this.parseOperation(methodName).ifPresent(op -> Tags.CACHE_OP.set(span, op));
        }
    }

    private Optional<String> getKey(Object[] allArguments) {
        if (!JedisPluginConfig.Plugin.Jedis.TRACE_REDIS_PARAMETERS) {
            return Optional.empty();
        }
        if (allArguments.length == 0) {
            return Optional.empty();
        }
        Object argument = allArguments[0];
        if (!(argument instanceof String)) {
            return Optional.empty();
        }
        return Optional.of(StringUtil.cut((String)((String)argument), (int)JedisPluginConfig.Plugin.Jedis.REDIS_PARAMETER_MAX_LENGTH));
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan span = ContextManager.activeSpan();
        span.log(t);
    }

    private Optional<String> parseOperation(String cmd) {
        if (JedisPluginConfig.Plugin.Jedis.OPERATION_MAPPING_READ.contains(cmd)) {
            return Optional.of("read");
        }
        if (JedisPluginConfig.Plugin.Jedis.OPERATION_MAPPING_WRITE.contains(cmd)) {
            return Optional.of("write");
        }
        return Optional.empty();
    }
}

