/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.activation.meter.util;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.agent.core.meter.MeterId;
import org.apache.skywalking.apm.agent.core.meter.MeterTag;
import org.apache.skywalking.apm.agent.core.meter.MeterType;

public class MeterIdConverter {
    public static MeterId convert(org.apache.skywalking.apm.toolkit.meter.MeterId id) {
        String meterName = id.getName();
        MeterType type = MeterIdConverter.convertType(id);
        List tags = Collections.emptyList();
        if (id.getTags() != null) {
            tags = id.getTags().stream().map(t -> new MeterTag(t.getName(), t.getValue())).collect(Collectors.toList());
        }
        return new MeterId(meterName, type, tags);
    }

    private static MeterType convertType(org.apache.skywalking.apm.toolkit.meter.MeterId id) {
        switch (id.getType()) {
            case GAUGE: {
                return MeterType.GAUGE;
            }
            case COUNTER: {
                return MeterType.COUNTER;
            }
            case HISTOGRAM: {
                return MeterType.HISTOGRAM;
            }
        }
        throw new IllegalStateException("Could not found the meter type: " + id.getType());
    }
}

