/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.feign.http.v9;

import feign.Request;
import feign.Response;
import feign.Util;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.feign.http.v9.FeignPluginConfig;
import org.apache.skywalking.apm.plugin.feign.http.v9.FeignResolvedURL;
import org.apache.skywalking.apm.plugin.feign.http.v9.PathVarInterceptor;
import org.apache.skywalking.apm.util.StringUtil;

public class DefaultHttpClientInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static Field FIELD_HEADERS_OF_REQUEST;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Request request = (Request)allArguments[0];
        URL url = new URL(request.url());
        ContextCarrier contextCarrier = new ContextCarrier();
        int port = url.getPort() == -1 ? 80 : url.getPort();
        String remotePeer = url.getHost() + ":" + port;
        String operationName = url.getPath();
        FeignResolvedURL feignResolvedURL = PathVarInterceptor.URL_CONTEXT.get();
        if (feignResolvedURL != null) {
            try {
                operationName = operationName.replace(feignResolvedURL.getUrl(), feignResolvedURL.getOriginUrl());
            }
            finally {
                PathVarInterceptor.URL_CONTEXT.remove();
            }
        }
        if (operationName.length() == 0) {
            operationName = "/";
        }
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (ContextCarrier)contextCarrier, (String)remotePeer);
        span.setComponent((Component)ComponentsDefine.FEIGN);
        Tags.HTTP.METHOD.set(span, request.method());
        Tags.URL.set(span, request.url());
        SpanLayer.asHttp((AbstractSpan)span);
        if (FeignPluginConfig.Plugin.Feign.COLLECT_REQUEST_BODY) {
            boolean needCollectHttpBody = false;
            Iterator stringIterator = Util.valuesOrEmpty((Map)request.headers(), (String)CONTENT_TYPE_HEADER).iterator();
            String contentTypeHeaderValue = stringIterator.hasNext() ? (String)stringIterator.next() : "";
            for (String contentType : FeignPluginConfig.Plugin.Feign.SUPPORTED_CONTENT_TYPES_PREFIX.split(",")) {
                if (!contentTypeHeaderValue.startsWith(contentType)) continue;
                needCollectHttpBody = true;
                break;
            }
            if (needCollectHttpBody) {
                this.collectHttpBody(request, span);
            }
        }
        if (FIELD_HEADERS_OF_REQUEST != null) {
            LinkedHashMap headers = new LinkedHashMap();
            CarrierItem next = contextCarrier.items();
            while (next.hasNext()) {
                next = next.next();
                ArrayList<String> contextCollection = new ArrayList<String>(1);
                contextCollection.add(next.getHeadValue());
                headers.put(next.getHeadKey(), contextCollection);
            }
            headers.putAll(request.headers());
            FIELD_HEADERS_OF_REQUEST.set(request, Collections.unmodifiableMap(headers));
        }
    }

    private void collectHttpBody(Request request, AbstractSpan span) {
        if (request.body() == null || request.charset() == null) {
            return;
        }
        String tagValue = new String(request.body(), request.charset());
        tagValue = FeignPluginConfig.Plugin.Feign.FILTER_LENGTH_LIMIT > 0 ? StringUtil.cut((String)tagValue, (int)FeignPluginConfig.Plugin.Feign.FILTER_LENGTH_LIMIT) : tagValue;
        Tags.HTTP.BODY.set(span, tagValue);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        Response response = (Response)ret;
        if (response != null) {
            int statusCode = response.status();
            AbstractSpan span = ContextManager.activeSpan();
            Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(statusCode));
            if (statusCode >= 400) {
                span.errorOccurred();
            }
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        AbstractSpan activeSpan = ContextManager.activeSpan();
        activeSpan.log(t);
    }

    static {
        try {
            Field field = Request.class.getDeclaredField("headers");
            field.setAccessible(true);
            FIELD_HEADERS_OF_REQUEST = field;
        }
        catch (Exception ignore) {
            FIELD_HEADERS_OF_REQUEST = null;
        }
    }
}

