/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser;

import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.AbstractURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLLocation;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class PostgreSQLURLParser
extends AbstractURLParser {
    private static final int DEFAULT_PORT = 5432;
    private static final String DB_TYPE = "PostgreSQL";
    private static final String URL_PARAMS_HOST_KEY = "host";
    private static final String URL_PARAMS_PORT_KEY = "port";

    public PostgreSQLURLParser(String url) {
        super(url);
    }

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange() {
        int hostLabelStartIndex = this.url.indexOf("//");
        int hostLabelEndIndex = this.url.indexOf("/", hostLabelStartIndex + 2);
        if (hostLabelEndIndex == -1) {
            hostLabelEndIndex = this.url.length();
        }
        return new URLLocation(hostLabelStartIndex + 2, hostLabelEndIndex);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange() {
        int databaseLabelStartIndex = this.url.indexOf("//");
        int databaseStartTag = this.url.indexOf("/", databaseLabelStartIndex + 2);
        int databaseEndTag = this.url.indexOf("?", databaseLabelStartIndex + 2);
        if (databaseEndTag < databaseStartTag && databaseEndTag != -1) {
            return new URLLocation(0, 0);
        }
        if (databaseStartTag == -1) {
            return new URLLocation(0, 0);
        }
        if (databaseEndTag == -1) {
            databaseEndTag = this.url.length();
        } else {
            databaseStartTag = this.url.substring(0, databaseEndTag).lastIndexOf("/");
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    public ConnectionInfo parse() {
        URLLocation location = this.fetchDatabaseHostsIndexRange();
        String hosts = this.url.substring(location.startIndex(), location.endIndex());
        String[] hostSegment = hosts.split(",");
        if (hostSegment.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (String host : hostSegment) {
                if (host.substring(host.indexOf("]") + 1).split(":").length == 1) {
                    sb.append(host).append(":").append(5432).append(",");
                    continue;
                }
                sb.append(host).append(",");
            }
            return new ConnectionInfo(ComponentsDefine.POSTGRESQL_DRIVER, DB_TYPE, sb.substring(0, sb.length() - 1), this.fetchDatabaseNameFromURL());
        }
        String[] hostAndPort = this.getSingleHostAndPort(hostSegment[0]);
        return new ConnectionInfo(ComponentsDefine.POSTGRESQL_DRIVER, DB_TYPE, hostAndPort[0], Integer.valueOf(hostAndPort[1]), this.fetchDatabaseNameFromURL());
    }

    private boolean isIpv6Url(String hosts) {
        return hosts.contains("[") && this.url.contains("]");
    }

    private String[] getSingleHostAndPort(String hostSegment) {
        String additionalHost;
        String host = "";
        String port = "";
        if (!this.isIpv6Url(hostSegment)) {
            String[] hostAndPort = hostSegment.split(":");
            host = hostAndPort[0];
            if (hostAndPort.length != 1) {
                port = hostAndPort[1];
            }
        } else {
            host = hostSegment.substring(0, hostSegment.indexOf("]") + 1);
            String[] ports = hostSegment.substring(hostSegment.indexOf("]") + 1).split(":");
            if (ports.length != 1) {
                port = ports[1];
            }
        }
        if (host.isEmpty() && (additionalHost = this.fetchFromUrlParams(URL_PARAMS_HOST_KEY)) != null) {
            host = additionalHost;
        }
        if (port.isEmpty()) {
            String additionalPort = this.fetchFromUrlParams(URL_PARAMS_PORT_KEY);
            port = additionalPort != null ? additionalPort : String.valueOf(5432);
        }
        return new String[]{host, port};
    }

    private String fetchFromUrlParams(String key) {
        String[] paramArr;
        int databaseAdditionalParamIndex = this.url.indexOf("?");
        if (databaseAdditionalParamIndex == -1) {
            return null;
        }
        for (String pair : paramArr = this.url.substring(databaseAdditionalParamIndex + 1).split("&")) {
            String[] paramsPair;
            if (!pair.contains(key) || (paramsPair = pair.split("=")).length == 1) continue;
            return paramsPair[1];
        }
        return null;
    }
}

