/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.context;

import io.micrometer.context.ContextSnapshot;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ContextExecutorService<EXECUTOR extends ExecutorService>
implements ExecutorService {
    private final EXECUTOR executorService;
    private final Supplier<ContextSnapshot> contextSnapshot;

    protected ContextExecutorService(EXECUTOR executorService, Supplier<ContextSnapshot> contextSnapshot) {
        this.executorService = executorService;
        this.contextSnapshot = contextSnapshot;
    }

    protected EXECUTOR getExecutorService() {
        return this.executorService;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(this.capture().wrap(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executorService.submit(this.capture().wrap(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.executorService.submit(this.capture().wrap(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        List instrumentedTasks = tasks.stream().map(this.capture()::wrap).collect(Collectors.toList());
        return this.executorService.invokeAll(instrumentedTasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        List instrumentedTasks = tasks.stream().map(this.capture()::wrap).collect(Collectors.toList());
        return this.executorService.invokeAll(instrumentedTasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        List instrumentedTasks = tasks.stream().map(this.capture()::wrap).collect(Collectors.toList());
        return this.executorService.invokeAny(instrumentedTasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        List instrumentedTasks = tasks.stream().map(this.capture()::wrap).collect(Collectors.toList());
        return this.executorService.invokeAny(instrumentedTasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.executorService.execute(this.capture().wrap(command));
    }

    @Override
    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executorService.awaitTermination(timeout, unit);
    }

    protected ContextSnapshot capture() {
        return this.contextSnapshot.get();
    }

    public static ExecutorService wrap(ExecutorService service, Supplier<ContextSnapshot> snapshotSupplier) {
        return new ContextExecutorService<ExecutorService>(service, snapshotSupplier);
    }

    public static ExecutorService wrap(ExecutorService service) {
        return new ContextExecutorService<ExecutorService>(service, () -> ContextSnapshot.captureAll(new Object[0]));
    }
}

