/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.meter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MeterId {
    protected final String name;
    protected final MeterType type;
    protected final List<Tag> tags = new ArrayList<Tag>();

    public MeterId(String name, MeterType type) {
        this.name = name;
        this.type = type;
    }

    public MeterId(String name, MeterType type, List<Tag> tags) {
        this.name = name;
        this.type = type;
        this.tags.addAll(tags);
    }

    public String getName() {
        return this.name;
    }

    public MeterType getType() {
        return this.type;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public MeterId copyTo(String name, MeterType type) {
        return new MeterId(name, type, this.tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MeterId meterId = (MeterId)o;
        return Objects.equals(this.name, meterId.name) && this.type == meterId.type && Objects.equals(this.tags, meterId.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.tags});
    }

    public static enum MeterType {
        COUNTER,
        GAUGE,
        HISTOGRAM;

    }

    public static class Tag
    implements Comparable<Tag> {
        private String name;
        private String value;

        public Tag(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            return Objects.equals(this.name, tag.name) && Objects.equals(this.value, tag.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        @Override
        public int compareTo(Tag o) {
            return this.name.compareTo(o.name);
        }
    }
}

