/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.conf.dynamic.watcher;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.conf.dynamic.AgentConfigChangeWatcher;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;

public class SpanLimitWatcher
extends AgentConfigChangeWatcher {
    private static final ILog LOGGER = LogManager.getLogger(SpanLimitWatcher.class);
    private final AtomicInteger spanLimit = new AtomicInteger(this.getDefaultValue());

    public SpanLimitWatcher(String propertyKey) {
        super(propertyKey);
    }

    private void activeSetting(String config) {
        if (LOGGER.isDebugEnable()) {
            LOGGER.debug("Updating using new static config: {}", config);
        }
        try {
            this.spanLimit.set(Integer.parseInt(config));
        }
        catch (NumberFormatException ex) {
            LOGGER.error(ex, "Cannot load {} from: {}", this.getPropertyKey(), config);
        }
    }

    @Override
    public void notify(AgentConfigChangeWatcher.ConfigChangeEvent value) {
        if (AgentConfigChangeWatcher.EventType.DELETE.equals((Object)value.getEventType())) {
            this.activeSetting(String.valueOf(this.getDefaultValue()));
        } else {
            this.activeSetting(value.getNewValue());
        }
    }

    @Override
    public String value() {
        return String.valueOf(this.spanLimit.get());
    }

    private int getDefaultValue() {
        return Config.Agent.SPAN_LIMIT_PER_SEGMENT;
    }

    public int getSpanLimit() {
        return this.spanLimit.get();
    }
}

