/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context;

import java.io.Serializable;
import lombok.Generated;
import org.apache.skywalking.apm.agent.core.base64.Base64;
import org.apache.skywalking.apm.agent.core.conf.Constants;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.CarrierItemHead;
import org.apache.skywalking.apm.agent.core.context.CorrelationContext;
import org.apache.skywalking.apm.agent.core.context.ExtensionContext;
import org.apache.skywalking.apm.agent.core.context.ExtensionInjector;
import org.apache.skywalking.apm.agent.core.context.SW8CarrierItem;
import org.apache.skywalking.apm.agent.core.context.SW8CorrelationCarrierItem;
import org.apache.skywalking.apm.agent.core.context.SW8ExtensionCarrierItem;
import org.apache.skywalking.apm.agent.core.context.TracingContext;
import org.apache.skywalking.apm.util.StringUtil;

public class ContextCarrier
implements Serializable {
    private String traceId;
    private String traceSegmentId;
    private int spanId = -1;
    private String parentService = Constants.EMPTY_STRING;
    private String parentServiceInstance = Constants.EMPTY_STRING;
    private String parentEndpoint;
    private String addressUsedAtClient;
    private ExtensionContext extensionContext = new ExtensionContext();
    private CorrelationContext correlationContext = new CorrelationContext();

    public CarrierItem items() {
        SW8ExtensionCarrierItem sw8ExtensionCarrierItem = new SW8ExtensionCarrierItem(this.extensionContext, null);
        SW8CorrelationCarrierItem sw8CorrelationCarrierItem = new SW8CorrelationCarrierItem(this.correlationContext, sw8ExtensionCarrierItem);
        SW8CarrierItem sw8CarrierItem = new SW8CarrierItem(this, sw8CorrelationCarrierItem);
        return new CarrierItemHead(sw8CarrierItem);
    }

    public ExtensionInjector extensionInjector() {
        return new ExtensionInjector(this.extensionContext);
    }

    void extractExtensionTo(TracingContext tracingContext) {
        tracingContext.getExtensionContext().extract(this);
        this.extensionContext.handle(tracingContext.activeSpan());
    }

    void extractCorrelationTo(TracingContext tracingContext) {
        tracingContext.getCorrelationContext().extract(this);
        this.correlationContext.handle(tracingContext.activeSpan());
    }

    String serialize(HeaderVersion version) {
        if (this.isValid(version)) {
            return StringUtil.join('-', "1", Base64.encode(this.getTraceId()), Base64.encode(this.getTraceSegmentId()), this.getSpanId() + "", Base64.encode(this.getParentService()), Base64.encode(this.getParentServiceInstance()), Base64.encode(this.getParentEndpoint()), Base64.encode(this.getAddressUsedAtClient()));
        }
        return "";
    }

    ContextCarrier deserialize(String text, HeaderVersion version) {
        String[] parts;
        if (text == null) {
            return this;
        }
        if (HeaderVersion.v3.equals((Object)version) && (parts = text.split("-", 8)).length == 8) {
            try {
                this.traceId = Base64.decode2UTFString(parts[1]);
                this.traceSegmentId = Base64.decode2UTFString(parts[2]);
                this.spanId = Integer.parseInt(parts[3]);
                this.parentService = Base64.decode2UTFString(parts[4]);
                this.parentServiceInstance = Base64.decode2UTFString(parts[5]);
                this.parentEndpoint = Base64.decode2UTFString(parts[6]);
                this.addressUsedAtClient = Base64.decode2UTFString(parts[7]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this;
    }

    public boolean isValid() {
        return this.isValid(HeaderVersion.v3);
    }

    boolean isValid(HeaderVersion version) {
        if (HeaderVersion.v3 == version) {
            return StringUtil.isNotEmpty(this.traceId) && StringUtil.isNotEmpty(this.traceSegmentId) && this.getSpanId() > -1 && StringUtil.isNotEmpty(this.parentService) && StringUtil.isNotEmpty(this.parentServiceInstance) && StringUtil.isNotEmpty(this.parentEndpoint) && StringUtil.isNotEmpty(this.addressUsedAtClient);
        }
        return false;
    }

    @Generated
    void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @Generated
    void setTraceSegmentId(String traceSegmentId) {
        this.traceSegmentId = traceSegmentId;
    }

    @Generated
    void setSpanId(int spanId) {
        this.spanId = spanId;
    }

    @Generated
    void setParentService(String parentService) {
        this.parentService = parentService;
    }

    @Generated
    void setParentServiceInstance(String parentServiceInstance) {
        this.parentServiceInstance = parentServiceInstance;
    }

    @Generated
    void setParentEndpoint(String parentEndpoint) {
        this.parentEndpoint = parentEndpoint;
    }

    @Generated
    void setAddressUsedAtClient(String addressUsedAtClient) {
        this.addressUsedAtClient = addressUsedAtClient;
    }

    @Generated
    void setExtensionContext(ExtensionContext extensionContext) {
        this.extensionContext = extensionContext;
    }

    @Generated
    void setCorrelationContext(CorrelationContext correlationContext) {
        this.correlationContext = correlationContext;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public String getTraceSegmentId() {
        return this.traceSegmentId;
    }

    @Generated
    public int getSpanId() {
        return this.spanId;
    }

    @Generated
    public String getParentService() {
        return this.parentService;
    }

    @Generated
    public String getParentServiceInstance() {
        return this.parentServiceInstance;
    }

    @Generated
    public String getParentEndpoint() {
        return this.parentEndpoint;
    }

    @Generated
    public String getAddressUsedAtClient() {
        return this.addressUsedAtClient;
    }

    @Generated
    ExtensionContext getExtensionContext() {
        return this.extensionContext;
    }

    @Generated
    CorrelationContext getCorrelationContext() {
        return this.correlationContext;
    }

    public static enum HeaderVersion {
        v3;

    }
}

