/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.core;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class SetBundleVersionCommand
extends AbstractOperation {
    private IServerWorkingCopy server;
    private final String bundleSymbolicName;
    private final String bundleVersion;
    private String oldBundleVersion;

    public SetBundleVersionCommand(IServerWorkingCopy server, String bundleSymbolicName, String bundleVersion) {
        super("Setting bundle version...");
        this.server = server;
        this.bundleSymbolicName = bundleSymbolicName;
        this.bundleVersion = bundleVersion;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        String propertyName = this.propertyName();
        this.oldBundleVersion = this.server.getAttribute(propertyName, null);
        this.server.setAttribute(propertyName, this.bundleVersion);
        return Status.OK_STATUS;
    }

    private String propertyName() {
        return String.format("launchpad.bundle.%s.version", this.bundleSymbolicName);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.server.setAttribute(this.propertyName(), this.oldBundleVersion);
        return Status.OK_STATUS;
    }
}

