/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.validation.impl;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.factory.InvalidModelException;
import org.apache.sling.models.factory.ValidationException;
import org.apache.sling.models.spi.ModelValidation;
import org.apache.sling.models.validation.InvalidResourceException;
import org.apache.sling.models.validation.impl.ModelValidationConfiguration;
import org.apache.sling.validation.SlingValidationException;
import org.apache.sling.validation.ValidationFailure;
import org.apache.sling.validation.ValidationResult;
import org.apache.sling.validation.ValidationService;
import org.apache.sling.validation.model.ValidationModel;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=ModelValidationConfiguration.class)
public class ModelValidationImpl
implements ModelValidation {
    @Reference
    private ValidationService validation;
    private ModelValidationConfiguration configuration;
    private static final Logger log = LoggerFactory.getLogger(ModelValidationImpl.class);

    @Activate
    protected void activate(ModelValidationConfiguration configuration) {
        this.configuration = configuration;
    }

    public <ModelType> RuntimeException validate(Object adaptable, Class<ModelType> modelClass, boolean required) throws ValidationException, InvalidModelException {
        if (this.configuration.disabled()) {
            log.debug("Skip validation of model {}, because  validation is disabled through the OSGi configuration for ModelValidationConfiguration", modelClass);
            return null;
        }
        Resource resource = null;
        if (adaptable instanceof SlingHttpServletRequest) {
            resource = ((SlingHttpServletRequest)adaptable).getResource();
        } else if (adaptable instanceof Resource) {
            resource = (Resource)adaptable;
        }
        if (resource != null) {
            return this.validate(resource, required);
        }
        return new ValidationException("Sling Validation can only be performed if model is adapted from either SlingHttpServletRequest or Resource.");
    }

    private RuntimeException validate(@NotNull Resource resource, boolean required) {
        block9: {
            try {
                ValidationModel validationModel = this.validation.getValidationModel(resource, true);
                if (validationModel == null) {
                    String error = String.format("Could not find validation model for resource '%s' with type '%s'", resource.getPath(), resource.getResourceType());
                    if (required) {
                        return new ValidationException(error);
                    }
                    log.debug(error);
                    break block9;
                }
                try {
                    ValidationResult validationResult = this.validation.validate(resource, validationModel);
                    if (!validationResult.isValid()) {
                        boolean shouldThrow = false;
                        for (ValidationFailure failure : validationResult.getFailures()) {
                            if (failure.getSeverity() < this.configuration.severityThreshold()) continue;
                            shouldThrow = true;
                            break;
                        }
                        if (shouldThrow) {
                            return new InvalidResourceException("Sling Model is invalid", validationResult, resource.getPath());
                        }
                        log.debug("Although the resource {} is considered invalid by Sling Validation, all validation failures have a severity below the threshold '{}', therefore considering this Sling Model valid.", (Object)resource.getPath(), (Object)this.configuration.severityThreshold());
                    }
                }
                catch (SlingValidationException e) {
                    return new ValidationException((Throwable)e);
                }
            }
            catch (IllegalStateException e) {
                return new ValidationException((Throwable)e);
            }
        }
        return null;
    }
}

