/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.compiler;

import java.util.List;

import org.apache.sling.scripting.sightly.compiler.commands.Command;
import org.apache.sling.scripting.sightly.compiler.commands.CommandStream;
import org.osgi.annotation.versioning.ProviderType;

/**
 * This class encapsulates the result of a compile operation performed by the {@link SightlyCompiler}.
 */
@ProviderType
public interface CompilationResult {

    /**
     * Provides access to the generated {@link CommandStream} for evaluating / replaying the {@link Command}s after the compile operation.
     *
     * @return the command stream generated by the compiler
     */
    CommandStream getCommandStream();

    /**
     * Provides the list of warnings recorded during the compilation.
     *
     * @return the list of warnings; the list can be empty if no warnings have been emitted
     */
    List<CompilerMessage> getWarnings();

    /**
     * Provides the list of errors recorded during the compilation.
     *
     * @return the list of errors; the list can be empty if no errors have been encountered
     */
    List<CompilerMessage> getErrors();

}
