/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 ******************************************************************************/
package org.apache.sling.scripting.sightly.impl.compiler.frontend;

import org.apache.sling.scripting.sightly.compiler.expression.Expression;

/**
 * A segment in an interpolation.
 */
public interface Fragment {

    boolean isString();
    boolean isExpression();

    Expression getExpression();
    String getText();

    /**
     * A fragment which is an expression.
     */
    class Expr implements Fragment {

        private Expression expression;

        public Expr(Expression expression) {
            this.expression = expression;
        }

        @Override
        public Expression getExpression() {
            return expression;
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException("Not a text fragment");
        }

        public boolean isString() {
            return false;
        }

        public boolean isExpression() {
            return true;
        }

        @Override
        public String toString() {
            return "Expr{" +
                    "expression=" + expression +
                    '}';
        }
    }

    /**
     * A text fragment.
     */
    class Text implements Fragment {
        private String text;

        public Text(String text) {
            this.text = text;
        }

        @Override
        public String getText() {
            return text;
        }

        public boolean isString() {
            return true;
        }

        public boolean isExpression() {
            return false;
        }

        @Override
        public Expression getExpression() {
            throw new UnsupportedOperationException("Not an expression fragment");
        }

        @Override
        public String toString() {
            return "Text{" +
                    "text='" + text + '\'' +
                    '}';
        }
    }
}
