/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl.rhino;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncContainer;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncExtractor;
import org.apache.sling.scripting.sightly.js.impl.rhino.HybridObject;
import org.apache.sling.scripting.sightly.js.impl.rhino.JsUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class JsValueAdapter {
    private static final Map<String, Class<?>> knownConversions = new HashMap();
    private final AsyncExtractor asyncExtractor;

    public JsValueAdapter(AsyncExtractor asyncExtractor) {
        this.asyncExtractor = asyncExtractor;
    }

    public Object adapt(Object jsValue) {
        if (jsValue == null || jsValue == Context.getUndefinedValue() || jsValue == ScriptableObject.NOT_FOUND) {
            return null;
        }
        if (jsValue instanceof Wrapper) {
            return this.adapt(((Wrapper)jsValue).unwrap());
        }
        if (this.asyncExtractor.isPromise(jsValue)) {
            return this.adapt(this.forceAsync(jsValue));
        }
        if (jsValue instanceof ScriptableObject) {
            return this.extractScriptable((ScriptableObject)jsValue);
        }
        if (jsValue instanceof CharSequence) {
            return jsValue.toString();
        }
        if (jsValue instanceof Map) {
            return this.convertMap((Map)jsValue);
        }
        if (jsValue instanceof Iterable) {
            return this.convertIterable((Iterable)jsValue);
        }
        if (jsValue instanceof Number) {
            return this.convertNumber((Number)jsValue);
        }
        if (jsValue instanceof Object[]) {
            return this.convertIterable(Arrays.asList((Object[])jsValue));
        }
        return jsValue;
    }

    private Object convertNumber(Number numValue) {
        if (numValue instanceof Double && this.isLong((Double)numValue)) {
            return numValue.longValue();
        }
        if (numValue instanceof Float && this.isLong(((Float)numValue).floatValue())) {
            return numValue.longValue();
        }
        return numValue;
    }

    private boolean isLong(double x) {
        return x == Math.floor(x);
    }

    private Object forceAsync(Object jsValue) {
        AsyncContainer asyncContainer = new AsyncContainer();
        this.asyncExtractor.extract(jsValue, asyncContainer.createCompletionCallback());
        return asyncContainer.getResult();
    }

    private Object extractScriptable(ScriptableObject scriptableObject) {
        Object obj = JsValueAdapter.tryKnownConversion(scriptableObject);
        if (obj != null) {
            return obj;
        }
        if (scriptableObject instanceof NativeArray) {
            return this.convertNativeArray((NativeArray)scriptableObject);
        }
        if (scriptableObject instanceof Function) {
            return this.callFunction((Function)scriptableObject);
        }
        return new HybridObject((Scriptable)scriptableObject, this);
    }

    private Object callFunction(Function function) {
        Object result = JsUtils.callFn(function, null, (Scriptable)function, (Scriptable)function, new Object[0]);
        return this.adapt(result);
    }

    private Object[] convertNativeArray(NativeArray nativeArray) {
        int length = (int)nativeArray.getLength();
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object jsItem = nativeArray.get(i, (Scriptable)nativeArray);
            objects[i] = this.adapt(jsItem);
        }
        return objects;
    }

    private Map<Object, Object> convertMap(Map<Object, Object> original) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : original.entrySet()) {
            map.put(entry.getKey(), this.adapt(entry.getValue()));
        }
        return map;
    }

    private List<Object> convertIterable(Iterable<Object> iterable) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object obj : iterable) {
            objects.add(this.adapt(obj));
        }
        return objects;
    }

    private static Object tryKnownConversion(ScriptableObject object) {
        String className = object.getClassName();
        Class<?> cls = knownConversions.get(className);
        return cls == null ? null : Context.jsToJava((Object)object, cls);
    }

    static {
        knownConversions.put("String", String.class);
        knownConversions.put("Date", Date.class);
    }
}

