/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.counter;

import java.util.Random;
import java.util.UUID;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class ApproximateCounter {
    public static final String COUNT_PROPERTY_PREFIX = ":count_";
    public static final int COUNT_RESOLUTION = 100;
    public static final int COUNT_MAX = 10000000;
    private static final Random RANDOM = new Random();

    private ApproximateCounter() {
    }

    public static long calculateOffset(long offset, int resolution) {
        if (offset == 0L || resolution <= 1) {
            return offset;
        }
        int add = resolution;
        if (offset < 0L) {
            offset = -offset;
            add = -add;
        }
        long result = 0L;
        for (long i = 0L; i < offset; ++i) {
            if (RANDOM.nextInt(resolution) != 0) continue;
            result += (long)add;
        }
        return result;
    }

    public static long adjustOffset(long oldCount, long calculatedOffset, int resolution) {
        if (oldCount + calculatedOffset < 0L) {
            return -oldCount;
        }
        if (resolution <= 10 || oldCount < (long)(resolution * 10)) {
            return calculatedOffset;
        }
        return RANDOM.nextInt(10) == 0 ? calculatedOffset * 10L : 0L;
    }

    static void setSeed(int seed) {
        RANDOM.setSeed(seed);
    }

    public static void adjustCountSync(NodeBuilder builder, long offset) {
        if (offset == 0L) {
            return;
        }
        boolean added = offset > 0L;
        for (long i = 0L; i < Math.abs(offset); ++i) {
            ApproximateCounter.adjustCountSync(builder, added);
        }
    }

    private static void adjustCountSync(NodeBuilder builder, boolean added) {
        if (RANDOM.nextInt(100) != 0) {
            return;
        }
        int max = ApproximateCounter.getMaxCount(builder, added);
        if (max >= 10000000) {
            return;
        }
        int x = Math.max(100, max * 2) / 100;
        if (RANDOM.nextInt(x) > 0) {
            return;
        }
        long value = x * 100;
        String propertyName = COUNT_PROPERTY_PREFIX + UUID.randomUUID();
        builder.setProperty(propertyName, added ? value : -value);
    }

    private static int getMaxCount(NodeBuilder node, boolean added) {
        long max = 0L;
        for (PropertyState propertyState : node.getProperties()) {
            long x;
            if (!propertyState.getName().startsWith(COUNT_PROPERTY_PREFIX) || added != (x = propertyState.getValue(Type.LONG).longValue()) > 0L) continue;
            max = Math.max(max, Math.abs(x));
        }
        max = Math.min(Integer.MAX_VALUE, max);
        return (int)max;
    }

    public static long getCountSync(NodeState node) {
        boolean hasCountProperty = false;
        long added = 0L;
        long removed = 0L;
        for (PropertyState propertyState : node.getProperties()) {
            if (!propertyState.getName().startsWith(COUNT_PROPERTY_PREFIX)) continue;
            hasCountProperty = true;
            long x = propertyState.getValue(Type.LONG);
            if (x > 0L) {
                added += x;
                continue;
            }
            removed -= x;
        }
        if (!hasCountProperty) {
            return -1L;
        }
        return Math.max(added / 2L, added - removed);
    }
}

