/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.ValidationEntry;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.JcrAllUtil;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Strings;
import sling-mock-oak.com.google.common.collect.Iterables;
import sling-mock-oak.com.google.common.collect.Maps;
import sling-mock-oak.com.google.common.collect.Sets;

final class PermissionStoreEditor
implements AccessControlConstants,
PermissionConstants {
    private static final Logger log = LoggerFactory.getLogger(PermissionStoreEditor.class);
    private final String accessControlledPath;
    private final String nodeName;
    private final Map<String, List<AcEntry>> entries = Maps.newHashMap();
    private final NodeBuilder permissionRoot;
    private final PrivilegeBitsProvider bitsProvider;

    PermissionStoreEditor(@NotNull String aclPath, @NotNull String name, @NotNull NodeState node, @NotNull NodeBuilder permissionRoot, @NotNull TypePredicate isACE, @NotNull TypePredicate isGrantACE, @NotNull PrivilegeBitsProvider bitsProvider, @NotNull RestrictionProvider restrictionProvider, @NotNull TreeProvider treeProvider) {
        this.permissionRoot = permissionRoot;
        this.bitsProvider = bitsProvider;
        this.accessControlledPath = name.equals("rep:repoPolicy") ? "" : (aclPath.isEmpty() ? "/" : aclPath);
        this.nodeName = PermissionUtil.getEntryName(this.accessControlledPath);
        LinkedHashSet<String> orderedChildNames = Sets.newLinkedHashSet(node.getNames(":childOrder"));
        long n = orderedChildNames.size();
        if (node.getChildNodeCount(n + 1L) > n) {
            Iterables.addAll(orderedChildNames, node.getChildNodeNames());
        }
        int index = 0;
        for (String childName : orderedChildNames) {
            NodeState ace = node.getChildNode(childName);
            if (!isACE.test(ace)) continue;
            boolean isAllow = isGrantACE.test(ace);
            PrivilegeBits privilegeBits = bitsProvider.getBits(ace.getNames("rep:privileges"));
            Set<Restriction> restrictions = restrictionProvider.readRestrictions(Strings.emptyToNull(this.accessControlledPath), treeProvider.createReadOnlyTree(ace));
            String principalName = Text.escapeIllegalJcrChars(ace.getString("rep:principalName"));
            AcEntry entry = new AcEntry(principalName, index, isAllow, privilegeBits, restrictions);
            List list = this.entries.computeIfAbsent(principalName, k -> new ArrayList());
            list.add(entry);
            ++index;
        }
    }

    @NotNull
    String getPath() {
        return this.accessControlledPath;
    }

    boolean isEmpty() {
        return this.entries.isEmpty();
    }

    void removePermissionEntries(@NotNull PermissionStoreEditor otherEditor) {
        this.entries.keySet().removeAll(otherEditor.entries.keySet());
    }

    void removePermissionEntries() {
        for (String principalName : this.entries.keySet()) {
            if (this.permissionRoot.hasChildNode(principalName)) {
                NodeBuilder principalRoot = this.permissionRoot.getChildNode(principalName);
                boolean removed = false;
                NodeBuilder parent = principalRoot.getChildNode(this.nodeName);
                if (!parent.exists()) continue;
                if (PermissionUtil.checkACLPath(parent, this.accessControlledPath)) {
                    NodeBuilder newParent = null;
                    for (String childName : parent.getChildNodeNames()) {
                        if (childName.charAt(0) != 'c') continue;
                        NodeBuilder child = parent.getChildNode(childName);
                        if (newParent == null) {
                            newParent = child;
                            continue;
                        }
                        newParent.setChildNode(childName, child.getNodeState());
                    }
                    if (newParent != null) {
                        principalRoot.setChildNode(this.nodeName, newParent.getNodeState());
                        removed = true;
                    } else {
                        removed = parent.remove();
                    }
                } else {
                    for (String childName : parent.getChildNodeNames()) {
                        NodeBuilder child;
                        if (childName.charAt(0) != 'c' || !PermissionUtil.checkACLPath(child = parent.getChildNode(childName), this.accessControlledPath)) continue;
                        removed = child.remove();
                    }
                }
                if (!removed) continue;
                PermissionStoreEditor.updateNumEntries(principalName, principalRoot, -1);
                continue;
            }
            log.error("Unable to remove permission entry {}: Principal root missing.", (Object)this);
        }
    }

    void updatePermissionEntries() {
        for (Map.Entry<String, List<AcEntry>> entry : this.entries.entrySet()) {
            NodeBuilder parent;
            String principalName = entry.getKey();
            NodeBuilder principalRoot = this.permissionRoot.child(principalName);
            if (!principalRoot.hasProperty("jcr:primaryType")) {
                principalRoot.setProperty("jcr:primaryType", "rep:PermissionStore", Type.NAME);
            }
            if (!(parent = principalRoot.child(this.nodeName)).hasProperty("jcr:primaryType")) {
                parent.setProperty("jcr:primaryType", "rep:PermissionStore", Type.NAME);
            }
            if (parent.hasProperty("rep:accessControlledPath")) {
                if (!PermissionUtil.checkACLPath(parent, this.accessControlledPath)) {
                    NodeBuilder child = null;
                    int idx = 0;
                    for (String childName : parent.getChildNodeNames()) {
                        if (childName.charAt(0) != 'c') continue;
                        child = parent.getChildNode(childName);
                        if (PermissionUtil.checkACLPath(child, this.accessControlledPath)) break;
                        child = null;
                        ++idx;
                    }
                    while (child == null) {
                        String name = 'c' + String.valueOf(idx++);
                        child = parent.getChildNode(name);
                        if (child.exists()) {
                            child = null;
                            continue;
                        }
                        child = parent.child(name);
                        child.setProperty("jcr:primaryType", "rep:PermissionStore", Type.NAME);
                    }
                    parent = child;
                    parent.setProperty("rep:accessControlledPath", this.accessControlledPath);
                }
            } else {
                parent.setProperty("rep:accessControlledPath", this.accessControlledPath);
            }
            this.updateEntries(parent, entry.getValue());
            if (!parent.isNew()) continue;
            PermissionStoreEditor.updateNumEntries(principalName, principalRoot, 1);
        }
    }

    private void updateEntries(@NotNull NodeBuilder parent, @NotNull List<AcEntry> list) {
        for (String childName : parent.getChildNodeNames()) {
            if (childName.charAt(0) == 'c') continue;
            parent.getChildNode(childName).remove();
        }
        for (AcEntry ace : list) {
            ace.writeToPermissionStore(parent);
        }
    }

    private static void updateNumEntries(@NotNull String principalName, @NotNull NodeBuilder principalRoot, int cnt) {
        PropertyState ps = principalRoot.getProperty("rep:numPermissions");
        if (ps == null && !principalRoot.isNew()) {
            return;
        }
        long numEntries = (ps == null ? 0L : ps.getValue(Type.LONG)) + (long)cnt;
        if (numEntries < 0L) {
            log.error("NumEntries counter for principal '{}' turned negative -> removing 'rep:numPermissions' property.", (Object)principalName);
            principalRoot.removeProperty("rep:numPermissions");
        } else {
            principalRoot.setProperty("rep:numPermissions", numEntries, Type.LONG);
        }
    }

    private class AcEntry
    extends ValidationEntry {
        AcEntry(String principalName, int index, @NotNull boolean isAllow, @NotNull PrivilegeBits privilegeBits, Set<Restriction> restrictions) {
            super(principalName, privilegeBits, isAllow, restrictions, index);
        }

        private void writeToPermissionStore(@NotNull NodeBuilder parent) {
            NodeBuilder n = parent.child(String.valueOf(this.index)).setProperty("jcr:primaryType", "rep:Permissions", Type.NAME).setProperty("rep:isAllow", this.isAllow).setProperty(this.getPrivilegeBitsProperty());
            for (Restriction restriction : this.restrictions) {
                n.setProperty(restriction.getProperty());
            }
        }

        @NotNull
        private PropertyState getPrivilegeBitsProperty() {
            return JcrAllUtil.asPropertyState("rep:privileges", this.privilegeBits, PermissionStoreEditor.this.bitsProvider);
        }
    }
}

