/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scriptingbundle.plugin.processor;

import org.apache.sling.scriptingbundle.plugin.processor.Constants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Script {
    private final String name;
    private final String requestExtension;
    private final String requestMethod;
    private final String scriptExtension;

    private Script(@Nullable String name, @Nullable String requestExtension, @Nullable String requestMethod, @NotNull String scriptExtension) {
        this.name = name;
        this.requestExtension = requestExtension;
        this.requestMethod = requestMethod;
        this.scriptExtension = scriptExtension;
    }

    @Nullable
    String getName() {
        return this.name;
    }

    @Nullable
    String getRequestExtension() {
        return this.requestExtension;
    }

    @Nullable
    String getRequestMethod() {
        return this.requestMethod;
    }

    @NotNull
    String getScriptExtension() {
        return this.scriptExtension;
    }

    @Nullable
    static Script parseScript(@NotNull String fileName) {
        String[] parts = fileName.split("\\.");
        if (parts.length < 2 || parts.length > 4) {
            return null;
        }
        String name = parts[0];
        String scriptExtension = parts[parts.length - 1];
        String requestExtension = null;
        String requestMethod = null;
        if (parts.length == 2) {
            if (Constants.METHODS.contains(name)) {
                requestMethod = name;
                name = null;
            } else if (name.equalsIgnoreCase("html")) {
                requestExtension = name;
                name = null;
            }
        }
        if (parts.length == 3) {
            String middle = parts[1];
            if (Constants.METHODS.contains(middle)) {
                requestMethod = middle;
            } else {
                requestExtension = middle;
            }
        }
        if (parts.length == 4) {
            requestExtension = parts[1];
            requestMethod = parts[2];
        }
        return new Script(name, requestExtension, requestMethod, scriptExtension);
    }
}

