/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring.namespace;

import java.lang.reflect.Method;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.StringUtils;

public abstract class NamespaceParserHelper {
    protected String resolveBeanClassname(BeanDefinition definition, BeanDefinitionRegistry registry) {
        String beanClassName = definition.getBeanClassName();
        while (!StringUtils.hasText((String)beanClassName)) {
            try {
                Method m = definition.getClass().getMethod("getParentName", new Class[0]);
                String parentName = (String)m.invoke((Object)definition, new Object[0]);
                BeanDefinition parentDefinition = this.findParentDefinition(parentName, registry);
                beanClassName = parentDefinition.getBeanClassName();
                definition = parentDefinition;
            }
            catch (Exception e) {
                throw new FatalBeanException("No parent bean could be found for " + definition, (Throwable)e);
            }
        }
        return beanClassName;
    }

    protected BeanDefinition findParentDefinition(String parentName, BeanDefinitionRegistry registry) {
        if (registry != null) {
            if (registry.containsBeanDefinition(parentName)) {
                return registry.getBeanDefinition(parentName);
            }
            if (registry instanceof HierarchicalBeanFactory) {
                BeanFactory parentBeanFactory = ((HierarchicalBeanFactory)registry).getParentBeanFactory();
                return this.findParentDefinition(parentName, (BeanDefinitionRegistry)parentBeanFactory);
            }
        }
        return null;
    }
}

