/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.executor;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.executor.ExecutorMetrics$;
import org.apache.spark.executor.ExecutorMetricsPoller$TCMP$;
import org.apache.spark.executor.ExecutorMetricsSource;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.metrics.ExecutorMetricType$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tEa!\u0002\u0016,\u00015\u001a\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011!\u0003!\u0011!Q\u0001\n%C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u0006)\u0002!\t!V\u0003\u00055\u0002\u00011LB\u0003b\u0001\u0001[#\r\u0003\u0005j\r\tU\r\u0011\"\u0001k\u0011!9hA!E!\u0002\u0013Y\u0007\u0002\u0003=\u0007\u0005+\u0007I\u0011A=\t\u0011u4!\u0011#Q\u0001\niDQ\u0001\u0016\u0004\u0005\u0002yD\u0011\"a\u0002\u0007\u0003\u0003%\t!!\u0003\t\u0013\u0005=a!%A\u0005\u0002\u0005E\u0001\"CA\u0014\rE\u0005I\u0011AA\u0015\u0011%\tiCBA\u0001\n\u0003\ny\u0003C\u0005\u0002>\u0019\t\t\u0011\"\u0001\u0002@!I\u0011\u0011\t\u0004\u0002\u0002\u0013\u0005\u00111\t\u0005\n\u0003\u001f2\u0011\u0011!C!\u0003#B\u0011\"a\u0018\u0007\u0003\u0003%\t!!\u0019\t\u0013\u0005-d!!A\u0005B\u00055\u0004\"CA8\r\u0005\u0005I\u0011IA9\u0011%\t\u0019HBA\u0001\n\u0003\n)h\u0002\u0006\u0002z\u0001\t\t\u0011#\u0001,\u0003w2\u0011\"\u0019\u0001\u0002\u0002#\u00051&! \t\rQCB\u0011AAF\u0011%\ty\u0007GA\u0001\n\u000b\n\t\bC\u0005\u0002\u000eb\t\t\u0011\"!\u0002\u0010\"I\u0011Q\u0013\r\u0002\u0002\u0013\u0005\u0015q\u0013\u0005\u000b\u0003C\u0003!\u0019!C\u0001W\u0005\r\u0006\u0002CAX\u0001\u0001\u0006I!!*\t\u0013\u0005E\u0006A1A\u0005\n\u0005M\u0006\u0002CA\\\u0001\u0001\u0006I!!.\t\u0013\u0005e\u0006A1A\u0005\n\u0005m\u0006\u0002CAc\u0001\u0001\u0006I!!0\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002J\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005%\u0007bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u0003G\u0004A\u0011AAs\u0011\u001d\ti\u000f\u0001C\u0001\u0003_Dq!!?\u0001\t\u0003\tY\u0010C\u0004\u0003\u0010\u0001!\t!!3\u0003+\u0015CXmY;u_JlU\r\u001e:jGN\u0004v\u000e\u001c7fe*\u0011A&L\u0001\tKb,7-\u001e;pe*\u0011afL\u0001\u0006gB\f'o\u001b\u0006\u0003aE\na!\u00199bG\",'\"\u0001\u001a\u0002\u0007=\u0014xmE\u0002\u0001ii\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a!\u00118z%\u00164\u0007CA\u001e?\u001b\u0005a$BA\u001f.\u0003!Ig\u000e^3s]\u0006d\u0017BA =\u0005\u001daunZ4j]\u001e\fQ\"\\3n_JLX*\u00198bO\u0016\u00148\u0001\u0001\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b6\na!\\3n_JL\u0018BA$E\u00055iU-\\8ss6\u000bg.Y4fe\u0006y\u0001o\u001c7mS:<\u0017J\u001c;feZ\fG\u000e\u0005\u00026\u0015&\u00111J\u000e\u0002\u0005\u0019>tw-A\u000bfq\u0016\u001cW\u000f^8s\u001b\u0016$(/[2t'>,(oY3\u0011\u0007Ur\u0005+\u0003\u0002Pm\t1q\n\u001d;j_:\u0004\"!\u0015*\u000e\u0003-J!aU\u0016\u0003+\u0015CXmY;u_JlU\r\u001e:jGN\u001cv.\u001e:dK\u00061A(\u001b8jiz\"BAV,Y3B\u0011\u0011\u000b\u0001\u0005\u0006\u0001\u0012\u0001\rA\u0011\u0005\u0006\u0011\u0012\u0001\r!\u0013\u0005\u0006\u0019\u0012\u0001\r!\u0014\u0002\t'R\fw-Z&fsB!Q\u0007\u00180_\u0013\tifG\u0001\u0004UkBdWM\r\t\u0003k}K!\u0001\u0019\u001c\u0003\u0007%sGO\u0001\u0003U\u00076\u00036\u0003\u0002\u00045G\u001a\u0004\"!\u000e3\n\u0005\u00154$a\u0002)s_\u0012,8\r\u001e\t\u0003k\u001dL!\u0001\u001b\u001c\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000b\r|WO\u001c;\u0016\u0003-\u0004\"\u0001\\;\u000e\u00035T!A\\8\u0002\r\u0005$x.\\5d\u0015\t\u0001\u0018/\u0001\u0006d_:\u001cWO\u001d:f]RT!A]:\u0002\tU$\u0018\u000e\u001c\u0006\u0002i\u0006!!.\u0019<b\u0013\t1XN\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\faaY8v]R\u0004\u0013!\u00029fC.\u001cX#\u0001>\u0011\u00051\\\u0018B\u0001?n\u0005=\tEo\\7jG2{gnZ!se\u0006L\u0018A\u00029fC.\u001c\b\u0005F\u0003\u0000\u0003\u0007\t)\u0001E\u0002\u0002\u0002\u0019i\u0011\u0001\u0001\u0005\u0006S.\u0001\ra\u001b\u0005\u0006q.\u0001\rA_\u0001\u0005G>\u0004\u0018\u0010F\u0003\u0000\u0003\u0017\ti\u0001C\u0004j\u0019A\u0005\t\u0019A6\t\u000fad\u0001\u0013!a\u0001u\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\nU\rY\u0017QC\u0016\u0003\u0003/\u0001B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0005\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002&\u0005m!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u0016U\rQ\u0018QC\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]2/\u0001\u0003mC:<\u0017\u0002BA\u001e\u0003k\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#\u00010\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QIA&!\r)\u0014qI\u0005\u0004\u0003\u00132$aA!os\"A\u0011QJ\t\u0002\u0002\u0003\u0007a,A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003'\u0002b!!\u0016\u0002\\\u0005\u0015SBAA,\u0015\r\tIFN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA/\u0003/\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111MA5!\r)\u0014QM\u0005\u0004\u0003O2$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u001b\u001a\u0012\u0011!a\u0001\u0003\u000b\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002=\u0006AAo\\*ue&tw\r\u0006\u0002\u00022\u00051Q-];bYN$B!a\u0019\u0002x!I\u0011Q\n\f\u0002\u0002\u0003\u0007\u0011QI\u0001\u0005)\u000ek\u0005\u000bE\u0002\u0002\u0002a\u0019B\u0001GA@MB9\u0011\u0011QADWj|XBAAB\u0015\r\t)IN\u0001\beVtG/[7f\u0013\u0011\tI)a!\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002|\u0005)\u0011\r\u001d9msR)q0!%\u0002\u0014\")\u0011n\u0007a\u0001W\")\u0001p\u0007a\u0001u\u00069QO\\1qa2LH\u0003BAM\u0003;\u0003B!\u000e(\u0002\u001cB!Q\u0007X6{\u0011!\ty\nHA\u0001\u0002\u0004y\u0018a\u0001=%a\u0005I1\u000f^1hKR\u001bU\nU\u000b\u0003\u0003K\u0003r!a*\u0002*\u00065v0D\u0001p\u0013\r\tYk\u001c\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bcAA\u0001\u000b\u0005Q1\u000f^1hKR\u001bU\n\u0015\u0011\u0002\u001fQ\f7o['fiJL7\rU3bWN,\"!!.\u0011\r\u0005\u001d\u0016\u0011V%{\u0003A!\u0018m]6NKR\u0014\u0018n\u0019)fC.\u001c\b%\u0001\u0004q_2dWM]\u000b\u0003\u0003{\u0003B!\u000e(\u0002@B!\u0011qUAa\u0013\r\t\u0019m\u001c\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017a\u00029pY2,'\u000fI\u0001\u0005a>dG\u000e\u0006\u0002\u0002LB\u0019Q'!4\n\u0007\u0005=gG\u0001\u0003V]&$\u0018!B:uCJ$\u0018aC8o)\u0006\u001c8n\u0015;beR$\u0002\"a3\u0002X\u0006m\u0017q\u001c\u0005\u0007\u00033,\u0003\u0019A%\u0002\rQ\f7o[%e\u0011\u0019\ti.\na\u0001=\u000691\u000f^1hK&#\u0007BBAqK\u0001\u0007a,\u0001\bti\u0006<W-\u0011;uK6\u0004H/\u00133\u0002!=tG+Y:l\u0007>l\u0007\u000f\\3uS>tG\u0003CAf\u0003O\fI/a;\t\r\u0005eg\u00051\u0001J\u0011\u0019\tiN\na\u0001=\"1\u0011\u0011\u001d\u0014A\u0002y\u000b!cZ3u)\u0006\u001c8.T3ue&\u001c\u0007+Z1lgR!\u0011\u0011_A|!\u0011)\u00141_%\n\u0007\u0005UhGA\u0003BeJ\f\u0017\u0010\u0003\u0004\u0002Z\u001e\u0002\r!S\u0001\u0013O\u0016$X\t_3dkR|'/\u00169eCR,7\u000f\u0006\u0002\u0002~BA\u0011q B\u0003\u0003[\u0013I!\u0004\u0002\u0003\u0002)!!1AA,\u0003\u001diW\u000f^1cY\u0016LAAa\u0002\u0003\u0002\t9\u0001*Y:i\u001b\u0006\u0004\bcA)\u0003\f%\u0019!QB\u0016\u0003\u001f\u0015CXmY;u_JlU\r\u001e:jGN\fAa\u001d;pa\u0002")
public class ExecutorMetricsPoller
implements Logging {
    private volatile ExecutorMetricsPoller$TCMP$ TCMP$module;
    private final MemoryManager memoryManager;
    private final long pollingInterval;
    private final Option<ExecutorMetricsSource> executorMetricsSource;
    private final ConcurrentHashMap<Tuple2<Object, Object>, TCMP> stageTCMP;
    private final ConcurrentHashMap<Object, AtomicLongArray> taskMetricPeaks;
    private final Option<ScheduledExecutorService> poller;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    public ExecutorMetricsPoller$TCMP$ TCMP() {
        if (this.TCMP$module == null) {
            this.TCMP$lzycompute$1();
        }
        return this.TCMP$module;
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ConcurrentHashMap<Tuple2<Object, Object>, TCMP> stageTCMP() {
        return this.stageTCMP;
    }

    private ConcurrentHashMap<Object, AtomicLongArray> taskMetricPeaks() {
        return this.taskMetricPeaks;
    }

    private Option<ScheduledExecutorService> poller() {
        return this.poller;
    }

    public void poll() {
        long[] latestMetrics = ExecutorMetrics$.MODULE$.getCurrentMetrics(this.memoryManager);
        this.executorMetricsSource.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.updateMetricsSnapshot(latestMetrics);
            return BoxedUnit.UNIT;
        });
        this.stageTCMP().forEachValue(Long.MAX_VALUE, v -> ExecutorMetricsPoller.updatePeaks$1(v.peaks(), latestMetrics));
        this.taskMetricPeaks().forEachValue(Long.MAX_VALUE, metrics -> ExecutorMetricsPoller.updatePeaks$1(metrics, latestMetrics));
    }

    public void start() {
        this.poller().foreach((Function1 & Serializable & scala.Serializable)exec -> {
            Runnable pollingTask = () -> Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.poll());
            return exec.scheduleAtFixedRate(pollingTask, 0L, $this.pollingInterval, TimeUnit.MILLISECONDS);
        });
    }

    public void onTaskStart(long taskId, int stageId, int stageAttemptId) {
        this.taskMetricPeaks().put(BoxesRunTime.boxToLong((long)taskId), new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics()));
        TCMP countAndPeaks = this.stageTCMP().computeIfAbsent((Tuple2<Object, Object>)new Tuple2.mcII.sp(stageId, stageAttemptId), x$2 -> new TCMP(this, new AtomicLong(0L), new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics())));
        long stageCount = countAndPeaks.count().incrementAndGet();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("stageTCMP: (").append(stageId).append(", ").append(stageAttemptId).append(") -> ").append(stageCount).toString());
    }

    public void onTaskCompletion(long taskId, int stageId, int stageAttemptId) {
        this.stageTCMP().computeIfPresent((Tuple2<Object, Object>)new Tuple2.mcII.sp(stageId, stageAttemptId), (stage, countAndPeaks) -> this.decrementCount$1((Tuple2)stage, (TCMP)countAndPeaks));
        this.taskMetricPeaks().remove(BoxesRunTime.boxToLong((long)taskId));
    }

    public long[] getTaskMetricPeaks(long taskId) {
        long[] metricPeaks;
        block0: {
            AtomicLongArray currentPeaks = this.taskMetricPeaks().get(BoxesRunTime.boxToLong((long)taskId));
            metricPeaks = new long[ExecutorMetricType$.MODULE$.numMetrics()];
            if (currentPeaks == null) break block0;
            ExecutorMetricType$.MODULE$.metricToOffset().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ExecutorMetricsPoller.$anonfun$getTaskMetricPeaks$1(metricPeaks, currentPeaks, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return metricPeaks;
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<Tuple2<Object, Object>, ExecutorMetrics> getExecutorUpdates() {
        void var1_1;
        HashMap executorUpdates = new HashMap();
        this.stageTCMP().replaceAll((k, v) -> this.getUpdateAndResetPeaks$1((Tuple2)k, (TCMP)v, executorUpdates));
        executorUpdates.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 k2 = (Tuple2)tuple2._1();
            TCMP tCMP = this.stageTCMP().computeIfPresent((Tuple2<Object, Object>)k2, (k, v) -> this.removeIfInactive$1((Tuple2)k, (TCMP)v));
            return tCMP;
        });
        return var1_1;
    }

    public void stop() {
        this.poller().foreach((Function1 & Serializable & scala.Serializable)exec -> BoxesRunTime.boxToBoolean((boolean)ExecutorMetricsPoller.$anonfun$stop$1(exec)));
    }

    private final void TCMP$lzycompute$1() {
        ExecutorMetricsPoller executorMetricsPoller = this;
        synchronized (executorMetricsPoller) {
            if (this.TCMP$module == null) {
                this.TCMP$module = new ExecutorMetricsPoller$TCMP$(this);
            }
        }
    }

    private static final void updatePeaks$1(AtomicLongArray metrics, long[] latestMetrics$1) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), metrics.length()).foreach((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)i -> metrics.getAndAccumulate(i, latestMetrics$1[i], (x, y) -> package$.MODULE$.max(x, y)));
    }

    private final TCMP decrementCount$1(Tuple2 stage, TCMP countAndPeaks) {
        long countValue = countAndPeaks.count().decrementAndGet();
        Predef$.MODULE$.assert(countValue >= 0L, (Function0 & Serializable & scala.Serializable)() -> "task count shouldn't below 0");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("stageTCMP: (").append(stage._1$mcI$sp()).append(", ").append(stage._2$mcI$sp()).append(") -> ").append(countValue).toString());
        return countAndPeaks;
    }

    public static final /* synthetic */ void $anonfun$getTaskMetricPeaks$1(long[] metricPeaks$1, AtomicLongArray currentPeaks$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int i = tuple2._2$mcI$sp();
        metricPeaks$1[i] = currentPeaks$1.get(i);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final TCMP getUpdateAndResetPeaks$1(Tuple2 k, TCMP v, HashMap executorUpdates$1) {
        executorUpdates$1.put((Object)k, (Object)new ExecutorMetrics(v.peaks()));
        return new TCMP(this, v.count(), new AtomicLongArray(ExecutorMetricType$.MODULE$.numMetrics()));
    }

    private final TCMP removeIfInactive$1(Tuple2 k, TCMP v) {
        TCMP tCMP;
        if (v.count().get() == 0L) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("removing (").append(k._1$mcI$sp()).append(", ").append(k._2$mcI$sp()).append(") from stageTCMP").toString());
            tCMP = null;
        } else {
            tCMP = v;
        }
        return tCMP;
    }

    public static final /* synthetic */ boolean $anonfun$stop$1(ScheduledExecutorService exec) {
        exec.shutdown();
        return exec.awaitTermination(10L, TimeUnit.SECONDS);
    }

    public ExecutorMetricsPoller(MemoryManager memoryManager, long pollingInterval, Option<ExecutorMetricsSource> executorMetricsSource) {
        this.memoryManager = memoryManager;
        this.pollingInterval = pollingInterval;
        this.executorMetricsSource = executorMetricsSource;
        Logging.$init$(this);
        this.stageTCMP = new ConcurrentHashMap();
        this.taskMetricPeaks = new ConcurrentHashMap();
        this.poller = pollingInterval > 0L ? new Some((Object)ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("executor-metrics-poller")) : None$.MODULE$;
    }

    public class TCMP
    implements Product,
    scala.Serializable {
        private final AtomicLong count;
        private final AtomicLongArray peaks;
        public final /* synthetic */ ExecutorMetricsPoller $outer;

        public AtomicLong count() {
            return this.count;
        }

        public AtomicLongArray peaks() {
            return this.peaks;
        }

        public TCMP copy(AtomicLong count, AtomicLongArray peaks) {
            return new TCMP(this.org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer(), count, peaks);
        }

        public AtomicLong copy$default$1() {
            return this.count();
        }

        public AtomicLongArray copy$default$2() {
            return this.peaks();
        }

        public String productPrefix() {
            return "TCMP";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Serializable serializable;
            int n = x$1;
            switch (n) {
                case 0: {
                    serializable = this.count();
                    break;
                }
                case 1: {
                    serializable = this.peaks();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return serializable;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TCMP;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TCMP)) return false;
            if (((TCMP)object).org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer() != this.org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TCMP tCMP = (TCMP)x$1;
            if (!BoxesRunTime.equalsNumNum((Number)this.count(), (Number)tCMP.count())) return false;
            AtomicLongArray atomicLongArray = this.peaks();
            AtomicLongArray atomicLongArray2 = tCMP.peaks();
            if (atomicLongArray == null) {
                if (atomicLongArray2 != null) {
                    return false;
                }
            } else if (!atomicLongArray.equals(atomicLongArray2)) return false;
            if (!tCMP.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ExecutorMetricsPoller org$apache$spark$executor$ExecutorMetricsPoller$TCMP$$$outer() {
            return this.$outer;
        }

        public TCMP(ExecutorMetricsPoller $outer, AtomicLong count, AtomicLongArray peaks) {
            this.count = count;
            this.peaks = peaks;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

