/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.fedplanner;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.sysds.api.DMLException;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.cost.HopRel;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.runtime.DMLRuntimeException;

public class MemoTable {
    private static final Map<Long, List<HopRel>> hopRelMemo = new HashMap<Long, List<HopRel>>();

    public List<String> getFedOutAlternatives(Hop root) {
        if (!this.containsHop(root)) {
            return null;
        }
        return hopRelMemo.get(root.getHopID()).stream().map(HopRel::getFederatedOutput).map(Enum::name).collect(Collectors.toList());
    }

    public HopRel getMinCostAlternative(Hop root) {
        return hopRelMemo.get(root.getHopID()).stream().min(Comparator.comparingDouble(HopRel::getCost)).orElseThrow(() -> new DMLException("Hop root " + root + " has no feasible federated output alternatives"));
    }

    public boolean hasFederatedOutputAlternative(Hop root) {
        return hopRelMemo.get(root.getHopID()).stream().anyMatch(HopRel::hasFederatedOutput);
    }

    public HopRel getFederatedOutputAlternative(Hop root) {
        return this.getFederatedOutputAlternativeOptional(root).orElseThrow(() -> new DMLException("Hop root " + root + " has no FOUT alternative"));
    }

    public HopRel getFederatedOutputAlternativeOrNull(Hop root) {
        return this.getFederatedOutputAlternativeOptional(root).orElse(null);
    }

    private Optional<HopRel> getFederatedOutputAlternativeOptional(Hop root) {
        return hopRelMemo.get(root.getHopID()).stream().filter(HopRel::hasFederatedOutput).findFirst();
    }

    public HopRel getLOUTOrNONEAlternative(Hop root) {
        return hopRelMemo.get(root.getHopID()).stream().filter(inHopRel -> !inHopRel.hasFederatedOutput()).min(Comparator.comparingDouble(HopRel::getCost)).orElseThrow(() -> new DMLException("Hop root " + root.getHopID() + " " + root + " has no LOUT alternative"));
    }

    public void put(Hop root, List<HopRel> hopRels) {
        hopRelMemo.put(root.getHopID(), hopRels);
    }

    public boolean containsHop(Hop root) {
        return hopRelMemo.containsKey(root.getHopID());
    }

    public boolean containsHopRel(HopRel root) {
        return this.containsHop(root.getHopRef()) && hopRelMemo.get(root.getHopRef().getHopID()).stream().anyMatch(h -> h.getFederatedOutput() == root.getFederatedOutput());
    }

    public List<FTypes.FType> getFTypes(Hop root) {
        if (!hopRelMemo.containsKey(root.getHopID())) {
            throw new DMLRuntimeException("HopRels not found in memo: " + root.getHopID() + " " + root);
        }
        return hopRelMemo.get(root.getHopID()).stream().map(HopRel::getFType).collect(Collectors.toList());
    }

    public HopRel getHopRel(Hop root, FTypes.FType fType) {
        return hopRelMemo.get(root.getHopID()).stream().filter(in -> in.getFType() == fType).findFirst().orElseThrow(() -> new DMLRuntimeException("FType not found in memo"));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Federated MemoTable has ").append(hopRelMemo.size()).append(" entries with the following values:");
        sb.append("\n").append("{").append("\n");
        for (Map.Entry<Long, List<HopRel>> hopEntry : hopRelMemo.entrySet()) {
            sb.append("  ").append(hopEntry.getKey()).append(":").append("\n");
            for (HopRel hopRel : hopEntry.getValue()) {
                sb.append("    ").append((Object)hopRel.getFederatedOutput()).append(" ").append(hopRel.getCost()).append("\n");
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

