/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;
import org.apache.sysds.utils.MemoryEstimates;

public abstract class AColGroup
implements Serializable {
    protected static final Log LOG = LogFactory.getLog((String)AColGroup.class.getName());
    private static final long serialVersionUID = -1318908671481L;
    protected int[] _colIndexes;

    protected AColGroup() {
    }

    protected AColGroup(int[] colIndices) {
        this._colIndexes = colIndices;
    }

    public final int[] getColIndices() {
        return this._colIndexes;
    }

    protected final void setColIndices(int[] colIndexes) {
        this._colIndexes = colIndexes;
    }

    public final int getNumCols() {
        return this._colIndexes.length;
    }

    public final void shiftColIndices(int offset) {
        int[] newIndexes = new int[this._colIndexes.length];
        for (int i = 0; i < this._colIndexes.length; ++i) {
            newIndexes[i] = this._colIndexes[i] + offset;
        }
        this._colIndexes = newIndexes;
    }

    public long estimateInMemorySize() {
        long size = 16L;
        size = (long)((double)size + MemoryEstimates.intArrayCost(this._colIndexes.length));
        return size;
    }

    public final void decompressToSparseBlock(SparseBlock sb, int rl, int ru) {
        this.decompressToSparseBlock(sb, rl, ru, 0, 0);
    }

    public final void decompressToDenseBlock(DenseBlock db, int rl, int ru) {
        this.decompressToDenseBlock(db, rl, ru, 0, 0);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(this.getColGroupType().ordinal());
        out.writeInt(this._colIndexes.length);
        for (int i = 0; i < this._colIndexes.length; ++i) {
            out.writeInt(this._colIndexes[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int numCols = in.readInt();
        this._colIndexes = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            this._colIndexes[i] = in.readInt();
        }
    }

    public long getExactSizeOnDisk() {
        long ret = 0L;
        ++ret;
        ret += 4L;
        return ret += (long)(4 * this._colIndexes.length);
    }

    public final AColGroup sliceColumns(int cl, int cu) {
        AColGroup ret = cu - cl == 1 ? this.sliceColumn(cl) : this.sliceMultiColumns(cl, cu);
        return ret;
    }

    public final AColGroup sliceColumn(int col) {
        int idx = Arrays.binarySearch(this._colIndexes, col);
        if (idx >= 0) {
            return this.sliceSingleColumn(idx);
        }
        return null;
    }

    protected final AColGroup sliceMultiColumns(int cl, int cu) {
        int numberOfOutputColumns;
        int idStart = 0;
        int idEnd = 0;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            if (this._colIndexes[i] < cl) {
                ++idStart;
            }
            if (this._colIndexes[i] >= cu) break;
            ++idEnd;
        }
        if ((numberOfOutputColumns = idEnd - idStart) > 0) {
            int[] outputCols = new int[numberOfOutputColumns];
            int idIt = idStart;
            for (int i = 0; i < numberOfOutputColumns; ++i) {
                outputCols[i] = this._colIndexes[idIt++] - cl;
            }
            return this.sliceMultiColumns(idStart, idEnd, outputCols);
        }
        return null;
    }

    public static double[] colSum(List<AColGroup> groups, double[] res, int nRows) {
        for (AColGroup g : groups) {
            g.computeColSums(res, nRows);
        }
        return res;
    }

    public double get(int r, int c) {
        int colIdx = Arrays.binarySearch(this._colIndexes, c);
        if (colIdx < 0) {
            return 0.0;
        }
        return this.getIdx(r, colIdx);
    }

    public abstract double getIdx(int var1, int var2);

    public abstract int getNumValues();

    public abstract CompressionType getCompType();

    protected abstract ColGroupType getColGroupType();

    public abstract void decompressToDenseBlock(DenseBlock var1, int var2, int var3, int var4, int var5);

    public abstract void decompressToSparseBlock(SparseBlock var1, int var2, int var3, int var4, int var5);

    public abstract AColGroup rightMultByMatrix(MatrixBlock var1);

    public abstract void tsmm(MatrixBlock var1, int var2);

    public abstract void leftMultByMatrixNoPreAgg(MatrixBlock var1, MatrixBlock var2, int var3, int var4, int var5, int var6);

    public abstract void leftMultByAColGroup(AColGroup var1, MatrixBlock var2);

    public abstract void tsmmAColGroup(AColGroup var1, MatrixBlock var2);

    public abstract AColGroup scalarOperation(ScalarOperator var1);

    public abstract AColGroup binaryRowOpLeft(BinaryOperator var1, double[] var2, boolean var3);

    public abstract AColGroup binaryRowOpRight(BinaryOperator var1, double[] var2, boolean var3);

    public abstract void unaryAggregateOperations(AggregateUnaryOperator var1, double[] var2, int var3, int var4, int var5);

    protected abstract AColGroup sliceSingleColumn(int var1);

    protected abstract AColGroup sliceMultiColumns(int var1, int var2, int[] var3);

    public abstract double getMin();

    public abstract double getMax();

    public abstract AColGroup copy();

    public abstract boolean containsValue(double var1);

    public abstract long getNumberNonZeros(int var1);

    public abstract AColGroup replace(double var1, double var3);

    public abstract void computeColSums(double[] var1, int var2);

    public abstract CM_COV_Object centralMoment(CMOperator var1, int var2);

    public abstract AColGroup rexpandCols(int var1, boolean var2, boolean var3, int var4);

    public abstract double getCost(ComputationCostEstimator var1, int var2);

    public abstract AColGroup unaryOperation(UnaryOperator var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\n\n%15s", "ColGroupType: "));
        sb.append(this.getClass().getSimpleName());
        sb.append(String.format("\n%15s", "Columns: "));
        sb.append(Arrays.toString(this._colIndexes));
        return sb.toString();
    }

    protected static enum ColGroupType {
        UNCOMPRESSED,
        RLE,
        OLE,
        DDC,
        CONST,
        EMPTY,
        SDC,
        SDCSingle,
        SDCSingleZeros,
        SDCZeros,
        SDCFOR,
        DDCFOR,
        DeltaDDC;

    }

    public static enum CompressionType {
        UNCOMPRESSED,
        RLE,
        OLE,
        DDC,
        CONST,
        EMPTY,
        SDC,
        SDCFOR,
        DDCFOR,
        DeltaDDC;

    }
}

