/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.concurrent.Future;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.UnaryFEDInstruction;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;

public class AggregateUnaryFEDInstruction
extends UnaryFEDInstruction {
    private AggregateUnaryFEDInstruction(AggregateUnaryOperator auop, CPOperand in, CPOperand out, String opcode, String istr, FEDInstruction.FederatedOutput fedOut) {
        super(FEDInstruction.FEDType.AggregateUnary, (Operator)auop, in, out, opcode, istr, fedOut);
    }

    protected AggregateUnaryFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr, FEDInstruction.FederatedOutput fedOut) {
        super(FEDInstruction.FEDType.AggregateUnary, op, in1, in2, out, opcode, istr, fedOut);
    }

    protected AggregateUnaryFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.AggregateUnary, op, in1, in2, out, opcode, istr);
    }

    protected AggregateUnaryFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.AggregateUnary, op, in1, in2, in3, out, opcode, istr);
    }

    public static AggregateUnaryFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        AggregateUnaryOperator aggun = null;
        aggun = opcode.equalsIgnoreCase("uarimax") || opcode.equalsIgnoreCase("uarimin") ? (InstructionUtils.getExecType(str) == Types.ExecType.SPARK ? InstructionUtils.parseAggregateUnaryRowIndexOperator(opcode, 1, 1) : InstructionUtils.parseAggregateUnaryRowIndexOperator(opcode, Integer.parseInt(parts[4]), 1)) : InstructionUtils.parseBasicAggregateUnaryOperator(opcode);
        FEDInstruction.FederatedOutput fedOut = null;
        fedOut = parts.length == 5 && !parts[4].equals("uarimin") && !parts[4].equals("uarimax") ? FEDInstruction.FederatedOutput.valueOf(parts[4]) : FEDInstruction.FederatedOutput.valueOf(parts[5]);
        return new AggregateUnaryFEDInstruction(aggun, in1, out, opcode, str, fedOut);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (this.getOpcode().contains("var")) {
            this.processVar(ec);
        } else {
            this.processDefault(ec);
        }
    }

    private void processDefault(ExecutionContext ec) {
        AggregateUnaryOperator aop = (AggregateUnaryOperator)this._optr;
        MatrixObject in = ec.getMatrixObject(this.input1);
        if (!in.isFederated()) {
            throw new DMLRuntimeException("Input is not federated " + this.input1);
        }
        FederationMap map = in.getFedMapping();
        if (map == null) {
            throw new DMLRuntimeException("Input federation map is null for input " + this.input1);
        }
        if ((this.instOpcode.equalsIgnoreCase("uarimax") || this.instOpcode.equalsIgnoreCase("uarimin")) && in.isFederated(FTypes.FType.COL)) {
            this.instString = InstructionUtils.replaceOperand(this.instString, 5, "2");
        }
        if (this._fedOut.isForcedFederated()) {
            if (this.instString.startsWith("SPARK")) {
                this.processFederatedSPOutput(map, in, ec, aop);
            } else {
                this.processFederatedOutput(map, in, ec);
            }
        } else if (this.instString.startsWith("SPARK")) {
            this.processGetSPOutput(map, in, ec, aop);
        } else {
            this.processGetOutput(map, aop, ec, in);
        }
    }

    private void processFederatedOutput(FederationMap map, MatrixObject in, ExecutionContext ec) {
        if (this.output.isScalar()) {
            throw new DMLRuntimeException("Output of FED instruction, " + this.output.toString() + ", is a scalar and the output is set to be federated. Scalars cannot be federated. ");
        }
        FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1}, new long[]{in.getFedMapping().getID()}, true);
        map.execute(this.getTID(), true, fr1);
        MatrixObject out = ec.getMatrixObject(this.output);
        this.deriveNewOutputFedMapping(in, out, fr1);
    }

    private void deriveNewOutputFedMapping(MatrixObject in, MatrixObject out, FederatedRequest fr1) {
        if (!this.instOpcode.equals("uack+") && !this.instOpcode.equals("uark+")) {
            throw new DMLRuntimeException("Operation " + this.instOpcode + " is unknown to FOUT processing");
        }
        boolean isColAgg = this.instOpcode.equals("uack+");
        FTypes.FType inFtype = in.getFedMapping().getType();
        FederationMap inputFedMapCopy = in.getFedMapping().copyWithNewID(fr1.getID());
        if (inFtype.isRowPartitioned() && !isColAgg) {
            for (FederatedRange range : inputFedMapCopy.getFederatedRanges()) {
                range.setEndDim(1, out.getNumColumns());
            }
            inputFedMapCopy.setType(FTypes.FType.ROW);
        }
        if (inFtype.isRowPartitioned() && isColAgg || inFtype.isColPartitioned() && !isColAgg) {
            throw new DMLRuntimeException("PART output not supported");
        }
        if (inFtype.isColPartitioned() && isColAgg) {
            for (FederatedRange range : inputFedMapCopy.getFederatedRanges()) {
                range.setEndDim(0, out.getNumRows());
            }
            inputFedMapCopy.setType(FTypes.FType.COL);
        }
        out.setFedMapping(inputFedMapCopy);
    }

    private void processGetOutput(FederationMap map, AggregateUnaryOperator aggUOptr, ExecutionContext ec, MatrixObject in) {
        FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1}, new long[]{in.getFedMapping().getID()}, true);
        FederatedRequest fr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr1.getID());
        Future<FederatedResponse>[] tmp = map.execute(this.getTID(), fr1, fr2);
        if (this.output.isScalar()) {
            ec.setVariable(this.output.getName(), FederationUtils.aggScalar(aggUOptr, tmp, map));
        } else {
            ec.setMatrixOutput(this.output.getName(), FederationUtils.aggMatrix(aggUOptr, tmp, map));
        }
    }

    private void processVar(ExecutionContext ec) {
        FederatedRequest[] federatedRequestArray;
        if (this._fedOut.isForcedFederated()) {
            throw new DMLRuntimeException("Output of " + this.toString() + " should not be federated since the instruction requires consolidation of partial results to be computed.");
        }
        boolean isSpark = this.instString.startsWith("SPARK");
        AggregateUnaryOperator aop = (AggregateUnaryOperator)this._optr;
        MatrixObject in = ec.getMatrixObject(this.input1);
        FederationMap map = in.getFedMapping();
        long id = FederationUtils.getNextFedDataID();
        FederatedRequest tmpRequest = null;
        if (isSpark) {
            if (this.output.isScalar()) {
                ScalarObject scalarOut = ec.getScalarInput(this.output);
                tmpRequest = map.broadcast(scalarOut);
                id = tmpRequest.getID();
            } else if (map.getType() == FTypes.FType.COL && aop.isColAggregate() || map.getType() == FTypes.FType.ROW && aop.isRowAggregate()) {
                tmpRequest = new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, id, new Object[]{new MatrixCharacteristics(-1L, -1L), in.getDataType()});
            } else {
                DataCharacteristics dc = ec.getDataCharacteristics(this.output.getName());
                tmpRequest = new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, id, new Object[]{dc, in.getDataType()});
            }
        }
        Future<FederatedResponse>[] meanTmp = null;
        if (this.getOpcode().contains("var")) {
            FederatedRequest[] federatedRequestArray2;
            String meanInstr = this.instString.replace(this.getOpcode(), this.getOpcode().replace("var", "mean"));
            FederatedRequest meanFr1 = FederationUtils.callInstruction(meanInstr, this.output, id, new CPOperand[]{this.input1}, new long[]{in.getFedMapping().getID()}, isSpark ? Types.ExecType.SPARK : Types.ExecType.CP, isSpark);
            FederatedRequest meanFr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, meanFr1.getID());
            long l = this.getTID();
            if (isSpark) {
                FederatedRequest[] federatedRequestArray3 = new FederatedRequest[3];
                federatedRequestArray3[0] = tmpRequest;
                federatedRequestArray3[1] = meanFr1;
                federatedRequestArray2 = federatedRequestArray3;
                federatedRequestArray3[2] = meanFr2;
            } else {
                FederatedRequest[] federatedRequestArray4 = new FederatedRequest[2];
                federatedRequestArray4[0] = meanFr1;
                federatedRequestArray2 = federatedRequestArray4;
                federatedRequestArray4[1] = meanFr2;
            }
            meanTmp = map.execute(l, true, federatedRequestArray2);
        }
        FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, id, new CPOperand[]{this.input1}, new long[]{in.getFedMapping().getID()}, isSpark ? Types.ExecType.SPARK : Types.ExecType.CP, isSpark);
        FederatedRequest fr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr1.getID());
        long l = this.getTID();
        if (isSpark) {
            FederatedRequest[] federatedRequestArray5 = new FederatedRequest[3];
            federatedRequestArray5[0] = tmpRequest;
            federatedRequestArray5[1] = fr1;
            federatedRequestArray = federatedRequestArray5;
            federatedRequestArray5[2] = fr2;
        } else {
            FederatedRequest[] federatedRequestArray6 = new FederatedRequest[2];
            federatedRequestArray6[0] = fr1;
            federatedRequestArray = federatedRequestArray6;
            federatedRequestArray6[1] = fr2;
        }
        Future<FederatedResponse>[] tmp = map.execute(l, true, federatedRequestArray);
        if (this.output.isScalar()) {
            ec.setVariable(this.output.getName(), FederationUtils.aggScalar(aop, tmp, meanTmp, map));
        } else {
            ec.setMatrixOutput(this.output.getName(), FederationUtils.aggMatrix(aop, tmp, meanTmp, map));
        }
    }

    private void processFederatedSPOutput(FederationMap map, MatrixObject in, ExecutionContext ec, AggregateUnaryOperator aop) {
        DataCharacteristics dc = ec.getDataCharacteristics(this.output.getName());
        long id = FederationUtils.getNextFedDataID();
        FederatedRequest fr1 = map.getType() == FTypes.FType.COL && aop.isColAggregate() || map.getType() == FTypes.FType.ROW && aop.isRowAggregate() ? new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, id, new Object[]{new MatrixCharacteristics(-1L, -1L), in.getDataType()}) : new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, id, new Object[]{dc, in.getDataType()});
        FederatedRequest fr2 = FederationUtils.callInstruction(this.instString, this.output, id, new CPOperand[]{this.input1}, new long[]{in.getFedMapping().getID()}, Types.ExecType.SPARK, true);
        map.execute(this.getTID(), true, fr1, fr2);
        MatrixObject out = ec.getMatrixObject(this.output);
        out.setFedMapping(in.getFedMapping().copyWithNewID(fr2.getID()));
    }

    private void processGetSPOutput(FederationMap map, MatrixObject in, ExecutionContext ec, AggregateUnaryOperator aop) {
        FederatedRequest fr1;
        DataCharacteristics dc = ec.getDataCharacteristics(this.output.getName());
        long id = FederationUtils.getNextFedDataID();
        if (this.output.isScalar()) {
            ScalarObject scalarOut = ec.getScalarInput(this.output);
            fr1 = map.broadcast(scalarOut);
            id = fr1.getID();
        } else {
            fr1 = map.getType() == FTypes.FType.COL && aop.isColAggregate() || map.getType() == FTypes.FType.ROW && aop.isRowAggregate() ? new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, id, new Object[]{new MatrixCharacteristics(-1L, -1L), in.getDataType()}) : new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, id, new Object[]{dc, in.getDataType()});
        }
        FederatedRequest fr2 = FederationUtils.callInstruction(this.instString, this.output, id, new CPOperand[]{this.input1}, new long[]{in.getFedMapping().getID()}, Types.ExecType.SPARK, true);
        FederatedRequest fr3 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr2.getID());
        Future<FederatedResponse>[] tmp = map.execute(this.getTID(), fr1, fr2, fr3);
        if (this.output.isScalar()) {
            ec.setVariable(this.output.getName(), FederationUtils.aggScalar(aop, tmp, map));
        } else {
            ec.setMatrixOutput(this.output.getName(), FederationUtils.aggMatrix(aop, tmp, map));
        }
    }
}

