/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.ArrayList;
import java.util.concurrent.Future;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.lops.WeightedDivMM;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.controlprogram.federated.MatrixLineagePair;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.QuaternaryFEDInstruction;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.QuaternaryOperator;

public class QuaternaryWDivMMFEDInstruction
extends QuaternaryFEDInstruction {
    private QuaternaryOperator _qop;

    protected QuaternaryWDivMMFEDInstruction(QuaternaryOperator operator, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand out, String opcode, String instruction_str) {
        super(FEDInstruction.FEDType.Quaternary, (Operator)operator, in1, in2, in3, in4, out, opcode, instruction_str);
        this._qop = operator;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processInstruction(ExecutionContext ec) {
        Future<FederatedResponse>[] response;
        CPOperand[] cPOperandArray;
        void var6_8;
        FederatedRequest tmpFr;
        FederatedRequest[] tmpFrS;
        WeightedDivMM.WDivMMType wdivmm_type = this._qop.wtype3;
        MatrixObject X = ec.getMatrixObject(this.input1);
        MatrixLineagePair U = ec.getMatrixLineagePair(this.input2);
        MatrixLineagePair V = ec.getMatrixLineagePair(this.input3);
        Object var6_6 = null;
        MatrixLineagePair MX = null;
        if (this._qop.hasFourInputs()) {
            if (wdivmm_type == WeightedDivMM.WDivMMType.MULT_MINUS_4_LEFT || wdivmm_type == WeightedDivMM.WDivMMType.MULT_MINUS_4_RIGHT) {
                MX = ec.getMatrixLineagePair(this._input4);
            } else {
                ScalarObject scalarObject;
                ScalarObject scalarObject2 = scalarObject = this._input4.getDataType() == Types.DataType.SCALAR ? ec.getScalarInput(this._input4) : new DoubleObject(ec.getMatrixInput(this._input4).quickGetValue(0, 0));
            }
        }
        if (!X.isFederated()) throw new DMLRuntimeException("Unsupported federated inputs (X, U, V) = (" + X.isFederated() + ", " + U.isFederated() + ", " + V.isFederated() + ")");
        FederationMap fedMap = X.getFedMapping();
        ArrayList<FederatedRequest[]> frSliced = new ArrayList<FederatedRequest[]>();
        ArrayList<FederatedRequest> frB = new ArrayList<FederatedRequest>();
        long[] varNewIn = new long[this._qop.hasFourInputs() ? 4 : 3];
        varNewIn[0] = fedMap.getID();
        if (X.isFederated(FTypes.FType.ROW)) {
            if (U.isFederated(FTypes.FType.ROW) && fedMap.isAligned(U.getFedMapping(), FTypes.AlignType.ROW)) {
                varNewIn[1] = U.getFedMapping().getID();
            } else {
                tmpFrS = fedMap.broadcastSliced(U, false);
                varNewIn[1] = tmpFrS[0].getID();
                frSliced.add(tmpFrS);
            }
            tmpFr = fedMap.broadcast(V);
            varNewIn[2] = tmpFr.getID();
            frB.add(tmpFr);
        } else {
            if (!X.isFederated(FTypes.FType.COL)) throw new DMLRuntimeException("Federated WDivMM only supported for ROW or COLUMN partitioned federated data.");
            tmpFr = fedMap.broadcast(U);
            varNewIn[1] = tmpFr.getID();
            frB.add(tmpFr);
            if (V.isFederated() && fedMap.isAligned(V.getFedMapping(), FTypes.AlignType.COL, FTypes.AlignType.COL_T)) {
                varNewIn[2] = V.getFedMapping().getID();
            } else {
                FederatedRequest[] tmpFrS2 = fedMap.broadcastSliced(V, true);
                varNewIn[2] = tmpFrS2[0].getID();
                frSliced.add(tmpFrS2);
            }
        }
        if (MX != null) {
            if (MX.isFederated() && fedMap.isAligned(MX.getFedMapping(), FTypes.AlignType.FULL)) {
                varNewIn[3] = MX.getFedMapping().getID();
            } else {
                tmpFrS = fedMap.broadcastSliced(MX, false);
                varNewIn[3] = tmpFrS[0].getID();
                frSliced.add(tmpFrS);
            }
        }
        if (var6_8 != null) {
            tmpFr = fedMap.broadcast((ScalarObject)var6_8);
            varNewIn[3] = tmpFr.getID();
            frB.add(tmpFr);
            this.instString = this.instString.replace("true", "false");
        }
        if (this._qop.hasFourInputs()) {
            CPOperand[] cPOperandArray2 = new CPOperand[4];
            cPOperandArray2[0] = this.input1;
            cPOperandArray2[1] = this.input2;
            cPOperandArray2[2] = this.input3;
            cPOperandArray = cPOperandArray2;
            cPOperandArray2[3] = this._input4;
        } else {
            CPOperand[] cPOperandArray3 = new CPOperand[3];
            cPOperandArray3[0] = this.input1;
            cPOperandArray3[1] = this.input2;
            cPOperandArray = cPOperandArray3;
            cPOperandArray3[2] = this.input3;
        }
        FederatedRequest frComp = FederationUtils.callInstruction(this.instString, this.output, cPOperandArray, varNewIn);
        FederatedRequest frGet = null;
        FederatedRequest frC = null;
        if (wdivmm_type.isLeft() && X.isFederated(FTypes.FType.ROW) || wdivmm_type.isRight() && X.isFederated(FTypes.FType.COL)) {
            frGet = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, frComp.getID());
            frC = fedMap.cleanup(this.getTID(), frComp.getID());
        }
        FederatedRequest[] frAll = frGet == null ? (FederatedRequest[])ArrayUtils.addAll((Object[])frB.toArray(new FederatedRequest[0]), (Object[])new FederatedRequest[]{frComp}) : (FederatedRequest[])ArrayUtils.addAll((Object[])frB.toArray(new FederatedRequest[0]), (Object[])new FederatedRequest[]{frComp, frGet, frC});
        Future<FederatedResponse>[] futureArray = response = frSliced.isEmpty() ? fedMap.execute(this.getTID(), true, frAll) : fedMap.executeMultipleSlices(this.getTID(), true, (FederatedRequest[][])frSliced.toArray((T[])new FederatedRequest[0][]), frAll);
        if (wdivmm_type.isLeft() && X.isFederated(FTypes.FType.ROW) || wdivmm_type.isRight() && X.isFederated(FTypes.FType.COL)) {
            AggregateUnaryOperator aop = InstructionUtils.parseBasicAggregateUnaryOperator("uak+");
            ec.setMatrixOutput(this.output.getName(), FederationUtils.aggMatrix(aop, response, fedMap));
            return;
        } else {
            if (!wdivmm_type.isLeft() && !wdivmm_type.isRight() && !wdivmm_type.isBasic()) throw new DMLRuntimeException("Federated WDivMM only supported for BASIC, LEFT or RIGHT variants.");
            this.setFederatedOutput(X, U.getMO(), V.getMO(), ec, frComp.getID());
        }
    }

    private void setFederatedOutput(MatrixObject X, MatrixObject U, MatrixObject V, ExecutionContext ec, long fedMapID) {
        WeightedDivMM.WDivMMType wdivmm_type = this._qop.wtype3;
        MatrixObject out = ec.getMatrixObject(this.output);
        FederationMap outFedMap = X.getFedMapping().copyWithNewID(fedMapID);
        long rows = -1L;
        long cols = -1L;
        if (wdivmm_type.isBasic()) {
            rows = X.getNumRows();
            cols = X.getNumColumns();
        } else if (wdivmm_type.isLeft()) {
            rows = X.getNumColumns();
            cols = U.getNumColumns();
            outFedMap.transpose().modifyFedRanges(cols, 1);
        } else if (wdivmm_type.isRight()) {
            rows = X.getNumRows();
            cols = V.getNumColumns();
            outFedMap.modifyFedRanges(cols, 1);
        }
        out.setFedMapping(outFedMap);
        out.getDataCharacteristics().set(rows, cols, (int)X.getBlocksize());
    }
}

