/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.encode;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.transform.encode.ColumnEncoder;
import org.apache.sysds.runtime.util.DependencyTask;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.stats.TransformStatistics;

public class ColumnEncoderFeatureHash
extends ColumnEncoder {
    private static final long serialVersionUID = 7435806042138687342L;
    private long _K;

    public ColumnEncoderFeatureHash(int colID, long K) {
        super(colID);
        this._K = K;
    }

    public ColumnEncoderFeatureHash() {
        super(-1);
        this._K = 0L;
    }

    public long getK() {
        return this._K;
    }

    @Override
    protected ColumnEncoder.TransformType getTransformType() {
        return ColumnEncoder.TransformType.FEATURE_HASH;
    }

    @Override
    protected double getCode(CacheBlock in, int row) {
        String key = in.getString(row, this._colID - 1);
        if (key == null) {
            return Double.NaN;
        }
        return (long)key.hashCode() % this._K + 1L;
    }

    @Override
    protected double[] getCodeCol(CacheBlock in, int startInd, int blkSize) {
        int endInd = UtilFunctions.getEndIndex(in.getNumRows(), startInd, blkSize);
        double[] codes = new double[endInd - startInd];
        for (int i = startInd; i < endInd; ++i) {
            String key = in.getString(i, this._colID - 1);
            if (key == null || key.isEmpty()) {
                codes[i - startInd] = Double.NaN;
                continue;
            }
            double mod = (long)key.hashCode() % this._K + 1L;
            if (mod < 0.0) {
                mod += (double)this._K;
            }
            codes[i - startInd] = mod;
        }
        return codes;
    }

    @Override
    public void build(CacheBlock in) {
    }

    @Override
    public List<DependencyTask<?>> getBuildTasks(CacheBlock in) {
        return null;
    }

    @Override
    protected ColumnEncoder.ColumnApplyTask<? extends ColumnEncoder> getSparseTask(CacheBlock in, MatrixBlock out, int outputCol, int startRow, int blk) {
        return new FeatureHashSparseApplyTask(this, in, out, outputCol, startRow, blk);
    }

    @Override
    public void mergeAt(ColumnEncoder other) {
        if (other instanceof ColumnEncoderFeatureHash) {
            assert (other._colID == this._colID);
            if (((ColumnEncoderFeatureHash)other)._K != 0L && this._K == 0L) {
                this._K = ((ColumnEncoderFeatureHash)other)._K;
            }
            return;
        }
        super.mergeAt(other);
    }

    @Override
    public void allocateMetaData(FrameBlock meta) {
        if (this.isApplicable()) {
            meta.ensureAllocatedColumns(1);
        }
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        if (!this.isApplicable()) {
            return meta;
        }
        meta.ensureAllocatedColumns(1);
        meta.set(0, this._colID - 1, String.valueOf(this._K));
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (meta == null || meta.getNumRows() <= 0) {
            return;
        }
        this._K = UtilFunctions.parseToLong(meta.get(0, this._colID - 1).toString());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this._K);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        super.readExternal(in);
        this._K = in.readLong();
    }

    public static class FeatureHashSparseApplyTask
    extends ColumnEncoder.ColumnApplyTask<ColumnEncoderFeatureHash> {
        public FeatureHashSparseApplyTask(ColumnEncoderFeatureHash encoder, CacheBlock input, MatrixBlock out, int outputCol, int startRow, int blk) {
            super(encoder, input, out, outputCol, startRow, blk);
        }

        public FeatureHashSparseApplyTask(ColumnEncoderFeatureHash encoder, CacheBlock input, MatrixBlock out, int outputCol) {
            super(encoder, input, out, outputCol);
        }

        @Override
        public Object call() throws Exception {
            if (this._out.getSparseBlock() == null) {
                return null;
            }
            long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            ((ColumnEncoderFeatureHash)this._encoder).applySparse(this._input, this._out, this._outputCol, this._startRow, this._blk);
            if (DMLScript.STATISTICS) {
                TransformStatistics.incFeatureHashingApplyTime(System.nanoTime() - t0);
            }
            return null;
        }
    }
}

