/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.rewrite;

import java.util.ArrayList;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.FunctionOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.rewrite.HopRewriteRule;
import org.apache.sysds.hops.rewrite.ProgramRewriteStatus;

public class RewriteBlockSizeAndReblock
extends HopRewriteRule {
    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) {
        if (roots == null) {
            return null;
        }
        state.setBlocksize(ConfigurationManager.getBlocksize());
        for (Hop h : roots) {
            this.rule_BlockSizeAndReblock(h, ConfigurationManager.getBlocksize());
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) {
        if (root == null) {
            return null;
        }
        state.setBlocksize(ConfigurationManager.getBlocksize());
        this.rule_BlockSizeAndReblock(root, ConfigurationManager.getBlocksize());
        return root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rule_BlockSizeAndReblock(Hop hop, int blocksize) {
        block11: {
            block10: {
                DataOp dop;
                block13: {
                    block12: {
                        for (Hop hop2 : hop.getInput()) {
                            if (hop2.isVisited()) continue;
                            this.rule_BlockSizeAndReblock(hop2, blocksize);
                        }
                        if (!(hop instanceof DataOp)) break block10;
                        dop = (DataOp)hop;
                        if ((dop.getDataType() != Types.DataType.MATRIX || dop.getBlocksize() == blocksize) && (dop.getDataType() != Types.DataType.FRAME || !OptimizerUtils.isSparkExecutionMode() || dop.getFileFormat() != Types.FileFormat.TEXT && dop.getFileFormat() != Types.FileFormat.CSV)) break block11;
                        if (dop.getOp() != Types.OpOpData.PERSISTENTREAD) break block12;
                        dop.setRequiresReblock(true);
                        dop.setBlocksize(blocksize);
                        break block11;
                    }
                    if (dop.getOp() != Types.OpOpData.PERSISTENTWRITE) break block13;
                    if (dop.getBlocksize() == -1 || !dop.getInput().get(0).requiresReblock() || dop.getInput().get(0).getParent().size() != 1) break block11;
                    dop.getInput().get(0).setBlocksize(dop.getBlocksize());
                    break block11;
                }
                if (dop.getOp().isTransient()) {
                    dop.setBlocksize(blocksize);
                } else {
                    if (dop.getOp() != Types.OpOpData.FEDERATED) throw new HopsException(hop.printErrorLocation() + "unexpected non-scalar Data HOP in reblock.\n");
                    dop.setRequiresReblock(true);
                    dop.setBlocksize(blocksize);
                }
                break block11;
            }
            if (hop.requiresReblock()) {
                hop.setBlocksize(blocksize);
            } else if (hop.getDataType() == Types.DataType.SCALAR) {
                hop.setBlocksize(-1);
            } else {
                FunctionOp fop;
                hop.setBlocksize(blocksize);
                if (hop instanceof FunctionOp && (fop = (FunctionOp)hop).getOutputs() != null) {
                    for (Hop out : fop.getOutputs()) {
                        out.setBlocksize(blocksize);
                    }
                }
                for (Hop hop3 : hop.getInput()) {
                    if (hop3.getDataType() != Types.DataType.MATRIX || hop3.getBlocksize() != -1) continue;
                    hop.setBlocksize(-1);
                    break;
                }
            }
        }
        hop.setVisited();
    }
}

