/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.APreAgg;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class ASDCZero
extends APreAgg {
    private static final long serialVersionUID = -69266306137398807L;
    protected AOffset _indexes;

    protected ASDCZero(int numRows) {
        super(numRows);
    }

    protected ASDCZero(int[] colIndices, int numRows, ADictionary dict, AOffset offsets, int[] cachedCounts) {
        super(colIndices, numRows, dict, cachedCounts);
        this._indexes = offsets;
        this._zeros = true;
    }

    @Override
    public final void leftMultByMatrixNoPreAgg(MatrixBlock matrix, MatrixBlock result, int rl, int ru, int cl, int cu) {
        AIterator it = this._indexes.getIterator(cl);
        if (it == null) {
            return;
        }
        if (it.value() > cu) {
            this._indexes.cacheIterator(it, cu);
        } else if (rl == ru - 1) {
            this.leftMultByMatrixNoPreAggSingleRow(matrix, result, rl, cl, cu, it);
        } else {
            this.leftMultByMatrixNoPreAggRows(matrix, result, rl, ru, cl, cu, it);
        }
    }

    protected final void leftMultByMatrixNoPreAggSingleRow(MatrixBlock mb, MatrixBlock result, int r, int cl, int cu, AIterator it) {
        double[] resV = result.getDenseBlockValues();
        int nCols = result.getNumColumns();
        int offRet = nCols * r;
        if (mb.isInSparseFormat()) {
            SparseBlock sb = mb.getSparseBlock();
            if (cl != 0 && cu != this._numRows) {
                throw new NotImplementedException();
            }
            this.leftMultByMatrixNoPreAggSingleRowSparse(sb, resV, offRet, r, it);
        } else {
            DenseBlock db = mb.getDenseBlock();
            double[] mV = db.values(r);
            int off = db.pos(r);
            this.leftMultByMatrixNoPreAggSingleRowDense(mV, off, resV, offRet, r, cl, cu, it);
        }
    }

    protected final void leftMultByMatrixNoPreAggSingleRowDense(double[] mV, int off, double[] resV, int offRet, int r, int cl, int cu, AIterator it) {
        int last = this._indexes.getOffsetToLast();
        while (it.isNotOver(cu)) {
            this.multiplyScalar(mV[off + it.value()], resV, offRet, it);
            if (it.value() >= last) break;
            it.next();
        }
        this._indexes.cacheIterator(it, cu);
    }

    protected final synchronized void leftMultByMatrixNoPreAggSingleRowSparse(SparseBlock sb, double[] resV, int offRet, int r, AIterator it) {
        if (sb.isEmpty(r)) {
            return;
        }
        int last = this._indexes.getOffsetToLast();
        int apos = sb.pos(r);
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] aval = sb.values(r);
        int v = it.value();
        if (aix[alen - 1] < last) {
            while (apos < alen) {
                if (aix[apos] == v) {
                    this.multiplyScalar(aval[apos++], resV, offRet, it);
                    v = it.next();
                    continue;
                }
                if (aix[apos] < v) {
                    ++apos;
                    continue;
                }
                v = it.next();
            }
        } else {
            while (v < last) {
                if (aix[apos] == v) {
                    this.multiplyScalar(aval[apos++], resV, offRet, it);
                    v = it.next();
                    continue;
                }
                if (aix[apos] < v) {
                    ++apos;
                    continue;
                }
                v = it.next();
            }
            while (aix[apos] < last && apos < alen) {
                ++apos;
            }
            if (last == aix[apos]) {
                this.multiplyScalar(aval[apos], resV, offRet, it);
            }
        }
    }

    protected final void leftMultByMatrixNoPreAggRows(MatrixBlock mb, MatrixBlock result, int rl, int ru, int cl, int cu, AIterator it) {
        double[] resV = result.getDenseBlockValues();
        int nCols = result.getNumColumns();
        if (mb.isInSparseFormat()) {
            SparseBlock sb = mb.getSparseBlock();
            this.leftMultByMatrixNoPreAggRowsSparse(sb, resV, nCols, rl, ru, cl, cu, it);
        } else {
            this.leftMultByMatrixNoPreAggRowsDense(mb, resV, nCols, rl, ru, cl, cu, it);
        }
    }

    protected final void leftMultByMatrixNoPreAggRowsSparse(SparseBlock sb, double[] resV, int nCols, int rl, int ru, int cl, int cu, AIterator it) {
        if (cl != 0 && cu != this._numRows) {
            throw new NotImplementedException();
        }
        for (int r = rl; r < ru; ++r) {
            int offRet = nCols * r;
            this.leftMultByMatrixNoPreAggSingleRowSparse(sb, resV, offRet, r, it.clone());
        }
    }

    protected final void leftMultByMatrixNoPreAggRowsDense(MatrixBlock mb, double[] resV, int nCols, int rl, int ru, int cl, int cu, AIterator it) {
        DenseBlock db = mb.getDenseBlock();
        for (int r = rl; r < ru; ++r) {
            double[] mV = db.values(r);
            int off = db.pos(r);
            int offRet = nCols * r;
            this.leftMultByMatrixNoPreAggSingleRowDense(mV, off, resV, offRet, r, cl, cu, it.clone());
        }
    }

    protected abstract void multiplyScalar(double var1, double[] var3, int var4, AIterator var5);

    public void decompressToDenseBlock(DenseBlock db, int rl, int ru, int offR, int offC, AIterator it) {
        if (this._dict instanceof MatrixBlockDictionary) {
            MatrixBlockDictionary md = (MatrixBlockDictionary)this._dict;
            MatrixBlock mb = md.getMatrixBlock();
            if (mb.isInSparseFormat()) {
                this.decompressToDenseBlockSparseDictionary(db, rl, ru, offR, offC, mb.getSparseBlock());
            } else {
                this.decompressToDenseBlockDenseDictionaryWithProvidedIterator(db, rl, ru, offR, offC, mb.getDenseBlockValues(), it);
            }
        } else {
            this.decompressToDenseBlockDenseDictionaryWithProvidedIterator(db, rl, ru, offR, offC, this._dict.getValues(), it);
        }
    }

    public void decompressToDenseBlockDenseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, AIterator it) {
        this.decompressToDenseBlockDenseDictionaryWithProvidedIterator(db, rl, ru, offR, offC, this._dict.getValues(), it);
    }

    public abstract void decompressToDenseBlockDenseDictionaryWithProvidedIterator(DenseBlock var1, int var2, int var3, int var4, int var5, double[] var6, AIterator var7);

    public AIterator getIterator(int row) {
        return this._indexes.getIterator(row);
    }

    protected abstract int getIndexesSize();
}

