/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.server.handler.HttpHandlerUtil;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.util.TextPlainMessageSerializer;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.ser.SerializationException;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.node.ArrayNode;
import org.apache.tinkerpop.shaded.jackson.databind.node.ObjectNode;
import org.javatuples.Pair;

@ChannelHandler.Sharable
public class HttpRequestMessageDecoder
extends MessageToMessageDecoder<FullHttpRequest> {
    private static final Pattern pattern = Pattern.compile("(.*);q=(.*)");
    private final TextPlainMessageSerializer textPlainSerializer = new TextPlainMessageSerializer();
    private final Map<String, MessageSerializer<?>> serializers;
    private final ObjectMapper mapper = new ObjectMapper();

    public HttpRequestMessageDecoder(Map<String, MessageSerializer<?>> serializers) {
        this.serializers = serializers;
    }

    protected void decode(ChannelHandlerContext ctx, FullHttpRequest req, List<Object> objects) throws Exception {
        RequestMessage requestMessage;
        ctx.channel().attr(StateKey.REQUEST_HEADERS).set((Object)req.headers());
        String acceptMime = Optional.ofNullable(req.headers().get((CharSequence)HttpHeaderNames.ACCEPT)).orElse("application/json");
        Pair<String, MessageSerializer<?>> serializer = this.chooseSerializer(acceptMime);
        if (req.method() != HttpMethod.POST) {
            HttpHandlerUtil.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED, HttpResponseStatus.METHOD_NOT_ALLOWED.toString());
            return;
        }
        if (null == serializer) {
            HttpHandlerUtil.sendError(ctx, HttpResponseStatus.BAD_REQUEST, String.format("no serializer for requested Accept header: %s", acceptMime));
            return;
        }
        try {
            requestMessage = this.getRequestMessageFromHttpRequest(req, this.serializers);
        }
        catch (IllegalArgumentException | NullPointerException | SerializationException ex) {
            HttpHandlerUtil.sendError(ctx, HttpResponseStatus.BAD_REQUEST, ex.getMessage());
            return;
        }
        ctx.channel().attr(StateKey.SERIALIZER).set((Object)Pair.with((Object)((String)serializer.getValue0()), (Object)((MessageSerializer)serializer.getValue1())));
        objects.add(requestMessage);
    }

    private Pair<String, MessageSerializer<?>> chooseSerializer(String mimeType) {
        List ordered = Stream.of(mimeType.split(",")).map(mediaType -> {
            Matcher matcher = pattern.matcher((CharSequence)mediaType);
            return matcher.matches() ? Pair.with((Object)matcher.group(1), (Object)Double.parseDouble(matcher.group(2))) : Pair.with((Object)mediaType, (Object)1.0);
        }).sorted((o1, o2) -> ((String)o2.getValue0()).compareTo((String)o1.getValue0())).collect(Collectors.toList());
        for (Pair p : ordered) {
            String accept;
            String string = accept = ((String)p.getValue0()).equals("*/*") ? "application/json" : (String)p.getValue0();
            if (this.serializers.containsKey(accept)) {
                return Pair.with((Object)accept, this.serializers.get(accept));
            }
            if (!accept.equals("text/plain")) continue;
            return Pair.with((Object)accept, (Object)((Object)this.textPlainSerializer));
        }
        return null;
    }

    public RequestMessage getRequestMessageFromHttpRequest(FullHttpRequest request, Map<String, MessageSerializer<?>> serializers) throws SerializationException {
        String contentType = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentType != null && !contentType.equals("application/json") && serializers.containsKey(contentType)) {
            MessageSerializer<?> serializer = serializers.get(contentType);
            ByteBuf buffer = request.content();
            try {
                return serializer.deserializeBinaryRequest(buffer);
            }
            catch (Exception e) {
                throw new SerializationException("Unable to deserialize request using: " + serializer.getClass().getSimpleName(), (Throwable)e);
            }
        }
        return this.getRequestMessageFromHttpRequest(request);
    }

    private RequestMessage getRequestMessageFromHttpRequest(FullHttpRequest request) {
        JsonNode matPropsNode;
        JsonNode timeoutMsNode;
        JsonNode languageNode;
        JsonNode body;
        try {
            body = this.mapper.readTree(request.content().toString(CharsetUtil.UTF_8));
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("body could not be parsed", ioe);
        }
        JsonNode scriptNode = body.get("gremlin");
        if (null == scriptNode) {
            throw new IllegalArgumentException("no gremlin script supplied");
        }
        RequestMessage.Builder builder = RequestMessage.build((String)scriptNode.asText());
        JsonNode bindingsNode = body.get("bindings");
        if (bindingsNode != null && !bindingsNode.isObject()) {
            throw new IllegalArgumentException("bindings must be a Map");
        }
        HashMap bindings = new HashMap();
        if (bindingsNode != null) {
            bindingsNode.fields().forEachRemaining(kv -> bindings.put((String)kv.getKey(), this.fromJsonNode((JsonNode)kv.getValue())));
        }
        builder.addBindings(bindings);
        JsonNode gNode = body.get("g");
        if (null != gNode) {
            builder.addG(gNode.asText());
        }
        builder.addLanguage(null == (languageNode = body.get("language")) ? "gremlin-lang" : languageNode.asText());
        JsonNode chunkSizeNode = body.get("batchSize");
        if (null != chunkSizeNode) {
            builder.addChunkSize(chunkSizeNode.asInt());
        }
        if (null != (timeoutMsNode = body.get("timeoutMs"))) {
            builder.addTimeoutMillis(timeoutMsNode.asLong());
        }
        if (null != (matPropsNode = body.get("materializeProperties"))) {
            builder.addMaterializeProperties(matPropsNode.asText());
        }
        return builder.create();
    }

    private Object fromJsonNode(JsonNode node) {
        if (node.isNull()) {
            return null;
        }
        if (node.isObject()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ObjectNode objectNode = (ObjectNode)node;
            Iterator iterator = objectNode.fieldNames();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                map.put(key, this.fromJsonNode(objectNode.get(key)));
            }
            return map;
        }
        if (node.isArray()) {
            ArrayNode arrayNode = (ArrayNode)node;
            ArrayList<Object> array = new ArrayList<Object>();
            for (int i = 0; i < arrayNode.size(); ++i) {
                array.add(this.fromJsonNode(arrayNode.get(i)));
            }
            return array;
        }
        if (node.isFloatingPointNumber()) {
            return node.asDouble();
        }
        if (node.isIntegralNumber()) {
            return node.asLong();
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        return node.asText();
    }
}

