/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ByteBuffer;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.ICUResourceBundleReader;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceBundleIterator;
import com.ibm.icu.util.UResourceTypeMismatchException;
import java.util.HashMap;
import java.util.MissingResourceException;

class ICUResourceBundleImpl {
    ICUResourceBundleImpl() {
    }

    static final class ResourceTable32
    extends ICUResourceBundle {
        protected UResourceBundle handleGetImpl(String resKey, HashMap table, UResourceBundle requested, int[] index, boolean[] isAlias) {
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ICUResourceBundle.getIntOffset(1);
            index[0] = this.findKey(this.size, currentOffset, this, resKey);
            if (index[0] == -1) {
                throw new MissingResourceException("Could not find resource ", ICUResourceBundleReader.getFullName(this.baseName, this.localeID), resKey);
            }
            long resOffset = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ICUResourceBundle.getIntOffset(this.size) + ICUResourceBundle.getIntOffset(index[0]));
            String path = this.isTopLevel ? resKey : this.resPath + "/" + resKey;
            return this.createBundleObject(resKey, resOffset, path, table, requested, this, isAlias);
        }

        public int getOffset(int currentOffset, int index) {
            return ICUResourceBundle.getInt(this.rawData, currentOffset + ICUResourceBundle.getIntOffset(index));
        }

        protected UResourceBundle handleGetImpl(int index, HashMap table, UResourceBundle requested, boolean[] isAlias) {
            if (this.size <= 0) {
                return null;
            }
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ICUResourceBundle.getIntOffset(1) + ICUResourceBundle.getIntOffset(index);
            int betterOffset = this.getOffset(currentOffset, 0);
            String itemKey = ICUResourceBundle.RES_GET_KEY(this.rawData, betterOffset).toString();
            long resOffset = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ICUResourceBundle.getIntOffset(this.size));
            String path = this.isTopLevel ? Integer.toString(index) : this.resPath + "/" + index;
            return this.createBundleObject(itemKey, resOffset, path, table, requested, this, isAlias);
        }

        private int countItems() {
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int value = ICUResourceBundle.getInt(this.rawData, offset);
            return value;
        }

        ResourceTable32(String key, String resPath, long resource, ICUResourceBundle bundle) {
            this(key, resPath, resource, bundle, false);
        }

        ResourceTable32(ICUResourceBundleReader reader, String baseName, String localeID, ClassLoader loader) {
            this.rawData = reader.getData();
            this.rootResource = 0xFFFFFFFFL & (long)reader.getRootResource();
            this.noFallback = reader.getNoFallback();
            this.baseName = baseName;
            this.localeID = localeID;
            this.ulocale = new ULocale(localeID);
            this.loader = loader;
            this.initialize(null, "", this.rootResource, null, this.isTopLevel);
        }

        void initialize(String resKey, String resourcePath, long resOffset, ICUResourceBundle bundle, boolean topLevel) {
            if (bundle != null) {
                ICUResourceBundle.assign(this, bundle);
            }
            this.key = resKey;
            this.resource = resOffset;
            this.isTopLevel = topLevel;
            this.size = this.countItems();
            this.resPath = resourcePath;
            this.createLookupCache();
        }

        ResourceTable32(String key, String resPath, long resource, ICUResourceBundle bundle, boolean isTopLevel) {
            this.initialize(key, resPath, resource, bundle, isTopLevel);
        }
    }

    static final class ResourceTable
    extends ICUResourceBundle {
        protected UResourceBundle handleGetImpl(String resKey, HashMap table, UResourceBundle requested, int[] index, boolean[] isAlias) {
            if (this.size <= 0) {
                return null;
            }
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ICUResourceBundle.getCharOffset(1);
            index[0] = this.findKey(this.size, currentOffset, this, resKey);
            if (index[0] == -1) {
                return null;
            }
            long resOffset = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ICUResourceBundle.getCharOffset(this.size + (~this.size & 1)) + ICUResourceBundle.getIntOffset(index[0]));
            String path = this.isTopLevel ? resKey : this.resPath + "/" + resKey;
            return this.createBundleObject(resKey, resOffset, path, table, requested, this, isAlias);
        }

        public int getOffset(int currentOffset, int index) {
            return ICUResourceBundle.getChar(this.rawData, currentOffset + ICUResourceBundle.getCharOffset(index));
        }

        protected UResourceBundle handleGetImpl(int index, HashMap table, UResourceBundle requested, boolean[] isAlias) {
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ICUResourceBundle.getCharOffset(1);
            int betterOffset = this.getOffset(currentOffset, index);
            String itemKey = ICUResourceBundle.RES_GET_KEY(this.rawData, betterOffset).toString();
            long resOffset = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ICUResourceBundle.getCharOffset(this.size + (~this.size & 1)) + ICUResourceBundle.getIntOffset(index));
            String path = this.isTopLevel ? itemKey : this.resPath + "/" + itemKey;
            return this.createBundleObject(itemKey, resOffset, path, table, requested, this, isAlias);
        }

        private int countItems() {
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            char value = ICUResourceBundle.getChar(this.rawData, offset);
            return value;
        }

        ResourceTable(String key, String resPath, long resource, ICUResourceBundle bundle) {
            this(key, resPath, resource, bundle, false);
        }

        ResourceTable(ICUResourceBundleReader reader, String baseName, String localeID, ClassLoader loader) {
            this.rawData = reader.getData();
            this.rootResource = 0xFFFFFFFFL & (long)reader.getRootResource();
            this.noFallback = reader.getNoFallback();
            this.baseName = baseName;
            this.localeID = localeID;
            this.ulocale = new ULocale(localeID);
            this.loader = loader;
            this.initialize(null, "", this.rootResource, null, this.isTopLevel);
        }

        void initialize(String resKey, String resourcePath, long resOffset, ICUResourceBundle bundle, boolean topLevel) {
            if (bundle != null) {
                ICUResourceBundle.assign(this, bundle);
            }
            this.key = resKey;
            this.resource = resOffset;
            this.isTopLevel = topLevel;
            this.size = this.countItems();
            this.resPath = resourcePath;
            this.createLookupCache();
        }

        ResourceTable(String key, String resPath, long resource, ICUResourceBundle bundle, boolean isTopLevel) {
            this.initialize(key, resPath, resource, bundle, isTopLevel);
        }
    }

    static final class ResourceIntVector
    extends ICUResourceBundle {
        private int[] value;

        public int[] getIntVector() {
            return this.value;
        }

        private int[] getValue() {
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int length = ICUResourceBundle.getInt(this.rawData, offset);
            int intOffset = offset + ICUResourceBundle.getIntOffset(1);
            int[] val = new int[length];
            int i = 0;
            while (i < length) {
                val[i] = ICUResourceBundle.getInt(this.rawData, intOffset + ICUResourceBundle.getIntOffset(i));
                ++i;
            }
            return val;
        }

        ResourceIntVector(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ICUResourceBundle.assign(this, bundle);
            this.key = key;
            this.resource = resource;
            this.size = 1;
            this.resPath = resPath;
            this.value = this.getValue();
        }
    }

    static final class ResourceString
    extends ICUResourceBundle {
        private String value;

        public String getString() {
            return this.value;
        }

        ResourceString(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ICUResourceBundle.assign(this, bundle);
            this.value = this.getStringValue(resource);
            this.key = key;
            this.resource = resource;
            this.resPath = resPath;
        }
    }

    static final class ResourceInt
    extends ICUResourceBundle {
        public int getInt() {
            return ICUResourceBundle.RES_GET_INT(this.resource);
        }

        public int getUInt() {
            long ret = ICUResourceBundle.RES_GET_UINT(this.resource);
            return (int)ret;
        }

        ResourceInt(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ICUResourceBundle.assign(this, bundle);
            this.key = key;
            this.resource = resource;
            this.resPath = resPath;
        }
    }

    static final class ResourceBinary
    extends ICUResourceBundle {
        private byte[] value;

        public ByteBuffer getBinary() {
            return ByteBuffer.wrap(this.value);
        }

        public byte[] getBinary(byte[] ba) {
            return this.value;
        }

        private byte[] getValue() {
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int length = ICUResourceBundle.getInt(this.rawData, offset);
            int byteOffset = offset + ICUResourceBundle.getIntOffset(1);
            byte[] dst = new byte[length];
            System.arraycopy(this.rawData, byteOffset, dst, 0, length);
            return dst;
        }

        ResourceBinary(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ICUResourceBundle.assign(this, bundle);
            this.resource = resource;
            this.key = key;
            this.resPath = resPath;
            this.value = this.getValue();
        }
    }

    static final class ResourceArray
    extends ICUResourceBundle {
        protected String[] handleGetStringArray() {
            String[] strings = new String[this.size];
            UResourceBundleIterator iter = this.getIterator();
            int i = 0;
            while (iter.hasNext()) {
                strings[i++] = iter.next().getString();
            }
            return strings;
        }

        public String[] getStringArray() {
            return this.handleGetStringArray();
        }

        protected UResourceBundle handleGetImpl(String indexStr, HashMap table, UResourceBundle requested, int[] index, boolean[] isAlias) {
            index[0] = ICUResourceBundle.getIndex(indexStr);
            if (index[0] > -1) {
                return this.handleGetImpl(index[0], table, requested, isAlias);
            }
            throw new UResourceTypeMismatchException("Could not get the correct value for index: " + index);
        }

        protected UResourceBundle handleGetImpl(int index, HashMap table, UResourceBundle requested, boolean[] isAlias) {
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int itemOffset = offset + ICUResourceBundle.getIntOffset(index + 1);
            long itemResource = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, itemOffset);
            String path = this.isTopLevel ? Integer.toString(index) : this.resPath + "/" + index;
            return this.createBundleObject(Integer.toString(index), itemResource, path, table, requested, this, isAlias);
        }

        private int countItems() {
            int offset = ICUResourceBundle.RES_GET_OFFSET(this.resource);
            int value = ICUResourceBundle.getInt(this.rawData, offset);
            return value;
        }

        ResourceArray(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ICUResourceBundle.assign(this, bundle);
            this.resource = resource;
            this.key = key;
            this.size = this.countItems();
            this.resPath = resPath;
            this.createLookupCache();
        }
    }
}

