/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.mac;

import gnu.crypto.mac.IMac;
import gnu.crypto.mac.MacFactory;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;

public class TestOfHMacSha1
implements Testlet {
    private static final byte[][][] TEST_VECTOR = new byte[][][]{new byte[][]{"Jefe".getBytes(), "what do ya want for nothing?".getBytes(), Util.toBytesFromString((String)"effcdf6ae5eb2fa2d27416d5f184df9c259a7c79")}, new byte[][]{Util.toBytesFromString((String)"0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b"), "Hi There".getBytes(), Util.toBytesFromString((String)"b617318655057264e28bc0b6fb378c8ef146be00")}, new byte[][]{Util.toBytesFromString((String)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"), new byte[50], Util.toBytesFromString((String)"125d7342b9ac11cd91a39af48aa17b4f63f175d3")}, new byte[][]{Util.toBytesFromString((String)"0102030405060708090a0b0c0d0e0f10111213141516171819"), new byte[50], Util.toBytesFromString((String)"4c9007f4026250c6bc8414f9bf50c86c2d7235da")}, new byte[][]{Util.toBytesFromString((String)"0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c"), "Test With Truncation".getBytes(), Util.toBytesFromString((String)"4c1a03424b55e07fe7f27be1d58bb9324a9a5a04")}, new byte[][]{new byte[80], "Test Using Larger Than Block-Size Key - Hash Key First".getBytes(), Util.toBytesFromString((String)"aa4ae5e15272d00e95705637ce8a3b55ed402112")}, new byte[][]{new byte[80], "Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data".getBytes(), Util.toBytesFromString((String)"e8e99d0f45237d786d6bbaa7965c7808bbff1a91")}};
    private HashMap attr = new HashMap();
    private IMac mac;

    public void test(TestHarness harness) {
        harness.checkPoint("TestOfHMacSha1");
        this.mac = MacFactory.getInstance((String)"hmac-sha1");
        try {
            this.attr.put("gnu.crypto.mac.key.material", TEST_VECTOR[0][0]);
            this.mac.init((Map)this.attr);
            this.mac.update(TEST_VECTOR[0][1], 0, TEST_VECTOR[0][1].length);
            harness.check(Util.areEqual((byte[])this.mac.digest(), (byte[])TEST_VECTOR[0][2]), "#0");
            harness.fail("#0 - SHOULD have caused a Key too short exception but didn't");
        }
        catch (InvalidKeyException x) {
            harness.check(true, "#0");
        }
        int i = 1;
        while (i < TEST_VECTOR.length) {
            try {
                this.attr.put("gnu.crypto.mac.key.material", TEST_VECTOR[i][0]);
                this.mac.init((Map)this.attr);
                this.mac.update(TEST_VECTOR[i][1], 0, TEST_VECTOR[i][1].length);
                harness.check(Util.areEqual((byte[])this.mac.digest(), (byte[])TEST_VECTOR[i][2]), "#" + i);
            }
            catch (Exception x) {
                harness.debug(x);
                harness.fail("#" + i + " - " + String.valueOf(x));
            }
            ++i;
        }
    }

    static {
        int i = 0;
        while (i < 50) {
            TestOfHMacSha1.TEST_VECTOR[2][1][i] = -35;
            TestOfHMacSha1.TEST_VECTOR[3][1][i] = -51;
            TestOfHMacSha1.TEST_VECTOR[5][0][i] = -86;
            TestOfHMacSha1.TEST_VECTOR[6][0][i] = -86;
            ++i;
        }
        while (i < 80) {
            TestOfHMacSha1.TEST_VECTOR[5][0][i] = -86;
            TestOfHMacSha1.TEST_VECTOR[6][0][i] = -86;
            ++i;
        }
    }
}

