Summary: Samba SMB client and server
Name: samba
Version: 2.0.10
%define ja_rel 1.2
Release:  ja_%{ja_rel}
Copyright: GNU GPL version 2
Group: Networking
Source: ftp://ftp.samba.gr.jp/pub/samba-jp/samba-2.0.7-ja/samba-%{version}-ja-%{ja_rel}.tar.gz
Patch: makefile-path.patch
Patch1: smbw.patch
Patch2: nss_makefile.patch
Packager: Hiroshi MIURA [Samba Users Group Japan] <miura@samba.gr.jp>
Requires: pam >= 0.64 gettext >= 0.10 kernel >= 2.2.1 glibc >= 2.1.2 tcp_wrappers
Prereq: chkconfig fileutils
BuildRoot: /var/tmp/samba


%package debugtools
Version: 2.0.7
Release: ja_%{ja_rel}
Group: Networking
Summary: Programs to debug Samba and to test SMB client integrity

%package -n smbfs
Version: 2.0.7
Release: ja_%{ja_rel}
Group: Utilities/File
Summary: Programs to mount SMB shares.

%description
Samba provides an SMB server which can be used to provide
network services to SMB (sometimes called "Lan Manager")
clients, including various versions of MS Windows, OS/2,
and other Linux machines. Samba also provides some SMB
clients, which complement the built-in SMB filesystem
in Linux. Samba uses NetBIOS over TCP/IP (NetBT) protocols
and does NOT need NetBEUI (Microsoft Raw NetBIOS frame)
protocol.

Samba-2 features an almost working NT Domain Control
capability and includes the new SWAT (Samba Web Administration
Tool) that allows samba's smb.conf file to be remotely managed
using your favourite web browser. For the time being this is
being enabled on TCP port 901 via inetd.

Please refer to the WHATSNEW.txt document for fixup information.
This binary release includes encrypted password support.

Please read the smb.conf file and ENCRYPTION.txt in the
docs directory for implementation details.

NOTE: TurboLinux uses PAM which has integrated support
for Shadow passwords. Do NOT recompile with the SHADOW_PWD option
enabled. TurboLinux has built in support for quotas in PAM.

NOTE: TurboLinux uses PAM which has integrated support
for Shadow passwords. Do NOT recompile with the SHADOW_PWD option
enabled. TurboLinux has built in support for quotas in PAM.

%description -n smbfs
This package includes the tools necessary to mount filesystems from
SMB servers.

%description debugtools
This package contains programs that can be used to crash test any SMB
server. Please use it with care. If you do not need it then do NOT
install.

%changelog
* Tue Jul 7 2000 TAKAHASHI Motonobu <monyo@samba.gr.jp>
 - Added smb-useradd and smb-userdel scripts
 - Added some misc. documents, manual pages
 - Fixed lots of typo;-)

* Tue Jun 13 2000 Hiroshi MIURA <miura@samba.gr.jp>
 - fix setup source directory error 
 - Added support for "HowToUseSamba" Document
 - Added support for "i18n SWAT"

* Fri Apr 14 2000 John H Terpstra <jht@turbolinux.com>
- Added unicode pages

* Sat Apr 08 2000 John H Terpsta <jht@turbolinux.com>
- Added nsswitch stuff
- Fixed some typos
- Changed hard link for smbmount to symlink

* Sun Apr 02 2000 John H Terpstra <jht@turbolinux.com>
- Updated for samba-2.0.7
- Added codepages 775 1251
- Added configure options "--with-profile --with-utmp 
   --with-netatalk --with-sambabook=/usr/share/swat/using_samba"
- added using_samba book

* Fri Oct 29 1999 Kelley Spoon <kspoon@turbolinux.com>
- get rid of the rc?.d directories
- -j flags for make command to (hopefully) speed up on 
  SMP systems
- discoverd that John had already made the changes I
  was going to do...
- Wait!  He forgot to move the man pages into /usr/share!
  Cool... I get to do something substantial.

* Sun Oct 16 1999 John H Terspstra <jht@turbolinux.com>
- changed mount.smb to link to smbmount
- removed smbwrappers as it is broken with glibc-2.1.x

* Sun May 09 1999 John H Terpstra <jht@samba.org>
- Added smbtorture et al.

* Wed Mar 10 1999 Scott Stone <sstone@turbolinux.com>
- This package now builds smbfs stuff
- Added xinetd autosetup in the post install section
- (todo: add remove of xinetd stuff in postuninstall section)

* Sun Feb 28 1999 Jeremy Allison <jra@samba.org>
 - Removed smbrun binary and tidied up some loose ends

* Sun Oct 25 1998 John H Terpstra <jht@samba.org>
 - Added modifier to /config specifier so that smb.conf,
        lmhosts and smbusers never get lost

* Sat Oct 24 1998 John H Terpstra <jht@samba.org>
 - removed README.smbsh file from docs area

* Mon Oct 05 1998 John H Terpstra <jht@samba.org>
 - Added rpcclient to binaries list
 - Added smbwrapper stuff

* Fri Aug 21 1998 John H Terpstra <jht@samba.org>
 - Updated for Samba version 2.0 building

* Tue Jul 07 1998 Erik Troan <ewt@redhat.com>
  - updated postun triggerscript to check $0
  - clear /etc/codepages from %preun instead of %postun

* Sat Jul 04 1998 John H Terpstra <jht@samba.org>
 - fixed codepage preservation during update via -Uvh

* Mon Jun 08 1998 Erik Troan <ewt@redhat.com>
  - made the %postun script a tad less agressive; no reason to remove
    the logs or lock file
  - the %postun and %preun should only exectute if this is the final
    removal
  - migrated %triggerpostun from Red Hat's samba package to work around
    packaging problems in some Red Hat samba releases

* Sun Apr 26 1998 John H Terpstra <jht@samba.org>
 - Tidy up for early alpha releases
 - added findsmb from SGI packaging

* Thu Apr 09 1998 John H Terpstra <jht@samba.org>
 - Updated spec file
 - Included new codepage.936

* Sat Mar 20 1998 John H Terpstra <jht@samba.org>
 - Added swat facility

* Sat Jan 24 1998 John H Terpstra <jht@samba.org>
 - Many optimisations (some suggested by Manoj Kasichainula <manojk@io.com>
  - Use of chkconfig in place of individual symlinks to /etc/rc.d/init/smb
  - Compounded make line
  - Updated smb.init restart mechanism
  - Use compound mkdir -p line instead of individual calls to mkdir
  - Fixed smb.conf file path for log files
  - Fixed smb.conf file path for incoming smb print spool directory
  - Added a number of options to smb.conf file
  - Added smbadduser command (missed from all previous RPMs) - Doooh!
  - Added smbuser file and smb.conf file updates for username map

%prep
%setup -n samba-%{version}-ja-%{ja_rel}
%patch -p1
%patch1 -p1
%patch2 -p2

%build
cd source
NUMCPU=`grep processor /proc/cpuinfo | wc -l`
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=/usr --libdir=/etc --with-lockdir=/var/lock/samba --with-privatedir=/etc --with-swatdir=/usr/share/swat --with-sambabook=/usr/share/swat/using_samba --with-swat-langfile=/usr/share/swat/swat-i18n.conf --with-smbmount --with-profile --with-utmp  --with-netatalk --with-automount --with-quotas --with-pam --with-i18n-swat 
make -j${NUMCPU} all smbtorture rpctorture smbfilter debug2html nsswitch/libnss_wins.so

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT/etc/codepages/src
mkdir -p $RPM_BUILD_ROOT/etc/{logrotate.d,pam.d}
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/lib
mkdir -p $RPM_BUILD_ROOT/home/samba
mkdir -p $RPM_BUILD_ROOT/usr/{bin,sbin}
mkdir -p $RPM_BUILD_ROOT/usr/share/swat/using_samba/{gifs,figs}
mkdir -p $RPM_BUILD_ROOT/usr/share/swat/{images,help,include}
mkdir -p $RPM_BUILD_ROOT/usr/share/swat/ja/help/HowToUseSamba
mkdir -p $RPM_BUILD_ROOT/usr/share/swat/ja/{images,include}
mkdir -p $RPM_BUILD_ROOT/usr/share/swat/ja_JP.SJIS/{images,help,include}
mkdir -p $RPM_BUILD_ROOT/usr/share/locale/en/LC_MESSAGES
mkdir -p $RPM_BUILD_ROOT/usr/share/locale/ja/LC_MESSAGES
mkdir -p $RPM_BUILD_ROOT/usr/share/locale/ja_JP.SJIS/LC_MESSAGES
mkdir -p $RPM_BUILD_ROOT/usr/share/man/{man1,man5,man7,man8}
mkdir -p $RPM_BUILD_ROOT/usr/share/man/ja/{man1,man5,man7,man8}
mkdir -p $RPM_BUILD_ROOT/var/lock/samba
mkdir -p $RPM_BUILD_ROOT/var/log/samba
mkdir -p $RPM_BUILD_ROOT/var/spool/samba

# Install standard binary files
for i in nmblookup smbclient smbspool smbpasswd smbstatus testparm testprns \
      make_smbcodepage make_printerdef rpcclient make_unicodemap
do
install -m755 -s source/bin/$i $RPM_BUILD_ROOT/usr/bin
done
for i in addtosmbpass mksmbpasswd.sh smbtar 
do
install -m755 source/script/$i $RPM_BUILD_ROOT/usr/bin
done
for i in smb-useradd smb-userdel
do
install -m755 examples/add-delete-user-script/$i $RPM_BUILD_ROOT/usr/bin
done

# Install secure binary files
for i in smbd nmbd swat smbmount smbmnt smbumount debug2html rpctorture smbtorture smbfilter
do
install -m755 -s source/bin/$i $RPM_BUILD_ROOT/usr/sbin
done

# Install level 1 man pages
# At a later date add back to line below: smbsh.1
for i in smbclient.1 smbrun.1 smbstatus.1 smbtar.1 testparm.1 testprns.1 make_smbcodepage.1 nmblookup.1 make_unicodemap.1
do
install -m644 docs/manpages/$i $RPM_BUILD_ROOT/usr/share/man/man1
done

# Install level 1 jman pages
# At a later date add back to line below: smbsh.1
for i in smbclient.1 smbrun.1 smbstatus.1 smbtar.1 testparm.1 testprns.1 make_smbcodepage.1 nmblookup.1 make_unicodemap.1
do
cp docs/ja/manpages/$i.man $RPM_BUILD_ROOT/usr/share/man/ja/man1/$i
done
chmod 644 $RPM_BUILD_ROOT/usr/share/man/ja/man1/*

# Install codepage source files
for i in 437 737 775 850 852 861 866 932 936 949 950 1251
do
install -m644 source/codepages/codepage_def.$i $RPM_BUILD_ROOT/etc/codepages/src
done
for i in 437 737 850 852 861 866 932 936 949 950 ISO8859-1 ISO8859-2 ISO8859-5 ISO8859-7 KOI8-R
do
install -m644 source/codepages/CP$i.TXT $RPM_BUILD_ROOT/etc/codepages/src
done

# Install the nsswitch library extension file
install -m755 source/nsswitch/libnss_wins.so $RPM_BUILD_ROOT/lib
ln -s $RPM_BUILD_ROOT/lib/libnss_wins.so $RPM_BUILD_ROOT/lib/libnss_wins.so.2

# Create an empty lock file to supress error messages
touch  $RPM_BUILD_ROOT/var/lock/samba/STATUS..LCK

# Install SWAT helper files
for j in . ja 
do
 for i in swat/$j/help/*.html
 do
cat $i | sed 's/@BOOKDIR@//' > $RPM_BUILD_ROOT/usr/share/$i
chmod 644 $RPM_BUILD_ROOT/usr/share/$i
 done
 for i in docs/$j/htmldocs/*.html
 do
 install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/$j/help
 done
 for i in swat/$j/images/*.gif
 do
 install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/$j/images
 done
 for i in swat/$j/include/*.html
 do
 install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/$j/include
 done
done
for i in docs/ja/htmldocs/HowToUseSamba/*.html docs/ja/htmldocs/HowToUseSamba/*.gif docs/ja/htmldocs/HowToUseSamba/*.GIF
do
install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/ja/help/HowToUseSamba
done
for j in ja_JP.SJIS
do
 for i in swat/$j/help/*.html 
 do
 cat $i | sed 's/@BOOKDIR@//' > $RPM_BUILD_ROOT/usr/share/$i
 chmod 644 $RPM_BUILD_ROOT/usr/share/$i
 done
 for i in swat/$j/images/*.gif
 do
 install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/$j/images
 done
 for i in swat/$j/include/*.html
 do
 install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/$j/include
 done
done

# This is the O'Reily Samba Book - on-line
for i in docs/htmldocs/using_samba/*.html
do
install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/using_samba
done
for i in docs/htmldocs/using_samba/figs/*.gif
do
install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/using_samba/figs
done
for i in docs/htmldocs/using_samba/gifs/*.gif
do
install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/using_samba/gifs
done

# Install the miscellany
install -m644 swat/README $RPM_BUILD_ROOT/usr/share/swat
install -m644 docs/manpages/smb.conf.5 $RPM_BUILD_ROOT/usr/share/man/man5
install -m644 docs/manpages/lmhosts.5 $RPM_BUILD_ROOT/usr/share/man/man5
install -m644 docs/manpages/smbpasswd.5 $RPM_BUILD_ROOT/usr/share/man/man5
install -m644 docs/manpages/samba.7 $RPM_BUILD_ROOT/usr/share/man/man7
install -m644 docs/manpages/smbd.8 $RPM_BUILD_ROOT/usr/share/man/man8
install -m644 docs/manpages/nmbd.8 $RPM_BUILD_ROOT/usr/share/man/man8
install -m644 docs/manpages/swat.8 $RPM_BUILD_ROOT/usr/share/man/man8
install -m644 docs/manpages/smbmnt.8 $RPM_BUILD_ROOT/usr/share/man/man8
install -m644 docs/manpages/smbmount.8 $RPM_BUILD_ROOT/usr/share/man/man8
install -m644 docs/manpages/smbpasswd.8 $RPM_BUILD_ROOT/usr/share/man/man8
install -m644 docs/manpages/smbspool.8 $RPM_BUILD_ROOT/usr/share/man/man8

install -m644 docs/ja/manpages/smb.conf.5.man $RPM_BUILD_ROOT/usr/share/man/ja/man5/smb.conf.5
install -m644 docs/ja/manpages/lmhosts.5.man $RPM_BUILD_ROOT/usr/share/man/ja/man5/lmhosts.5
install -m644 docs/ja/manpages/smbpasswd.5.man $RPM_BUILD_ROOT/usr/share/man/ja/man5/smbpasswd.5
install -m644 docs/ja/manpages/samba.7.man $RPM_BUILD_ROOT/usr/share/man/ja/man7/samba.7
install -m644 docs/ja/manpages/smbd.8.man $RPM_BUILD_ROOT/usr/share/man/ja/man8/smbd.8
install -m644 docs/ja/manpages/nmbd.8.man $RPM_BUILD_ROOT/usr/share/man/ja/man8/nmbd.8
install -m644 docs/ja/manpages/swat.8.man $RPM_BUILD_ROOT/usr/share/man/ja/man8/swat.8
install -m644 docs/ja/manpages/smbmnt.8.man $RPM_BUILD_ROOT/usr/share/man/ja/man8/smbmnt.8
install -m644 docs/ja/manpages/smbmount.8.man $RPM_BUILD_ROOT/usr/share/man/ja/man8/smbmount.8
install -m644 docs/ja/manpages/smbpasswd.8.man $RPM_BUILD_ROOT/usr/share/man/ja/man8/smbpasswd.8
install -m644 docs/ja/manpages/smbspool.8.man $RPM_BUILD_ROOT/usr/share/man/ja/man8/smbspool.8

install -m644 examples/smb.conf.default.ja $RPM_BUILD_ROOT/etc/smb.conf
install -m644 packaging/PHT/TurboLinux/smbusers $RPM_BUILD_ROOT/etc/smbusers
install -m755 packaging/PHT/TurboLinux/smbprint $RPM_BUILD_ROOT/usr/bin
install -m755 packaging/PHT/TurboLinux/findsmb $RPM_BUILD_ROOT/usr/bin
install -m755 packaging/PHT/TurboLinux/smbadduser $RPM_BUILD_ROOT/usr/bin
install -m755 packaging/PHT/TurboLinux/smb.init $RPM_BUILD_ROOT/etc/rc.d/init.d/smb
install -m755 packaging/PHT/TurboLinux/smb.init $RPM_BUILD_ROOT/usr/sbin/samba
install -m644 packaging/PHT/TurboLinux/samba.pamd $RPM_BUILD_ROOT/etc/pam.d/samba
install -m644 packaging/PHT/TurboLinux/samba.log $RPM_BUILD_ROOT/etc/logrotate.d/samba
install -m644 source/po/en.gmo $RPM_BUILD_ROOT/usr/share/locale/en/LC_MESSAGES/i18n_swat.mo
install -m644 source/po/ja.gmo $RPM_BUILD_ROOT/usr/share/locale/ja/LC_MESSAGES/i18n_swat.mo
install -m644 source/po/ja_JP.SJIS.gmo $RPM_BUILD_ROOT/usr/share/locale/ja_JP.SJIS/LC_MESSAGES/i18n_swat.mo
install -m644 source/po/sup_locale.txt $RPM_BUILD_ROOT/usr/share/swat/swat-i18n.conf
echo 127.0.0.1 localhost > $RPM_BUILD_ROOT/etc/lmhosts

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add smb
/sbin/chkconfig smb off

# Link smbmount to /sbin/mount.smb
if [ ! -f /sbin/mount.smb ]; then
	ln -s /usr/sbin/smbmount /sbin/mount.smb
fi

# Build codepage load files
for i in 437 737 850 852 861 866 932 936 949 950 1251
do
/usr/bin/make_smbcodepage c $i /etc/codepages/src/codepage_def.$i /etc/codepages/codepage.$i
done
for i in 437 737 850 852 861 866 932 936 949 950 ISO8859-1 ISO8859-2 ISO8859-5 ISO8859-7 KOI8-R
do
/usr/bin/make_unicodemap $i /etc/codepages/src/CP$i.TXT /etc/codepages/unicode_map.$i
done

# Add swat entry to /etc/services if not already there
if !( grep ^[:space:]*swat /etc/services > /dev/null ) then
	echo 'swat		901/tcp				# Add swat service used via inetd' >> /etc/services
fi

# Add swat entry to /etc/inetd.conf if needed
if !( grep ^[:space:]*swat /etc/inetd.conf > /dev/null ) then
	echo 'swat	stream	tcp	nowait.400	root	/usr/sbin/tcpd	/usr/sbin/swat' >> /etc/inetd.conf
killall -1 inetd || :
fi

# Now create the xinetd.conf file from our inetd.conf file, back up orig first.
if [ -f /etc/xinetd.conf ]; then
	mv /etc/xinetd.conf /etc/xinetd.conf.presamba
	/usr/sbin/itox --daemon_dir /usr/sbin < /etc/inetd.conf > /etc/xinetd.conf
fi

%preun
if [ $1 = 0 ] ; then
    /sbin/chkconfig --del smb

    for n in /etc/codepages/*; do
	if [ $n != /etc/codepages/src ]; then
	    rm -rf $n
	fi
    done
    # We want to remove the browse.dat and wins.dat files so they can not interfer with a new version of samba!
    if [ -e /var/lock/samba/browse.dat ]; then
	    rm -f /var/lock/samba/browse.dat
    fi
    if [ -e /var/lock/samba/wins.dat ]; then
	    rm -f /var/lock/samba/wins.dat
    fi
    if [ -e /var/lock/samba/STATUS..LCK ]; then
	    rm -f /var/lock/samba/STATUS..LCK
    fi
fi

%postun
# Only delete remnants of samba if this is the final deletion.
if [ $1 = 0 ] ; then
    if [ -x /etc/pam.d/samba ]; then
      rm -f /etc/pam.d/samba
    fi
    if [ -e /var/log/samba ]; then
      rm -rf /var/log/samba
    fi
    if [ -e /var/lock/samba ]; then
      rm -rf /var/lock/samba
    fi

    # Remove swat entries from /etc/inetd.conf and /etc/services
    cd /etc
    tmpfile=/etc/tmp.$$
    sed -e '/^[:space:]*swat.*$/d' /etc/inetd.conf > $tmpfile
    mv $tmpfile inetd.conf
    sed -e '/^[:space:]*swat.*$/d' /etc/services > $tmpfile
    mv $tmpfile services

    # Recreate xinetd.conf file from /etc/inetd.conf
    mv /etc/xinetd.conf /etc/xinetd.conf.samba
    /usr/sbin/itox --daemon_dir /usr/sbin < /etc/inetd.conf > /etc/xinetd.conf
fi
if [ -f /sbin/mount.smb ]; then
	rm -f /sbin/mount.smb
fi

%triggerpostun -- samba < samba-2.0.0
if [ $0 != 0 ]; then
    /sbin/chkconfig --add smb
fi


%files
%doc README COPYING Manifest Read-Manifest-Now RELNOTE.ja RELNOTE.en
%doc WHATSNEW.txt Roadmap
%doc docs
%doc swat/README
%doc examples
%attr(-,root,root) /usr/sbin/smbd
%attr(-,root,root) /usr/sbin/nmbd
%attr(-,root,root) /usr/sbin/swat
%attr(0750,root,root) /usr/sbin/samba
%attr(-,root,root) /usr/bin/addtosmbpass
%attr(-,root,root) /usr/bin/mksmbpasswd.sh
%attr(-,root,root) /usr/bin/smbclient
%attr(-,root,root) /usr/bin/smbspool
%attr(-,root,root) /usr/bin/rpcclient
%attr(-,root,root) /usr/bin/smb-useradd
%attr(-,root,root) /usr/bin/smb-userdel
%attr(-,root,root) /usr/bin/testparm
%attr(-,root,root) /usr/bin/testprns
%attr(-,root,root) /usr/bin/findsmb
%attr(-,root,root) /usr/bin/smbstatus
%attr(-,root,root) /usr/bin/nmblookup
%attr(-,root,root) /usr/bin/make_smbcodepage
%attr(-,root,root) /usr/bin/make_unicodemap
%attr(-,root,root) /usr/bin/make_printerdef
%attr(-,root,root) /usr/bin/smbpasswd
%attr(-,root,root) /usr/bin/smbtar
%attr(-,root,root) /usr/bin/smbprint
%attr(-,root,root) /usr/bin/smbadduser
%attr(755,root,root) /lib/libnss_wins.s*
%attr(-,root,root) /usr/share/swat/help/*
%attr(-,root,root) /usr/share/swat/images/*
%attr(-,root,root) /usr/share/swat/include/header.html
%attr(-,root,root) /usr/share/swat/include/footer.html
%attr(-,root,root) /usr/share/swat/ja/help/welcome.html
%attr(-,root,root) /usr/share/swat/ja/help/*
%attr(-,root,root) /usr/share/swat/ja/help/HowToUseSamba/*
%attr(-,root,root) /usr/share/swat/ja/images/*
%attr(-,root,root) /usr/share/swat/ja/include/header.html
%attr(-,root,root) /usr/share/swat/ja/include/footer.html
%attr(-,root,root) /usr/share/swat/ja_JP.SJIS/help/welcome.html
%attr(-,root,root) /usr/share/swat/ja_JP.SJIS/images/*
%attr(-,root,root) /usr/share/swat/ja_JP.SJIS/include/header.html
%attr(-,root,root) /usr/share/swat/ja_JP.SJIS/include/footer.html
%attr(-,root,root) /usr/share/swat/swat-i18n.conf
%attr(-,root,root) /usr/share/swat/using_samba/*
%attr(-,root,root) /usr/share/locale/en/LC_MESSAGES/i18n_swat.mo
%attr(-,root,root) /usr/share/locale/ja/LC_MESSAGES/i18n_swat.mo
%attr(-,root,root) /usr/share/locale/ja_JP.SJIS/LC_MESSAGES/i18n_swat.mo
%attr(-,root,root) %config(noreplace) /etc/lmhosts
%attr(-,root,root) %config(noreplace) /etc/smb.conf
%attr(-,root,root) %config(noreplace) /etc/smbusers
%attr(-,root,root) /etc/rc.d/init.d/smb
%attr(-,root,root) /etc/logrotate.d/samba
%attr(-,root,root) /etc/pam.d/samba
%attr(-,root,root) /etc/codepages/src/codepage_def.*
%attr(-,root,root) /etc/codepages/src/CP*
%attr(-,root,root) /usr/share/man/man1/smbstatus.1
%attr(-,root,root) /usr/share/man/man1/smbclient.1
%attr(-,root,root) /usr/share/man/man1/make_smbcodepage.1
%attr(-,root,root) /usr/share/man/man1/make_unicodemap.1
%attr(-,root,root) /usr/share/man/man1/smbrun.1
%attr(-,root,root) /usr/share/man/man1/smbtar.1
%attr(-,root,root) /usr/share/man/man1/testparm.1
%attr(-,root,root) /usr/share/man/man1/testprns.1
%attr(-,root,root) /usr/share/man/man1/nmblookup.1
%attr(-,root,root) /usr/share/man/man5/smb.conf.5
%attr(-,root,root) /usr/share/man/man5/lmhosts.5
%attr(-,root,root) /usr/share/man/man5/smbpasswd.5
%attr(-,root,root) /usr/share/man/man7/samba.7
%attr(-,root,root) /usr/share/man/man8/smbd.8
%attr(-,root,root) /usr/share/man/man8/nmbd.8
%attr(-,root,root) /usr/share/man/man8/smbpasswd.8
%attr(-,root,root) /usr/share/man/man8/swat.8
%attr(-,root,root) /usr/share/man/man8/smbspool.8
%attr(-,root,root) /usr/share/man/ja/man1/smbstatus.1
%attr(-,root,root) /usr/share/man/ja/man1/smbclient.1
%attr(-,root,root) /usr/share/man/ja/man1/make_smbcodepage.1
%attr(-,root,root) /usr/share/man/ja/man1/make_unicodemap.1
%attr(-,root,root) /usr/share/man/ja/man1/smbrun.1
%attr(-,root,root) /usr/share/man/ja/man1/smbtar.1
%attr(-,root,root) /usr/share/man/ja/man1/testparm.1
%attr(-,root,root) /usr/share/man/ja/man1/testprns.1
%attr(-,root,root) /usr/share/man/ja/man1/nmblookup.1
%attr(-,root,root) /usr/share/man/ja/man5/smb.conf.5
%attr(-,root,root) /usr/share/man/ja/man5/lmhosts.5
%attr(-,root,root) /usr/share/man/ja/man5/smbpasswd.5
%attr(-,root,root) /usr/share/man/ja/man7/samba.7
%attr(-,root,root) /usr/share/man/ja/man8/smbd.8
%attr(-,root,root) /usr/share/man/ja/man8/nmbd.8
%attr(-,root,root) /usr/share/man/ja/man8/smbpasswd.8
%attr(-,root,root) /usr/share/man/ja/man8/swat.8
%attr(-,root,root) /usr/share/man/ja/man8/smbspool.8
%attr(-,root,nobody) %dir /home/samba
%attr(-,root,root) %dir /etc/codepages
%attr(-,root,root) %dir /etc/codepages/src
%attr(-,root,root) %dir /var/lock/samba
%attr(-,root,root) %dir /var/log/samba
%attr(1777,root,root) %dir /var/spool/samba

%files -n smbfs
%attr(-,root,root) /usr/sbin/smbmount
%attr(-,root,root) /usr/sbin/smbumount
%attr(-,root,root) /usr/sbin/smbmnt
#%attr(-,root,root) /sbin/mount.smb
%attr(-,root,root) /usr/share/man/man8/smbmnt.8
%attr(-,root,root) /usr/share/man/man8/smbmount.8
%attr(-,root,root) /usr/share/man/ja/man8/smbmnt.8
%attr(-,root,root) /usr/share/man/ja/man8/smbmount.8

%files debugtools
%attr(-,root,root) /usr/sbin/smbtorture
%attr(-,root,root) /usr/sbin/rpctorture
%attr(-,root,root) /usr/sbin/smbfilter
%attr(-,root,root) /usr/sbin/debug2html
