Summary: Samba SMB server.
Summary(ja): Samba
Name: samba
%define en_ver 2.0.10
%define ja_ver 1.2
Version: %{en_ver}_ja_%{ja_ver}
Release: 1
Copyright: GNU GPL Version 2
Group: System Environment/Daemons
Source: ftp://ftp.samba.gr.jp/pub/samba-jp/samba-%{en_ver}-ja/samba-%{en_ver}-ja-%{ja_ver}.tar.gz
Source1: samba.log
Source2: smb.conf
Source3: samba-jp.tar.gz
Packager: TAKAHASHI Motonobu <monyo@samba.gr.jp>
Patch: samba-makefilepath.patch
Patch1: smbw.patch
Patch2: samba-glibc21.patch
Patch3: samba-2.0.3-fixinit.patch
Patch4: samba-nsl.patch
Patch5: samba-2.0.5a-gawk.patch
Patch6: samba-smbprint.patch
Requires: pam >= 0.64, samba-common = %{version}, gettext >= 0.10, tcp_wrappers
Buildroot: %{_tmppath}/%{name}-root
Prereq: /sbin/chkconfig /bin/mktemp /usr/bin/killall 
Prereq: fileutils sed gawk grep


%description
Samba provides an SMB server which can be used to provide network
services to SMB (sometimes called "Lan Manager") clients, including
various versions of MS Windows, OS/2, and other Linux machines. Samba
uses NetBIOS over TCP/IP (NetBT) protocols and does NOT need NetBEUI
(Microsoft Raw NetBIOS frame) protocol.

Samba-2 features an almost working NT Domain Control capability and
includes the new SWAT (Samba Web Administration Tool) that allows
samba's smb.conf file to be remotely managed using your favourite web
browser. For the time being this is being enabled on TCP port 901 via
inetd.

Please refer to the WHATSNEW.txt document for fixup information.  This
binary release includes encrypted password support.  Please read the
smb.conf file and ENCRYPTION.txt in the docs directory for
implementation details.

NOTE: Red Hat Linux 5.X and Vine Linux Uses PAM which has 
integrated support for Shadow passwords. Do NOT recompile with
the SHADOW_PWD option enabled. Red Hat Linux has built in 
support for quotas in PAM.


NOTE2:
This SWAT and man translation is made by Japanese Samba user
association. But the Samba itself is just same as the orignal and
isn't  still extended by them.
You can't use Japanese in share label name. Notice that
it will cause character turning, please.

%description -l ja
Samba  Microsoft Windows 3.1/95/98/NT/2000  LAN Manager OS/2 
¾ Linux ޥޤ SMB/CIFS 饤Ȥ˥ե붦ͭ
ץȶͭӥ󶡤ޤ
Samba NetBIOS over TCP/IP (NBT) ץȥѤΤǡ
NetBEUI(Microsoft Raw NetBIOS frame) ץȥפǤ

Samba 2.0 Ǥϡ Windows 95/98 饤ȤФ
󥵡еǽ䡢Web֥饦ͳ Samba smb.conf ե
Υ⡼ȴ¸ġǤSWAT (Samba Web
Administration Tool) 󶡤褦ˤʤޤ SWAT
 inetd ͳ TCP ݡ 901 (ǥե)Ѥޤ

 WHATNEW.TXT ʤɤ򻲾ȤƤΥХʥ꡼
ϰŹ沽ѥɤޤǤޤξܺ٤˴ؤơsmb.confե
ޤ docsǥ쥯ȥˤENCRYPTION.txt򻲾ȤƤ

NOTE: RedHat Linux 5.xVine Linux ɥѥɥݡȤ
ƤPAMѤƤޤSHADOW_PWDץͭˤƺƥ
ѥ뤷ʤǤ


%package client
Summary: Samba (SMB) client programs.
Summary(ja): Samba (SMB) 饤ȥץ
Group: Applications/System
Requires: samba-common = %{version}
Obsoletes: smbfs

%description client
The samba-client package provides some SMB clients to complement the
built-in SMB filesystem in Linux. These clients allow access of SMB
shares and printing to SMB printers.

%description client -l ja
Samba-client  Linux ͥ뤬ݡȤƤ
SMB ե륷ƥൡǽ SMB 饤Ȥ󶡤ޤ
 SMB ͭΥ SMB ץ󥿤ؤΰ¸ޤ

%package common
Summary: Files used by both Samba servers and clients.
Summary(ja): SambaСȥ饤Ȥξ˻Ѥե
Group: Applications/System

%description common
Samba-common provides files necessary for both the server and client
packages of Samba.

%description common -l ja
Samba-common  SambaΥФȥ饤ȤξΥѥå
Ѥ붦Ūʥե󶡤ޤ

%prep
%setup -q -a 3 -n samba-%{en_ver}-ja-%{ja_ver}
%patch -p1 -b .makefile
%patch1 -p1 -b .smbw
%patch2 -p1 -b .glibc21
%patch3 -p1 -b .fixinit
%patch4 -p1 -b .nsl
%patch5 -p1 -b .gawk
%patch6 -p1 -b .smbprint

%build
cd source
autoconf
CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=/usr --libdir=/etc \
  --with-lockdir=/var/lock/samba --with-privatedir=/etc \
  --with-swatdir=/usr/share/swat --with-sambabook=/usr/share/swat/using_samba \
  --with-swat-langfile=/usr/share/swat/swat-i18n.conf \
  --with-automount --with-smbmount \
  --with-pam --with-syslog --with-profile --with-netatalk \
  --with-quotas --with-utmp --with-i18n-swat
  
make CFLAGS="$RPM_OPT_FLAGS" all

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT/etc/codepages/src
mkdir -p $RPM_BUILD_ROOT/etc/{logrotate.d,pam.d}
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/usr/{bin,sbin}
mkdir -p $RPM_BUILD_ROOT/usr/share/swat/{images,help,include}
mkdir -p $RPM_BUILD_ROOT/usr/share/swat/ja/{images,help,include}
mkdir -p $RPM_BUILD_ROOT/usr/share/locale/en/LC_MESSAGES
mkdir -p $RPM_BUILD_ROOT/usr/share/locale/ja/LC_MESSAGES
mkdir -p $RPM_BUILD_ROOT/usr/share/swat/using_samba/{figs,gifs}
mkdir -p $RPM_BUILD_ROOT/usr/man/{man1,man5,man7,man8}
mkdir -p $RPM_BUILD_ROOT/usr/man/ja/{man1,man5,man7,man8}
mkdir -p $RPM_BUILD_ROOT/var/lock/samba
mkdir -p $RPM_BUILD_ROOT/var/log/samba
mkdir -p $RPM_BUILD_ROOT/var/spool/samba

for i in nmblookup smbclient smbspool smbpasswd smbstatus testparm testprns \
    smbmount smbmnt smbumount make_smbcodepage make_printerdef rpcclient make_unicodemap make_nftable
do
  install -m755 -s source/bin/$i $RPM_BUILD_ROOT/usr/bin
done

for i in addtosmbpass mksmbpasswd.sh smbtar convert_smbpasswd
do
  install -m755 source/script/$i $RPM_BUILD_ROOT/usr/bin
done

for i in smbd nmbd swat
do
  install -m755 -s source/bin/$i $RPM_BUILD_ROOT/usr/sbin
done

for i in smbclient.1 smbstatus.1 smbtar.1 testparm.1 testprns.1 make_smbcodepage.1 nmblookup.1 make_unicodemap.1
do
  install -m644 docs/manpages/$i $RPM_BUILD_ROOT/usr/man/man1
done

for i in 437 737 775 850 852 861 866 932 936 949 950 1251
do
  install -m644 source/codepages/codepage_def.$i $RPM_BUILD_ROOT/etc/codepages/src
done
for i in 437 737 850 852 861 866 932 936 949 950 ISO8859-1 ISO8859-2 ISO8859-5 \
      ISO8859-7 KOI8-R
do
install -m644 source/codepages/CP$i.TXT $RPM_BUILD_ROOT/etc/codepages/src
done
install -m644 source/codepages/NormalizationTest.txt $RPM_BUILD_ROOT/etc/codepages/src
install -m644 source/codepages/NFD2MacOSX.txt $RPM_BUILD_ROOT/etc/codepages/src


# Install SWAT helper files
for j in . ja
do
 for i in swat/$j/help/*.html docs/$j/htmldocs/*.html
 do
   install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/$j/help
 done
 for i in swat/$j/images/*.gif
 do
   install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/$j/images
 done
 for i in swat/$j/include/*.html
 do
   install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/$j/include
 done
done

for i in docs/htmldocs/using_samba/*.html; do
  install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/using_samba
done
for i in docs/htmldocs/using_samba/figs/*.gif; do
  install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/using_samba/figs
done
for i in docs/htmldocs/using_samba/gifs/*.gif; do
  install -m644 $i $RPM_BUILD_ROOT/usr/share/swat/using_samba/gifs
done

# Install other stuff
install -m644 swat/README $RPM_BUILD_ROOT/usr/share/swat
install -m644 docs/manpages/smb.conf.5 $RPM_BUILD_ROOT/usr/man/man5
install -m644 docs/manpages/lmhosts.5 $RPM_BUILD_ROOT/usr/man/man5
install -m644 docs/manpages/smbpasswd.5 $RPM_BUILD_ROOT/usr/man/man5
install -m644 docs/manpages/samba.7 $RPM_BUILD_ROOT/usr/man/man7
install -m644 docs/manpages/smbmnt.8 $RPM_BUILD_ROOT/usr/man/man8
install -m644 docs/manpages/smbmount.8 $RPM_BUILD_ROOT/usr/man/man8
install -m644 docs/manpages/smbumount.8 $RPM_BUILD_ROOT/usr/man/man8
install -m644 docs/manpages/smbd.8 $RPM_BUILD_ROOT/usr/man/man8
install -m644 docs/manpages/nmbd.8 $RPM_BUILD_ROOT/usr/man/man8
install -m644 docs/manpages/swat.8 $RPM_BUILD_ROOT/usr/man/man8
install -m644 docs/manpages/smbpasswd.8 $RPM_BUILD_ROOT/usr/man/man8
install -m644 docs/manpages/smbspool.8 $RPM_BUILD_ROOT/usr/man/man8
install -m644 %{SOURCE2} $RPM_BUILD_ROOT/etc/smb.conf
install -m644 packaging/RedHat/smbusers $RPM_BUILD_ROOT/etc/smbusers
install -m755 packaging/RedHat/smbprint $RPM_BUILD_ROOT/usr/bin
install -m755 packaging/RedHat/smbadduser $RPM_BUILD_ROOT/usr/bin
install -m755 packaging/RedHat/findsmb $RPM_BUILD_ROOT/usr/bin
install -m755 packaging/RedHat/smb.init $RPM_BUILD_ROOT/etc/rc.d/init.d/smb
install -m755 packaging/RedHat/smb.init $RPM_BUILD_ROOT/usr/sbin/samba
install -m644 packaging/RedHat/samba.pamd $RPM_BUILD_ROOT/etc/pam.d/samba
install -m644 $RPM_SOURCE_DIR/samba.log $RPM_BUILD_ROOT/etc/logrotate.d/samba
install -m644 source/po/en.gmo $RPM_BUILD_ROOT/usr/share/locale/en/LC_MESSAGES/i18n_swat.mo
install -m644 source/po/ja.gmo $RPM_BUILD_ROOT/usr/share/locale/ja/LC_MESSAGES/i18n_swat.mo
ln -s /usr/bin/smbmount $RPM_BUILD_ROOT/sbin/mount.smb
ln -s /usr/bin/smbmount $RPM_BUILD_ROOT/sbin/mount.smbfs
echo 127.0.0.1 localhost > $RPM_BUILD_ROOT/etc/lmhosts

#
# install samba_jp misc.
#
(cd docs/ja/manpages; sh ./install-man.sh $RPM_BUILD_ROOT/usr/man/ja/ cat)

%clean
rm -rf $RPM_BUILD_ROOT

%post common
# Build codepage load files
for i in 437 737 850 852 861 866 932 936 949 950 1251; do
  /usr/bin/make_smbcodepage c $i /etc/codepages/src/codepage_def.$i /etc/codepages/codepage.$i
done
for i in 437 737 850 852 861 866 932 936 949 950 ISO8859-1 ISO8859-2 ISO8859-5 ISO8859-7 KOI8-R; do
  /usr/bin/make_unicodemap $i /etc/codepages/src/CP$i.TXT /etc/codepages/unicode_map.$i
  /usr/bin/make_nftable $i /etc/codepages/src/NormalizationTest.txt /etc/codepages/src/NFD2MacOSX.txt /etc/codepages/src/CP$i.TXT /etc/codepages/nftable.$i

done

%post
tcpdconf () {
    while [ $# != "0" ]; do
	case $1 in
	    -a|--allow) shift; ALLOW="$1";;
	    -d|--deny) shift; DENY="$1";;
	    -e|--erase|--delete) MODE="erase";;
	    -*) echo "invalid option" $1; return;;
	    *)SERVICE=$1;;
	esac
	shift
    done

    /usr/bin/awk -vallow="$ALLOW" -vdeny="$DENY" -vmode="$MODE" -vservice=$SERVICE '
func grep(key, file,  line, ret) {
    #local line, ret;
    ret = FALSE;
    while (1) {
	line = EOF;
	getline line < file;
	if (line == EOF) break;
	if (line !~ /^#/ && line ~ key) {
	    ret = TRUE; break;
	}
    }
    close(file);
    return ret;
	
}
func output_hosts_access(service, list, file, line, key, done, tmpfile) {
    #local line, key, done, tmpfile
    key = "^[ \t]*[#]*[ \t]*" service;
    done = FALSE;

    if (grep("^[ \t]*ALL[: \t]", file) || (list && (grep(key, file))))
	    return;
    "echo /etc/rpmtmp.$$" | getline tmp;
    tmpfile = tmp;
    system ("/bin/rm -f " tmpfile);   /* clean file */
    system ("/bin/touch " tmpfile);
    while (TRUE) {
	line = EOF;
	getline line < file;
	if (line == EOF) break;
	if (line ~ key && !done) {
	    if (line ~ /\\$/)
		done = PROGRESS;
	    else
		done = TRUE;
	    if (list)
		printf(service ": " list "\n") >> tmpfile;
	} else {
	    if (done == PROGRESS) {
		if (line !~ /\\$/)
		    done = TRUE;
	    } else
		print line >> tmpfile;
	}
    }
    if (!done && list)
	printf(service ": " list "\n") >> tmpfile;
    close(file);
    close(tmpfile);
    system("/bin/mv "    file " " file ".rpmsave");
    system("/bin/mv " tmpfile " " file);
}
BEGIN {
    TRUE = 1;
    PROGRESS = -1;
    EOF = "@@@EOF@@@"
    if (!service) {
	printf("error: service name is null.\n");
	exit (1);
    }
    if (mode == "erase") {
	output_hosts_access(service, NULL, "/etc/hosts.allow");
	output_hosts_access(service, NULL, "/etc/hosts.deny");
    } else {
	if (allow)
	    output_hosts_access(service, allow, "/etc/hosts.allow");
	if (deny)
	    output_hosts_access(service, deny, "/etc/hosts.deny");
    }
}'
}

/sbin/chkconfig --add smb

# Add swat entry to /etc/services if needed
if !( grep ^[:space:]*swat /etc/services > /dev/null ) then
	echo 'swat		901/tcp				# Add swat service used via inetd' >> /etc/services
fi

# Add swat entry to /etc/inetd.conf if needed
if !( grep swat /etc/inetd.conf > /dev/null 2>&1 ) then
        echo 'swat      stream  tcp     nowait.400      root /usr/sbin/swat swat' >> /etc/inetd.conf
fi

# Set tcpd_wrapper
SWAT_ALLOW_HOST="localhost"
[ -f /bin/hostname ] && SWAT_ALLOW_HOST="${SWAT_ALLOW_HOST} `/bin/hostname -i`"
tcpdconf --allow "${SWAT_ALLOW_HOST}" --deny ALL swat

killall -HUP inetd >/dev/null 2>&1 || :

%preun
if [ $1 = 0 ] ; then
    /sbin/chkconfig --del smb

    if [ -e /var/lock/samba/browse.dat ]; then
            rm -f /var/lock/samba/browse.dat
    fi
    if [ -e /var/lock/samba/wins.dat ]; then
            rm -f /var/lock/samba/wins.dat
    fi
    if [ -d /var/log/samba ]; then
      rm -rf /var/log/samba/*
    fi
    if [ -d /var/lock/samba ]; then
      rm -rf /var/lock/samba/*
    fi
fi

%preun common
if [ $1 = 0 ] ; then
    for n in /etc/codepages/*; do
	if [ "$n" != "/etc/codepages/src" ]; then
	    rm -rf $n
	fi
    done
fi


%postun
tcpdconf () {
    while [ $# != "0" ]; do
	case $1 in
	    -a|--allow) shift; ALLOW="$1";;
	    -d|--deny) shift; DENY="$1";;
	    -e|--erase|--delete) MODE="erase";;
	    -*) echo "invalid option" $1; return;;
	    *)SERVICE=$1;;
	esac
	shift
    done

    /usr/bin/awk -vallow="$ALLOW" -vdeny="$DENY" -vmode="$MODE" -vservice=$SERVICE '
func grep(key, file,  line, ret) {
    #local line, ret;
    ret = FALSE;
    while (1) {
	line = EOF;
	getline line < file;
	if (line == EOF) break;
	if (line !~ /^#/ && line ~ key) {
	    ret = TRUE; break;
	}
    }
    close(file);
    return ret;
	
}
func output_hosts_access(service, list, file, line, key, done, tmpfile) {
    #local line, key, done, tmpfile
    key = "^[ \t]*[#]*[ \t]*" service;
    done = FALSE;

    if (grep("^[ \t]*ALL[: \t]", file) || (list && (grep(key, file))))
	    return;
    "echo /etc/rpmtmp.$$" | getline tmp;
    tmpfile = tmp;
    system ("/bin/rm -f " tmpfile);   /* clean file */
    system ("/bin/touch " tmpfile);
    while (TRUE) {
	line = EOF;
	getline line < file;
	if (line == EOF) break;
	if (line ~ key && !done) {
	    if (line ~ /\\$/)
		done = PROGRESS;
	    else
		done = TRUE;
	    if (list)
		printf(service ": " list "\n") >> tmpfile;
	} else {
	    if (done == PROGRESS) {
		if (line !~ /\\$/)
		    done = TRUE;
	    } else
		print line >> tmpfile;
	}
    }
    if (!done && list)
	printf(service ": " list "\n") >> tmpfile;
    close(file);
    close(tmpfile);
    system("/bin/mv "    file " " file ".rpmsave");
    system("/bin/mv " tmpfile " " file);
}
BEGIN {
    TRUE = 1;
    PROGRESS = -1;
    EOF = "@@@EOF@@@"
    if (!service) {
	printf("error: service name is null.\n");
	exit (1);
    }
    if (mode == "erase") {
	output_hosts_access(service, NULL, "/etc/hosts.allow");
	output_hosts_access(service, NULL, "/etc/hosts.deny");
    } else {
	if (allow)
	    output_hosts_access(service, allow, "/etc/hosts.allow");
	if (deny)
	    output_hosts_access(service, deny, "/etc/hosts.deny");
    }
}'
}

if [ $1 = 0 ] ; then
    # Remove swat entries from /etc/inetd.conf and /etc/services
    tmpfile="`/bin/mktemp /etc/tmp.XXXXXX`"
    sed -e '/^[:space:]*swat.*$/d' /etc/inetd.conf > $tmpfile
    cat $tmpfile  > /etc/inetd.conf
    sed -e '/^[:space:]*swat.*$/d' /etc/services > $tmpfile
    cat $tmpfile > /etc/services
    rm -f $tmpfile
    tcpdconf --delete swat
    killall -HUP inetd >/dev/null 2>&1 || :
fi


%triggerpostun -- samba < 1.9.18p7
if [ $1 != 0 ]; then
    /sbin/chkconfig --add smb
fi

%triggerpostun -- samba < 2.0.5a-3
if [ $1 != 0 ]; then
    [ ! -d /var/lock/samba ] && mkdir -m 0755 /var/lock/samba
    [ ! -d /var/spool/samba ] && mkdir -m 1777 /var/spool/samba
    chmod 644 /etc/services /etc/inetd.conf
fi

%files
%defattr(-,root,root)
%doc README COPYING Manifest Read-Manifest-Now
%doc WHATSNEW.txt Roadmap
%doc RELNOTE.en RELNOTE.ja ANNOUNCE.ja Changelog.ja
%doc README-smbmount
%doc docs
%doc swat/README
%doc examples
/usr/sbin/smbd
/usr/sbin/nmbd
/usr/sbin/swat
/usr/bin/addtosmbpass
/usr/bin/mksmbpasswd.sh
/usr/bin/smbstatus
/usr/bin/smbpasswd
/usr/bin/convert_smbpasswd
/usr/bin/smbadduser
/usr/bin/smbspool
/usr/bin/rpcclient
/usr/share/swat
%config(noreplace) /etc/smbusers
%config /usr/sbin/samba
%config /etc/rc.d/init.d/smb
%config /etc/logrotate.d/samba
%config /etc/pam.d/samba
/usr/man/man1/smbstatus.1*
/usr/man/man5/smbpasswd.5*
/usr/man/man7/samba.7*
/usr/man/man8/smbd.8*
/usr/man/man8/nmbd.8*
/usr/man/man8/smbpasswd.8*
/usr/man/man8/smbspool.8*
/usr/man/man8/swat.8*
/usr/man/ja/man1/smbstatus.1*
/usr/man/ja/man5/smbpasswd.5*
/usr/man/ja/man7/samba.7*
/usr/man/ja/man8/smbd.8*
/usr/man/ja/man8/nmbd.8*
/usr/man/ja/man8/smbpasswd.8*
/usr/man/ja/man8/smbspool.8*
/usr/man/ja/man8/swat.8*
/usr/share/locale/en/LC_MESSAGES/i18n_swat.mo
/usr/share/locale/ja/LC_MESSAGES/i18n_swat.mo

%dir /var/lock/samba
%attr(0700,root,root)   %dir /var/log/samba
%attr(1777,root,root)	%dir /var/spool/samba

%files client
%defattr(-,root,root)
/sbin/mount.smb
/sbin/mount.smbfs
/usr/bin/smbmount
/usr/bin/smbmnt
/usr/bin/smbumount
/usr/man/man8/smbmnt.8*
/usr/man/man8/smbmount.8*
#/usr/man/man8/smbumount.8*
/usr/man/ja/man8/smbmnt.8*
/usr/man/ja/man8/smbmount.8*
#/usr/man/ja/man8/smbumount.8*
/usr/bin/nmblookup
/usr/bin/findsmb
/usr/bin/smbclient
/usr/bin/smbprint
/usr/bin/smbtar
#/usr/man/man1/smbrun.1
/usr/man/man1/smbtar.1*
/usr/man/man1/smbclient.1*
/usr/man/man1/nmblookup.1*
/usr/man/ja/man1/smbtar.1*
/usr/man/ja/man1/smbclient.1*
/usr/man/ja/man1/nmblookup.1*

%files common
%defattr(-,root,root)
/usr/bin/make_nftable
/usr/bin/make_smbcodepage
/usr/bin/make_unicodemap
/usr/bin/testparm
/usr/bin/testprns
/usr/bin/make_printerdef
%config(noreplace) /etc/smb.conf
%config(noreplace) /etc/lmhosts
%dir /etc/codepages
%dir /etc/codepages/src
%config /etc/codepages/src/codepage_def.437
%config /etc/codepages/src/codepage_def.737
%config /etc/codepages/src/codepage_def.775
%config /etc/codepages/src/codepage_def.850
%config /etc/codepages/src/codepage_def.852
%config /etc/codepages/src/codepage_def.861
%config /etc/codepages/src/codepage_def.866
%config /etc/codepages/src/codepage_def.932
%config /etc/codepages/src/codepage_def.936
%config /etc/codepages/src/codepage_def.949
%config /etc/codepages/src/codepage_def.950
%config /etc/codepages/src/codepage_def.1251
%config /etc/codepages/src/CP437.TXT
%config /etc/codepages/src/CP737.TXT
%config /etc/codepages/src/CP850.TXT
%config /etc/codepages/src/CP852.TXT
%config /etc/codepages/src/CP861.TXT
%config /etc/codepages/src/CP866.TXT
%config /etc/codepages/src/CP932.TXT
%config /etc/codepages/src/CP936.TXT
%config /etc/codepages/src/CP949.TXT
%config /etc/codepages/src/CP950.TXT
%config /etc/codepages/src/CPISO8859-1.TXT
%config /etc/codepages/src/CPISO8859-2.TXT
%config /etc/codepages/src/CPISO8859-5.TXT
%config /etc/codepages/src/CPISO8859-7.TXT
%config /etc/codepages/src/CPKOI8-R.TXT
%config /etc/codepages/src/NFD2MacOSX.txt
%config /etc/codepages/src/NormalizationTest.txt
/usr/man/man1/make_smbcodepage.1*
/usr/man/man1/make_unicodemap.1*
/usr/man/man1/testparm.1*
/usr/man/man1/testprns.1*
/usr/man/man5/smb.conf.5*
/usr/man/man5/lmhosts.5*
/usr/man/ja/man1/make_smbcodepage.1*
/usr/man/ja/man1/make_unicodemap.1*
/usr/man/ja/man1/testparm.1*
/usr/man/ja/man1/testprns.1*
/usr/man/ja/man5/lmhosts.5*
/usr/man/ja/man5/smb.conf.5*

%changelog
* Tue Sep 19 2000 Jun Nishii <jun@vinelinux.org>
- 2.0.7_ja_1.3-0vl1

* Tue Sep 12 2000 MATSUBAYASHI 'Shaolin' Kohji <shaolin@rhythmaning.org>
- 2.0.7_ja_1.2.1-0vl2
- fixed missing Changelog.ja (was Chagelog.ja)

* Tue Sep 12 2000 Jun Nishii <jun@vinelinux.org>
- updated to 2.0.7-ja-1.2.1

* Wed Jul 19 2000 Yasuyuki Furukawa <furukawa@vinelinux.org>
- updated to 2.0.7-ja-1.2

* Tue Jul 11 2000 Yasuyuki Furukawa <furukawa@vinelinux.org>
- added some Japanese documents to %doc

* Mon Jul 10 2000 Yasuyuki Furukawa <furukawa@vinelinux.org>
- updated to 2.0.7-ja-1.0

* Mon May 29 2000 Yasuyuki Furukawa <furukawa@vinelinux.org>
- updated to 2.0.7-ja-0.99

* Mon May 29 2000 Yasuyuki Furukawa <furukawa@vinelinux.org>
- added rpccilent
- modified tcpdconf for stability.

* Fri May 26 2000 Yasuyuki Furukawa <furukawa@vinelinux.org>
- first test release for Vine based on RH6.2 spec file.
- activated swat in default for only localhost.

* Fri Feb 25 2000 Bill Nottingham <notting@redhat.com>
- fix trigger, again.

* Mon Feb  7 2000 Bill Nottingham <notting@redhat.com>
- fix trigger.

* Fri Feb  4 2000 Bill Nottingham <notting@redhat.com>
- turn on quota support

* Mon Jan 31 2000 Cristian Gafton <gafton@redhat.com>
- rebuild to fox dependencies
- man pages are compressed

* Fri Jan 21 2000 Bill Nottingham <notting@redhat.com>
- munge post scripts slightly

* Wed Jan 19 2000 Bill Nottingham <notting@redhat.com>
- turn on mmap again. Wheee.
- ship smbmount on alpha

* Mon Dec  6 1999 Bill Nottingham <notting@redhat.com>
- turn off mmap. ;)

* Wed Dec  1 1999 Bill Nottingham <notting@redhat.com>
- change /var/log/samba to 0700
- turn on mmap support

* Thu Nov 11 1999 Bill Nottingham <notting@redhat.com>
- update to 2.0.6

* Fri Oct 29 1999 Bill Nottingham <notting@redhat.com>
- add a %defattr for -common

* Tue Oct  5 1999 Bill Nottingham <notting@redhat.com>
- shift some files into -client
- remove /home/samba from package.

* Tue Sep 28 1999 Bill Nottingham <notting@redhat.com>
- initscript oopsie. killproc <name> -HUP, not other way around.

* Sat Sep 26 1999 Bill Nottingham <notting@redhat.com>
- script cleanups. Again.

* Wed Sep 22 1999 Bill Nottingham <notting@redhat.com>
- add a patch to fix dropped reconnection attempts

* Mon Sep  6 1999 Jeff Johnson <jbj@redhat.com>
- use cp rather than mv to preserve /etc/services perms (#4938 et al).
- use mktemp to generate /etc/tmp.XXXXXX file name.
- add prereqs on sed/mktemp/killall (need to move killall to /bin).
- fix trigger syntax (i.e. "samba < 1.9.18p7" not "samba < samba-1.9.18p7")

* Mon Aug 30 1999 Bill Nottingham <notting@redhat.com>
- sed "s|nawk|gawk|" /usr/bin/convert_smbpasswd

* Sat Aug 21 1999 Bill Nottingham <notting@redhat.com>
- fix typo in mount.smb

* Fri Aug 20 1999 Bill Nottingham <notting@redhat.com>
- add a %trigger to work around (sort of) broken scripts in
  previous releases

* Mon Aug 16 1999 Bill Nottingham <notting@redhat.com>
- initscript munging

* Mon Aug  9 1999 Bill Nottingham <notting@redhat.com>
- add domain parsing to mount.smb

* Fri Aug  6 1999 Bill Nottingham <notting@redhat.com>
- add a -common package, shuffle files around.

* Fri Jul 23 1999 Bill Nottingham <notting@redhat.com>
- add a chmod in %postun so /etc/services & inetd.conf don't become unreadable

* Wed Jul 21 1999 Bill Nottingham <notting@redhat.com>
- update to 2.0.5
- fix mount.smb - smbmount options changed again.........
- fix postun. oops.
- update some stuff from the samba team's spec file.

* Fri Jun 18 1999 Bill Nottingham <notting@redhat.com>
- split off clients into separate package
- don't run samba by default

* Mon Jun 14 1999 Bill Nottingham <notting@redhat.com>
- fix one problem with mount.smb script
- fix smbpasswd on sparc with a really ugly kludge

* Thu Jun 10 1999 Dale Lovelace <dale@redhat.com>
- fixed logrotate script

* Tue May 25 1999 Bill Nottingham <notting@redhat.com>
- turn of 64-bit locking on 32-bit platforms

* Thu May 20 1999 Bill Nottingham <notting@redhat.com>
- so many releases, so little time
- explicitly uncomment 'printing = bsd' in sample config

* Tue May 18 1999 Bill Nottingham <notting@redhat.com>
- update to 2.0.4a
- fix mount.smb arg ordering

* Fri Apr 16 1999 Bill Nottingham <notting@redhat.com>
- go back to stop/start for restart (-HUP didn't work in testing)

* Fri Mar 26 1999 Bill Nottingham <notting@redhat.com>
- add a mount.smb to make smb mounting a little easier.
- smb filesystems apparently don't work on alpha. Oops.

* Thu Mar 25 1999 Bill Nottingham <notting@redhat.com>
- always create codepages

* Tue Mar 23 1999 Bill Nottingham <notting@redhat.com>
- logrotate changes

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 3)

* Fri Mar 19 1999 Preston Brown <pbrown@redhat.com>
- updated init script to use graceful restart (not stop/start)

* Tue Mar  9 1999 Bill Nottingham <notting@redhat.com>
- update to 2.0.3

* Thu Feb 18 1999 Bill Nottingham <notting@redhat.com>
- update to 2.0.2

* Mon Feb 15 1999 Bill Nottingham <notting@redhat.com>
- swat swat

* Tue Feb  9 1999 Bill Nottingham <notting@redhat.com>
- fix bash2 breakage in post script

* Fri Feb  5 1999 Bill Nottingham <notting@redhat.com>
- update to 2.0.0

* Mon Oct 12 1998 Cristian Gafton <gafton@redhat.com>
- make sure all binaries are stripped

* Thu Sep 17 1998 Jeff Johnson <jbj@redhat.com>
- update to 1.9.18p10.
- fix %triggerpostun.

* Tue Jul 07 1998 Erik Troan <ewt@redhat.com>
- updated postun triggerscript to check $0
- clear /etc/codepages from %preun instead of %postun

* Mon Jun 08 1998 Erik Troan <ewt@redhat.com>
- made the %postun script a tad less agressive; no reason to remove
  the logs or lock file (after all, if the lock file is still there,
  samba is still running)
- the %postun and %preun should only exectute if this is the final
  removal
- migrated %triggerpostun from Red Hat's samba package to work around
  packaging problems in some Red Hat samba releases

* Sun Apr 26 1998 John H Terpstra <jht@samba.anu.edu.au>
- minor tidy up in preparation for release of 1.9.18p5
- added findsmb utility from SGI package

* Wed Mar 18 1998 John H Terpstra <jht@samba.anu.edu.au>
- Updated version and codepage info.
- Release to test name resolve order

* Sat Jan 24 1998 John H Terpstra <jht@samba.anu.edu.au>
- Many optimisations (some suggested by Manoj Kasichainula <manojk@io.com>
- Use of chkconfig in place of individual symlinks to /etc/rc.d/init/smb
- Compounded make line
- Updated smb.init restart mechanism
- Use compound mkdir -p line instead of individual calls to mkdir
- Fixed smb.conf file path for log files
- Fixed smb.conf file path for incoming smb print spool directory
- Added a number of options to smb.conf file
- Added smbadduser command (missed from all previous RPMs) - Doooh!
- Added smbuser file and smb.conf file updates for username map

