#!/bin/sh
#
# Copyright (C) TAKAHASHI Motonobu 2001
# Copyright (C) Shirish A Kalele 2000
#
# Builds a Samba package from the samba distribution. 
# By default, the package will be built to install samba in /usr/local
# Change the INSTALL_BASE variable to change this: will modify the pkginfo 
# and samba.server files to point to the new INSTALL_BASE
#
PATH=/usr/ccs/bin:/opt/sfw/bin:${PATH}
export PATH

add_dynamic_entries() 
{
  cd $TMP_INSTDIR; 
 find . -type f -exec printf "f none /%s=$TMP_INSTDIR/%s ? root other \n" {} {} \;
 find usr/local/samba/* -type d -exec printf "d none /%s=$TMP_INSTDIR/%s ? root other \n" {} {} \;
}

# main()

DISTR_BASE=""
INSTALL_BASE=/usr/local
TMP_INSTDIR=/tmp/build.$$

if [ $# = 0 ]; then
	# Try to guess the distribution base..
	CURR_DIR=`pwd`
	DISTR_BASE=`echo $CURR_DIR | sed 's|\(.*\)/packaging.*|\1|'`
	echo "Assuming Samba build tree rooted at $DISTR_BASE.."
else
	DISTR_BASE=$1
fi

#
if [ ! -d $DISTR_BASE ]; then
	echo "Source build directory $DISTR_BASE does not exist."
	exit 1
fi

# cleanup and setup Build Dir
if [ ! -d $TMP_INSTDIR ]; then
    rm -f $TMP_INSTDIR
    mkdir $TMP_INSTDIR
fi
rm -rf $TMP_INSTDIR/*
mkdir -p $TMP_INSTDIR/var/log
mkdir -p $TMP_INSTDIR/$INSTALL_BASE/samba

# make
(
cd $DISTR_BASE/source;
./configure --prefix=$INSTALL_BASE/samba --localstatedir=/var/log/samba --with-automount --with-pam --with-syslog --with-profile --with-netatalk --with-quotas --with-utmp --with-i18n-swat;
make;

# make install into Build Dir
make prefix=$TMP_INSTDIR/$INSTALL_BASE/samba \
        installbin installscripts installcp installswat;
make prefix=$TMP_INSTDIR/usr/ \
        installman;
(cd intl; make prefix=$TMP_INSTDIR/$INSTALL_BASE/samba install); 
(cd po; make prefix=$TMP_INSTDIR/$INSTALL_BASE/samba install); 
)

# Set up the prototype file from the static_prototype
if [ -f prototype ]; then
	rm -f prototype
fi

# Set the INSTALL_BASE in pkginfo, samba.server
	cp pkginfo pkginfo.bak
	cp samba.server samba.server.bak
	sed "s|BASEDIR=.*|BASEDIR=$INSTALL_BASE|g" pkginfo.bak > pkginfo
	sed "s|BASE=.*|BASE=$INSTALL_BASE/samba|g" samba.server.bak > samba.server
	rm -f pkginfo.bak samba.server.bak

cp static_prototype prototype

# Add the dynamic part to the prototype file
(add_dynamic_entries >> prototype)

[ $? != 0 ] && exit 1

# Create the package
pkgmk -o -d /tmp -b $DISTR_BASE -f prototype
if [ $? = 0 ]
then
	pkgtrans /tmp samba.pkg samba
        echo The samba package is in /tmp
fi
rm -f prototype
rm -rf $TMP_INSTDIR
