/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.InputStream;
import com.opera.OutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;

public class URLConnection
extends HttpURLConnection {
    private final byte HTTP_METHOD_GET = 0;
    private final byte HTTP_METHOD_POST = 1;
    private final byte HTTP_METHOD_HEAD = (byte)2;
    private final byte HTTP_METHOD_CONNECT = (byte)3;
    private final byte HTTP_METHOD_PUT = (byte)4;
    private final byte HTTP_METHOD_OPTIONS = (byte)5;
    private final byte HTTP_METHOD_DELETE = (byte)6;
    private final byte HTTP_METHOD_TRACE = (byte)7;
    private InputStream is = new InputStream(this);
    private OutputStream os = new OutputStream();
    private boolean redirected = false;

    private byte getHTTPMethodInt() {
        if (this.method.compareTo("GET") == 0) {
            return 0;
        }
        if (this.method.compareTo("POST") == 0) {
            return 1;
        }
        if (this.method.compareTo("HEAD") == 0) {
            return 2;
        }
        if (this.method.compareTo("CONNECT") == 0) {
            return 3;
        }
        if (this.method.compareTo("PUT") == 0) {
            return 4;
        }
        if (this.method.compareTo("OPTIONS") == 0) {
            return 5;
        }
        if (this.method.compareTo("DELETE") == 0) {
            return 6;
        }
        if (this.method.compareTo("TRACE") == 0) {
            return 7;
        }
        return 0;
    }

    protected URLConnection(URL uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect() throws IOException {
        if (!this.connected) {
            SecurityManager securityManager;
            int n;
            String string = this.url.toString();
            if (this.url.getPort() == -1 && (n = string.indexOf(":-1")) != -1) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.delete(n, n + 3);
                string = stringBuffer.toString();
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                securityManager.checkConnect(this.url.getHost(), this.url.getPort());
            }
            byte by = this.getHTTPMethodInt();
            this.nativeConnect(string, by, this.is, this.os, this.os.makeExtraHeaders());
            if (by == 1) {
                this.connected = true;
            } else if (by == 0) {
                this.waitForHeaderLoaded();
                this.responseCode = this.is.getResponse();
                this.connected = this.responseCode < 400;
            } else {
                InputStream inputStream = this.is;
                synchronized (inputStream) {
                    this.is.headerLoaded(0, 200);
                }
                this.connected = true;
            }
        }
    }

    private native void nativeConnect(String var1, byte var2, InputStream var3, OutputStream var4, String var5);

    public java.io.InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.os.isClosed()) {
            this.os.close();
        }
        if (this.method.compareTo("POST") == 0) {
            if (this.is.getResponse() == -1) {
                this.waitForHeaderLoaded();
            }
            if (this.is.getResponse() >= 400) {
                this.connected = false;
                throw new FileNotFoundException(this.url.toString());
            }
            this.connected = true;
        } else if (this.is.getResponse() >= 400) {
            this.connected = false;
            throw new FileNotFoundException(this.url.toString());
        }
        return this.is;
    }

    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    public int getContentLength() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.is != null) {
            return this.is.getContentLength();
        }
        return 0;
    }

    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    public java.io.OutputStream getOutputStream() throws IOException {
        if (this.method == null || this.method.compareTo("PUT") != 0) {
            this.method = "POST";
        }
        if (!this.connected) {
            this.connect();
        }
        return this.os;
    }

    public int getHeaderFieldInt(String string, int n) {
        String string2 = this.getHeaderField(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public String getHeaderField(int n) {
        try {
            if (!this.connected) {
                this.connect();
            }
            this.waitForHeaderLoaded();
        }
        catch (Exception exception) {
            return null;
        }
        Enumeration enumeration = this.is.headerFields.elements();
        while (n >= 0 && enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (n == 0) {
                return (String)v;
            }
            --n;
        }
        return null;
    }

    public String getHeaderFieldKey(int n) {
        try {
            if (!this.connected) {
                this.connect();
            }
            this.waitForHeaderLoaded();
        }
        catch (Exception exception) {
            return null;
        }
        Enumeration enumeration = this.is.headerFields.keys();
        while (n >= 0 && enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (n == 0) {
                return (String)k;
            }
            --n;
        }
        return null;
    }

    public String getHeaderField(String string) {
        try {
            if (!this.connected) {
                this.connect();
            }
            this.waitForHeaderLoaded();
        }
        catch (Exception exception) {
            return null;
        }
        return (String)this.is.headerFields.get(string.toLowerCase());
    }

    public String getRequestProperty(String string) {
        return (String)this.os.reqProps.get(string);
    }

    public void setRequestProperty(String string, String string2) {
        if (string.compareToIgnoreCase("Content-type") == 0) {
            this.method = "POST";
        }
        if (string.compareToIgnoreCase("Content-length") != 0) {
            this.os.reqProps.put(string, string2);
        }
    }

    public void disconnect() {
    }

    public boolean usingProxy() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResponseCode() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        this.os.close();
        InputStream inputStream = this.is;
        synchronized (inputStream) {
            if (!this.is.isHeaderLoaded()) {
                this.waitForHeaderLoaded();
                this.responseCode = this.is.getResponse();
            }
        }
        return this.responseCode;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForHeaderLoaded() {
        try {
            InputStream inputStream = this.is;
            synchronized (inputStream) {
                if (!this.is.isHeaderLoaded()) {
                    SecurityManager securityManager;
                    this.is.wait();
                    if (this.redirected && (securityManager = System.getSecurityManager()) != null) {
                        securityManager.checkConnect(this.url.getHost(), this.url.getPort());
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (SecurityException securityException) {
            InputStream inputStream = this.is;
            synchronized (inputStream) {
                this.is.stopLoading();
            }
            throw securityException;
        }
    }

    protected void redirect(String string) {
        this.redirected = true;
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

