/**
 *  Copyright 2009 Opera Software ASA. All rights reserved.
 *
 * This file contains Original Code and/or Contributions to the Original 
 * Code as defined in the Opera Web Applications License (the License). 
 * You may not use this file except in compliance with the License. Please 
 * obtain a copy of the License at http://www.opera.com/license/owal/
 * and read it before using this file. 
 *
 * The Original Code and all Contributions to the Original Code distributed 
 * under the License are distributed on an AS IS basis, WITHOUT WARRANTY 
 * OF ANY KIND, EITHER EXPRESS OR IMPLIED, AND OPERA HEREBY DISCLAIMS ALL 
 * SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT. 
 *
 * Please see the License for the specific language governing rights and 
 * limitations under the License.
 */
 
Geonames = new (function(){
    var _self = this;
    
    _self.findWikiPagesNearBy = function( lat, lng, maxRows, language, format, callback )
    {
        var url = 'http://ws.geonames.org/findNearbyWikipedia' + (format=='json'? 'JSON' : '') + 
            '?lat=' + lat + '&lng=' + lng + '&style=full&lang=' + (language || 'en') +
            '&maxRows=' + (maxRows || 9);

        _makeRequest( url, function( request )
        {
            if( callback )
            {
                callback( format=='json' ? request.responseText : _parseData( request.responseXML ) );
            }
        });
    }
    
    function _parseData( data )
    {
        var geoData = [];
        
        if( data && data.documentElement )
        {
            var entries = data.getElementsByTagName( 'entry' );
            
            var entry;
            for( var i = 0; entry = entries[i]; i++)
            {
                geoData[i] = {};
                geoData[i].title        = entry.getFirstTagValue( 'title' );
                geoData[i].wikipediaUrl = entry.getFirstTagValue( 'wikipediaUrl' );
                geoData[i].distance     = entry.getFirstTagValue( 'distance' );
            }
        }
        
        return {'geonames': geoData};
    }

    function _makeRequest( url, callback )
    {
        var xhr = new XMLHttpRequest();
        
        xhr.open( 'GET', url, true );
        xhr.onreadystatechange = function( request )
        {
            if( request.readyState == 4 )
            {
                if( request.status !== 0 )
                {
                    if ( callback )
                    {
                        callback( request );
                    }
                }
                else
                {
                    //opera.postError ('error...');
                }
            }
        }
        
        xhr.send( null );
    }
    
    
    /**
     * Returns the value of the very first tag specified by tagName parameter.
     * 
     * @param {String} tagName
     */
    Node.prototype.getFirstTagValue = function(tagName)
    {
        var e = this.getElementsByTagName(tagName);
        if (e) e = e[0];
        if (e) e = e.firstChild;
        if (e) e = e.nodeValue;
        return e || '';
    }
    
});


