<?php
	$codes = array();
	$maxlen = 0;

	while (!feof(STDIN)) {
		$line = fgets(STDIN);

		if (ereg('^\{[[:space:]]+(ER_.*)[[:space:]]+,[[:space:]]*"(.*)",[[:space:]]*"(.*)"', $line, $matches)) {
			$codes[$matches[1]] = $matches[2];
			$maxlen = max($maxlen, strlen($matches[1]));
		}
	}

	if (empty($codes)) {
		fputs(STDERR, "input doesn't look like a MySQL sql_state.h file\n");
		exit(3);
	}
	
	echo "/* DO NOT EDIT THIS FILE!!! It is auto generated by get_error_codes.php */\n";
	foreach ($codes as $code => $state) {
		echo "#ifdef $code\n";
		printf("  case %-{$maxlen}s: return \"%s\";\n", $code, $state);
		echo "#endif\n";
	}

	
?>
