--TEST--
Test pow function : 64bit long tests
--SKIPIF--
<?php
if (PHP_INT_SIZE != 8) die("skip this test is for 64bit platform only");
?>
--FILE--
<?php

define("MAX_64Bit", 9223372036854775807);
define("MAX_32Bit", 2147483647);
define("MIN_64Bit", -9223372036854775807 - 1);
define("MIN_32Bit", -2147483647 - 1);

$longVals = array(
    MAX_64Bit, MIN_64Bit, MAX_32Bit, MIN_32Bit, MAX_64Bit - MAX_32Bit, MIN_64Bit - MIN_32Bit,
    MAX_32Bit + 1, MIN_32Bit - 1, MAX_32Bit * 2, (MAX_32Bit * 2) + 1, (MAX_32Bit * 2) - 1,
    MAX_64Bit -1, MAX_64Bit + 1, MIN_64Bit + 1, MIN_64Bit - 1
);

$otherVals = array(0, 1, -1, 7, 9, 65, -44, MAX_32Bit, MIN_32Bit, MAX_64Bit, MIN_64Bit);


foreach ($longVals as $longVal) {
   foreach($otherVals as $otherVal) {
	   echo "--- testing: $longVal, $otherVal ---\n";
      var_dump(pow($longVal, $otherVal));
   }
}

?>
===DONE===
--EXPECT--
--- testing: 9223372036854775807, 0 ---
int(1)
--- testing: 9223372036854775807, 1 ---
int(9223372036854775807)
--- testing: 9223372036854775807, -1 ---
float(1.0842021724855E-19)
--- testing: 9223372036854775807, 7 ---
float(5.6784275335594E+132)
--- testing: 9223372036854775807, 9 ---
float(4.8306719037716E+170)
--- testing: 9223372036854775807, 65 ---
float(INF)
--- testing: 9223372036854775807, -44 ---
float(0)
--- testing: 9223372036854775807, 2147483647 ---
float(INF)
--- testing: 9223372036854775807, -2147483648 ---
float(0)
--- testing: 9223372036854775807, 9223372036854775807 ---
float(INF)
--- testing: 9223372036854775807, -9223372036854775808 ---
float(0)
--- testing: -9223372036854775808, 0 ---
int(1)
--- testing: -9223372036854775808, 1 ---
int(-9223372036854775808)
--- testing: -9223372036854775808, -1 ---
float(-1.0842021724855E-19)
--- testing: -9223372036854775808, 7 ---
float(-5.6784275335594E+132)
--- testing: -9223372036854775808, 9 ---
float(-4.8306719037716E+170)
--- testing: -9223372036854775808, 65 ---
float(-INF)
--- testing: -9223372036854775808, -44 ---
float(0)
--- testing: -9223372036854775808, 2147483647 ---
float(-INF)
--- testing: -9223372036854775808, -2147483648 ---
float(0)
--- testing: -9223372036854775808, 9223372036854775807 ---
float(-INF)
--- testing: -9223372036854775808, -9223372036854775808 ---
float(0)
--- testing: 2147483647, 0 ---
int(1)
--- testing: 2147483647, 1 ---
int(2147483647)
--- testing: 2147483647, -1 ---
float(4.6566128752458E-10)
--- testing: 2147483647, 7 ---
float(2.1062458265056E+65)
--- testing: 2147483647, 9 ---
float(9.7133444204205E+83)
--- testing: 2147483647, 65 ---
float(INF)
--- testing: 2147483647, -44 ---
float(0)
--- testing: 2147483647, 2147483647 ---
float(INF)
--- testing: 2147483647, -2147483648 ---
float(0)
--- testing: 2147483647, 9223372036854775807 ---
float(INF)
--- testing: 2147483647, -9223372036854775808 ---
float(0)
--- testing: -2147483648, 0 ---
int(1)
--- testing: -2147483648, 1 ---
int(-2147483648)
--- testing: -2147483648, -1 ---
float(-4.6566128730774E-10)
--- testing: -2147483648, 7 ---
float(-2.1062458333711E+65)
--- testing: -2147483648, 9 ---
float(-9.7133444611286E+83)
--- testing: -2147483648, 65 ---
float(-INF)
--- testing: -2147483648, -44 ---
float(0)
--- testing: -2147483648, 2147483647 ---
float(-INF)
--- testing: -2147483648, -2147483648 ---
float(0)
--- testing: -2147483648, 9223372036854775807 ---
float(-INF)
--- testing: -2147483648, -9223372036854775808 ---
float(0)
--- testing: 9223372034707292160, 0 ---
int(1)
--- testing: 9223372034707292160, 1 ---
int(9223372034707292160)
--- testing: 9223372034707292160, -1 ---
float(1.0842021727379E-19)
--- testing: 9223372034707292160, 7 ---
float(5.6784275243046E+132)
--- testing: 9223372034707292160, 9 ---
float(4.830671893649E+170)
--- testing: 9223372034707292160, 65 ---
float(INF)
--- testing: 9223372034707292160, -44 ---
float(0)
--- testing: 9223372034707292160, 2147483647 ---
float(INF)
--- testing: 9223372034707292160, -2147483648 ---
float(0)
--- testing: 9223372034707292160, 9223372036854775807 ---
float(INF)
--- testing: 9223372034707292160, -9223372036854775808 ---
float(0)
--- testing: -9223372034707292160, 0 ---
int(1)
--- testing: -9223372034707292160, 1 ---
int(-9223372034707292160)
--- testing: -9223372034707292160, -1 ---
float(-1.0842021727379E-19)
--- testing: -9223372034707292160, 7 ---
float(-5.6784275243046E+132)
--- testing: -9223372034707292160, 9 ---
float(-4.830671893649E+170)
--- testing: -9223372034707292160, 65 ---
float(-INF)
--- testing: -9223372034707292160, -44 ---
float(0)
--- testing: -9223372034707292160, 2147483647 ---
float(-INF)
--- testing: -9223372034707292160, -2147483648 ---
float(0)
--- testing: -9223372034707292160, 9223372036854775807 ---
float(-INF)
--- testing: -9223372034707292160, -9223372036854775808 ---
float(0)
--- testing: 2147483648, 0 ---
int(1)
--- testing: 2147483648, 1 ---
int(2147483648)
--- testing: 2147483648, -1 ---
float(4.6566128730774E-10)
--- testing: 2147483648, 7 ---
float(2.1062458333711E+65)
--- testing: 2147483648, 9 ---
float(9.7133444611286E+83)
--- testing: 2147483648, 65 ---
float(INF)
--- testing: 2147483648, -44 ---
float(0)
--- testing: 2147483648, 2147483647 ---
float(INF)
--- testing: 2147483648, -2147483648 ---
float(0)
--- testing: 2147483648, 9223372036854775807 ---
float(INF)
--- testing: 2147483648, -9223372036854775808 ---
float(0)
--- testing: -2147483649, 0 ---
int(1)
--- testing: -2147483649, 1 ---
int(-2147483649)
--- testing: -2147483649, -1 ---
float(-4.656612870909E-10)
--- testing: -2147483649, 7 ---
float(-2.1062458402367E+65)
--- testing: -2147483649, 9 ---
float(-9.7133445018368E+83)
--- testing: -2147483649, 65 ---
float(-INF)
--- testing: -2147483649, -44 ---
float(0)
--- testing: -2147483649, 2147483647 ---
float(-INF)
--- testing: -2147483649, -2147483648 ---
float(0)
--- testing: -2147483649, 9223372036854775807 ---
float(-INF)
--- testing: -2147483649, -9223372036854775808 ---
float(0)
--- testing: 4294967294, 0 ---
int(1)
--- testing: 4294967294, 1 ---
int(4294967294)
--- testing: 4294967294, -1 ---
float(2.3283064376229E-10)
--- testing: 4294967294, 7 ---
float(2.6959946579271E+67)
--- testing: 4294967294, 9 ---
float(4.9732323432553E+86)
--- testing: 4294967294, 65 ---
float(INF)
--- testing: 4294967294, -44 ---
float(0)
--- testing: 4294967294, 2147483647 ---
float(INF)
--- testing: 4294967294, -2147483648 ---
float(0)
--- testing: 4294967294, 9223372036854775807 ---
float(INF)
--- testing: 4294967294, -9223372036854775808 ---
float(0)
--- testing: 4294967295, 0 ---
int(1)
--- testing: 4294967295, 1 ---
int(4294967295)
--- testing: 4294967295, -1 ---
float(2.3283064370808E-10)
--- testing: 4294967295, 7 ---
float(2.6959946623211E+67)
--- testing: 4294967295, 9 ---
float(4.9732323536766E+86)
--- testing: 4294967295, 65 ---
float(INF)
--- testing: 4294967295, -44 ---
float(0)
--- testing: 4294967295, 2147483647 ---
float(INF)
--- testing: 4294967295, -2147483648 ---
float(0)
--- testing: 4294967295, 9223372036854775807 ---
float(INF)
--- testing: 4294967295, -9223372036854775808 ---
float(0)
--- testing: 4294967293, 0 ---
int(1)
--- testing: 4294967293, 1 ---
int(4294967293)
--- testing: 4294967293, -1 ---
float(2.328306438165E-10)
--- testing: 4294967293, 7 ---
float(2.6959946535332E+67)
--- testing: 4294967293, 9 ---
float(4.973232332834E+86)
--- testing: 4294967293, 65 ---
float(INF)
--- testing: 4294967293, -44 ---
float(0)
--- testing: 4294967293, 2147483647 ---
float(INF)
--- testing: 4294967293, -2147483648 ---
float(0)
--- testing: 4294967293, 9223372036854775807 ---
float(INF)
--- testing: 4294967293, -9223372036854775808 ---
float(0)
--- testing: 9223372036854775806, 0 ---
int(1)
--- testing: 9223372036854775806, 1 ---
int(9223372036854775806)
--- testing: 9223372036854775806, -1 ---
float(1.0842021724855E-19)
--- testing: 9223372036854775806, 7 ---
float(5.6784275335594E+132)
--- testing: 9223372036854775806, 9 ---
float(4.8306719037716E+170)
--- testing: 9223372036854775806, 65 ---
float(INF)
--- testing: 9223372036854775806, -44 ---
float(0)
--- testing: 9223372036854775806, 2147483647 ---
float(INF)
--- testing: 9223372036854775806, -2147483648 ---
float(0)
--- testing: 9223372036854775806, 9223372036854775807 ---
float(INF)
--- testing: 9223372036854775806, -9223372036854775808 ---
float(0)
--- testing: 9.2233720368548E+18, 0 ---
float(1)
--- testing: 9.2233720368548E+18, 1 ---
float(9.2233720368548E+18)
--- testing: 9.2233720368548E+18, -1 ---
float(1.0842021724855E-19)
--- testing: 9.2233720368548E+18, 7 ---
float(5.6784275335594E+132)
--- testing: 9.2233720368548E+18, 9 ---
float(4.8306719037716E+170)
--- testing: 9.2233720368548E+18, 65 ---
float(INF)
--- testing: 9.2233720368548E+18, -44 ---
float(0)
--- testing: 9.2233720368548E+18, 2147483647 ---
float(INF)
--- testing: 9.2233720368548E+18, -2147483648 ---
float(0)
--- testing: 9.2233720368548E+18, 9223372036854775807 ---
float(INF)
--- testing: 9.2233720368548E+18, -9223372036854775808 ---
float(0)
--- testing: -9223372036854775807, 0 ---
int(1)
--- testing: -9223372036854775807, 1 ---
int(-9223372036854775807)
--- testing: -9223372036854775807, -1 ---
float(-1.0842021724855E-19)
--- testing: -9223372036854775807, 7 ---
float(-5.6784275335594E+132)
--- testing: -9223372036854775807, 9 ---
float(-4.8306719037716E+170)
--- testing: -9223372036854775807, 65 ---
float(-INF)
--- testing: -9223372036854775807, -44 ---
float(0)
--- testing: -9223372036854775807, 2147483647 ---
float(-INF)
--- testing: -9223372036854775807, -2147483648 ---
float(0)
--- testing: -9223372036854775807, 9223372036854775807 ---
float(-INF)
--- testing: -9223372036854775807, -9223372036854775808 ---
float(0)
--- testing: -9.2233720368548E+18, 0 ---
float(1)
--- testing: -9.2233720368548E+18, 1 ---
float(-9.2233720368548E+18)
--- testing: -9.2233720368548E+18, -1 ---
float(-1.0842021724855E-19)
--- testing: -9.2233720368548E+18, 7 ---
float(-5.6784275335594E+132)
--- testing: -9.2233720368548E+18, 9 ---
float(-4.8306719037716E+170)
--- testing: -9.2233720368548E+18, 65 ---
float(-INF)
--- testing: -9.2233720368548E+18, -44 ---
float(0)
--- testing: -9.2233720368548E+18, 2147483647 ---
float(-INF)
--- testing: -9.2233720368548E+18, -2147483648 ---
float(0)
--- testing: -9.2233720368548E+18, 9223372036854775807 ---
float(INF)
--- testing: -9.2233720368548E+18, -9223372036854775808 ---
float(0)
===DONE===
